#include <16f628a.h>
#use delay (clock=12000000)
#fuses NOWDT,NOPROTECT,NOPUT,BROWNOUT,NOLVP, NOMCLR
#include <kijelzo.h>
#define XTAL_FREQUENCY  12000000 //kristly frekvencija Hertzben
#define TIMER1_FREQUENCY (XTAL_FREQUENCY / 4)
int32 Ticker;
char mp, ora, perc, ebresztes_ora, ebresztes_perc, szundi_ora, szundi_perc;

#define GOMB_ORA_RADIO PIN_B4
#define GOMB_PERC_KIJELZO PIN_B5
#define GOMB_ORA PIN_A3
#define GOMB_EBRESZTO PIN_A0
#define GOMB_SZUNDI PIN_A1
#define RADIO PIN_A2
#define LED PIN_B3

/*
ra bellts:
   Nyomd le s tartsd lent az ra/breszt ki-be gombot s tartsd lent! Most az ra/Rdi
   gombal lehet az rt nvelni. A Perc/Kijelz gombal pedig a percet lehet nvelni. 
   Az ra akkor indul el, ha flengeded az ra/breszt gombot. (Ilyenkor 0-rl indul a
   msodperc s gy idzithet mp pontosan az ra)
breszts bellts:
   Nyomd le s tartsd lent az breszt gombot. Most az ra/Rdi
   gombal lehet az rt nvelni. A Perc/Kijelz gombal pedig a percet lehet nvelni.
   Az ra/breszt gombal lehet ki-be kapcsolni az bresztt, amit egy zld led nyuktz.
   bresztskor a rdi s a kijelz is bekapcsol.
Szundi bellts:
   Nyomd le s tartsd lent a Szundi ki-be gombot s tartsd lent! Most az ra/Rdi
   gombal lehet az rt nvelni. A Perc/Kijelz gombal pedig a percet lehet nvelni.
   Amikor flengeded a Szundi gombot, akkor aktivldik a szundi funkci s elkezd
   visszafel szmolni. Ha lejrt a megadott id a rdi s a kijelz is kikapcsol.
Rdi ki-be: 
   Az ra/Rdi gombal trtnik.
Kijelz ki-be:
   A Perc/Kijelz gombal ttnik.
*/

void inits(void){
//===========================================================================
        Ticker = TIMER1_FREQUENCY;
        setup_timer_1( T1_INTERNAL | T1_DIV_BY_1 );
        enable_interrupts( INT_TIMER1 );
        enable_interrupts( GLOBAL );
}

#int_TIMER1
void TIMER1_isr(){
//=================== hall pontos 1 mp-es idzt ==========================
        Ticker -= 65535;
        if ( Ticker < 65536 ) {
                Ticker += TIMER1_FREQUENCY;
                mp++;
                write_eeprom(4, mp);
        }
}
//=============================================================================

void frissites(char mit){
   //ezzel fv -el lehet a kijelzt frissiteni
   switch(mit){
            case 1: ido(ebresztes_ora, ebresztes_perc); break; //breszts
            case 2: ido(szundi_ora, szundi_perc);break; //szundi
            default: ido(ora,perc);
         }
   write_eeprom(0,ora);
   write_eeprom(1,perc);
}

void main(void){
   char sv;
   char mit=0; //mit rjon ki: id, breszts, szundi id
   int1 ebresztes=1;
   int1 szundi=0; //ha aktv a szundi funkci
   
   ora = read_eeprom(0);
   perc = read_eeprom(1);
   ebresztes_ora = read_eeprom(2);
   ebresztes_perc = read_eeprom(3);
   mp = read_eeprom(4);
  
   inits();
   frissites(mit);
   
   while(true){ 
      delay_ms(10); //kicsit pihentessk a PIC et
      
      //vltsok
      if(mp >= 60) {
         if(szundi == 1){
            szundi_perc--;
            if(szundi_perc == -1 && szundi_ora > 0){
               szundi_ora--;
               szundi_perc = 59;
            }
         }
         perc++; 
         mp=0; 
         frissites(mit);
      }
      if(perc >= 60) {ora++; perc=0; frissites(mit); }
      if(ora >= 24) {ora=0; frissites(mit); }
      
      //breszts
      if(ora == ebresztes_ora && perc == ebresztes_perc && ebresztes == 1 && input(GOMB_EBRESZTO)) {
         output_high(RADIO); 
         kj=1;
         ebresztes = 0;
      }
      
      //szundi
      if(szundi_perc == 0 && szundi_ora == 0 && szundi == 1) {
         output_low(RADIO); 
         kj=0;
         szundi=0;
      }
      
      //gombok
         //ra bellts
      if(!input(GOMB_ORA) && input(GOMB_EBRESZTO)) 
         mp =0;
      if(!input(GOMB_ORA_RADIO) && !input(GOMB_ORA)){
         ora++;
         if(ora >= 24) ora = 0;
         frissites(mit);
         sv=0;
         while(!input(GOMB_ORA_RADIO) && !input(GOMB_ORA)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_ORA_RADIO) && !input(GOMB_ORA)){
            ora++;
            if(ora >= 24) ora = 0;
            frissites(mit);
            delay_ms(50);
         }
      }      
      if(!input(GOMB_PERC_KIJELZO) && !input(GOMB_ORA)){
         perc++;
         if(perc >= 60) perc = 0;
         frissites(mit);
         sv=0;
         while(!input(GOMB_PERC_KIJELZO) && !input(GOMB_ORA)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_PERC_KIJELZO) && !input(GOMB_ORA)){
            perc++;
            if(perc >= 60) perc = 0;
            frissites(mit);
            delay_ms(50);
         }
      }
      
      //breszt bellts
      if(ebresztes == 1) output_high(LED);
      else output_low(LED);
      //breszt ki-be
      if(!input(GOMB_EBRESZTO) && !input(GOMB_ORA)){
         if(ebresztes == 0) ebresztes = 1;
         else ebresztes = 0;
         while(!input(GOMB_EBRESZTO) && !input(GOMB_ORA));
      }
      if(!input(GOMB_EBRESZTO) && mit != 1){
         mit=1;
         ebresztes = 1;
         frissites(mit);
      }
      else if(input(GOMB_EBRESZTO) && mit==1){
         mit=0; 
         frissites(mit);
         write_eeprom(2, ebresztes_ora);
         write_eeprom(3, ebresztes_perc);
      }
      if(!input(GOMB_EBRESZTO) && !input(GOMB_ORA_RADIO)){
         ebresztes_ora++;
         if(ebresztes_ora >= 24) ebresztes_ora=0;
         frissites(mit);
         while(!input(GOMB_EBRESZTO) && !input(GOMB_ORA_RADIO)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_EBRESZTO) && !input(GOMB_ORA_RADIO)){
            ebresztes_ora++;
            if(ebresztes_ora >= 24) ebresztes_ora=0;
            frissites(mit);
            delay_ms(50);
         }
      }
      if(!input(GOMB_EBRESZTO) && !input(GOMB_PERC_KIJELZO)){
         ebresztes_perc++;
         if(ebresztes_perc >= 60) ebresztes_perc=0;
         frissites(mit);
         while(!input(GOMB_EBRESZTO) && !input(GOMB_PERC_KIJELZO)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_EBRESZTO) && !input(GOMB_PERC_KIJELZO)){
            ebresztes_perc++;
            if(ebresztes_perc >= 60) ebresztes_perc=0;
            frissites(mit);
            delay_ms(50);
         }
      }
      
      //rdi ki-be
      if(input(GOMB_ORA) && input(GOMB_EBRESZTO) && input(GOMB_SZUNDI) && !input(GOMB_ORA_RADIO)){
         output_toggle(RADIO);
         while(input(GOMB_ORA) && input(GOMB_EBRESZTO) && input(GOMB_SZUNDI) && !input(GOMB_ORA_RADIO));
      }
      
      //kijelz ki-be
      if(input(GOMB_ORA) && input(GOMB_EBRESZTO) && input(GOMB_SZUNDI) && !input(GOMB_PERC_KIJELZO)){
         kj_toggle();
         frissites(mit);
         while(input(GOMB_ORA) && input(GOMB_EBRESZTO) && input(GOMB_SZUNDI) && !input(GOMB_PERC_KIJELZO));
      }
      
      //szundi
      if(!input(GOMB_SZUNDI) && mit != 2){
         mit = 2;
         frissites(mit);
      }
      else if(input(GOMB_SZUNDI) && mit==2){
         mit=0; 
         frissites(mit);
         if(szundi_ora != 0 || szundi_perc != 0) szundi = 1;
      }
      
      if(!input(GOMB_SZUNDI) && !input(GOMB_ORA_RADIO)){
         szundi_ora++;
         if(szundi_ora >=24) szundi_ora=0;
         frissites(mit);
         while(!input(GOMB_SZUNDI) && !input(GOMB_ORA_RADIO)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_SZUNDI) && !input(GOMB_ORA_RADIO)){
            szundi_ora++;
            if(szundi_ora >=24) szundi_ora=0;
            frissites(mit);
            delay_ms(50);
         }
      }
      if(!input(GOMB_SZUNDI) && !input(GOMB_PERC_KIJELZO)){
         szundi_perc++;
         if(szundi_perc >=60) { szundi_perc=0; szundi_ora++; }
         frissites(mit);
         while(!input(GOMB_SZUNDI) && !input(GOMB_PERC_KIJELZO)){
            delay_ms(10);
            sv++; 
            if(sv == 100) break;
         }
         while(!input(GOMB_SZUNDI) && !input(GOMB_PERC_KIJELZO)){
            szundi_perc++;
            if(szundi_perc >=60) { szundi_perc=0; szundi_ora++; }
            frissites(mit);
            delay_ms(50);
         }
      }
      
   }
}
