<?
int usartNum     = I("usart:usart");
string usartName = "USART"+S("usart:usart");
int baud         = I("usart:usart0:baud");
int realbaud     = I("usart:usart0:realbaud");
string usartErr  = S("usart:usart0:err");
?>// -------------
// --- usart ---
// -------------

// the values are calculated with AvrWiz for <?$cpu:cpu?> @ <?$cpu:mhz?> mhz
// <?P(usartName);?> settings: <?P(baud);?> baud <?$usart:usart0:databits?>-<?$usart:usart0:parity?>-<?$usart:usart0:stopbits?>
<?if (baud != realbaud) P("// !!! warning !!! real baud = "+realbaud+", err = "+usartErr+"% !!!\r\n");
if (B("usart:usart0:rxbuffer") && I("usart:usart0:databits") < 9) show(); else hide();?>
#define <?P(usartName);?>_InSize <?$usart:usart0:rxbuflen?>
static unsigned char <?P(usartName);?>_InBuf[<?P(usartName);?>_InSize];
static volatile unsigned char <?P(usartName);?>_InPos = 0;
static volatile unsigned char <?P(usartName);?>_OutPos = 0;

// <?P(usartName);?> RX Complete
ISR(<?$usart:usart0:irq_rx?>_vect)
{
	<?P(usartName);?>_InBuf[<?P(usartName);?>_InPos++] = <?$usart:usart0:cpu_udr?>;
	if (<?P(usartName);?>_InPos >= <?P(usartName);?>_InSize) <?P(usartName);?>_InPos = 0;
}
<?if (B("usart:usart0:rxbuffer") && I("usart:usart0:databits") >= 9) show(); else hide();?>
#define <?P(usartName);?>_InSize <?$usart:usart0:rxbuflen?>
static unsigned int <?P(usartName);?>_InBuf[<?P(usartName);?>_InSize];
static volatile unsigned char <?P(usartName);?>_InPos = 0;
static volatile unsigned char <?P(usartName);?>_OutPos = 0;

// <?P(usartName);?> RX Complete
ISR(<?$usart:usart0:irq_rx?>_vect)
{
	unsigned char status = <?$usart:usart0:cpu_ucsra?>;
	unsigned char h = (<?$usart:usart0:cpu_ucsrb?>>>1) & 0x01;
	unsigned char l = <?$usart:usart0:cpu_udr?>;
	if (status & ((1<<<?$usart:usart0:cpu_fe?>) | (1<<<?$usart:usart0:cpu_dor?>) | (1<<<?$usart:usart0:cpu_pe?>))) <?P(usartName);?>_InBuf[<?P(usartName);?>_InPos++] = -1;
	else <?P(usartName);?>_InBuf[<?P(usartName);?>_InPos++] = (h<<8) | l;
	if (<?P(usartName);?>_InPos >= <?P(usartName);?>_InSize) <?P(usartName);?>_InPos = 0;
}
<?if (B("usart:usart0:rx") && B("usart:interrupts") && !B("usart:usart0:rxbuffer")) show(); else hide();?>
// <?P(usartName);?> RX Complete
ISR(<?$usart:usart0:irq_rx?>_vect)
{
}
<?if (B("usart:usart0:tx") && B("usart:interrupts")) show(); else hide();?>
// <?P(usartName);?> TX Complete
ISR(<?$usart:usart0:irq_tx?>_vect)
{
}
<?if (B("usart:usart0:tx") && B("usart:interrupts")) show(); else hide();?>
// <?P(usartName);?> Data Register Empty
ISR(<?$usart:usart0:irq_de?>_vect)
{
}
<?show();?>
void <?P(usartName);?>_init()
{
	// Set baud rate
	<?$usart:usart0:cpu_ubrrh?> = <?$usart:usart0:v_ubrrh?>;
	<?$usart:usart0:cpu_ubrrl?> = <?$usart:usart0:v_ubrrl?>;
	<?$usart:usart0:cpu_ucsra?> = <?$usart:usart0:v_ucsra?>;
	// Enable receiver and transmitter
	<?$usart:usart0:cpu_ucsrb?> = <?P(S("usart:usart0:v_ucsrb"+(B("usart:interrupts")?":interrupts":"")));?>;
	// Set frame format
	<?$usart:usart0:cpu_ucsrc?> = <?$usart:usart0:v_ucsrc?>;
}
<?if (B("usart:usart0:tx") && I("usart:usart0:databits") < 9) show(); else hide();?>
void <?P(usartName);?>_write(unsigned char data)
{
	// Wait for empty transmit buffer
	while ( !( <?$usart:usart0:cpu_ucsra?> & (1<<<?$usart:usart0:cpu_udre?>)) ) ;
	// Put data into buffer, sends the data
	<?$usart:usart0:cpu_udr?> = data;
}
<?if (B("usart:usart0:tx") && I("usart:usart0:databits") >= 9) show(); else hide();?>
void <?P(usartName);?>_write(unsigned int data)
{
	// Wait for empty transmit buffer
	while ( !( <?$usart:usart0:cpu_ucsra?> & (1<<<?$usart:usart0:cpu_udre?>)) ) ;
	// Copy ninth bit to <?$usart:usart0:cpu_txb8?>
	<?$usart:usart0:cpu_ucsrb?> &= ~(1<<<?$usart:usart0:cpu_txb8?>);
	if ( data & 0x0100 )
	<?$usart:usart0:cpu_ucsrb?> |= (1<<<?$usart:usart0:cpu_txb8?>);
	// Put data into buffer, sends the data
	<?$usart:usart0:cpu_udr?> = data;
}
<?if (B("usart:usart0:rx") && !B("usart:usart0:rxbuffer") && I("usart:usart0:databits") < 9) show(); else hide();?>
unsigned char <?P(usartName);?>_read()
{
	// Wait for data to be received
	while ( !(<?$usart:usart0:cpu_ucsra?> & (1<<<?$usart:usart0:cpu_rxc?>)) );
	// Get and return received data from buffer
	return <?$usart:usart0:cpu_udr?>;
}
<?if (B("usart:usart0:rx") && !B("usart:usart0:rxbuffer") && I("usart:usart0:databits") >= 9) show(); else hide();?>
unsigned int <?P(usartName);?>_read()
{
	unsigned char status, resh, resl;
	// Wait for data to be received
	while ( !(<?$usart:usart0:cpu_ucsra?> & (1<<<?$usart:usart0:cpu_rxc?>)) );
	// Get status and ninth bit, then data from buffer
	status = <?$usart:usart0:cpu_ucsra?>;
	resh = <?$usart:usart0:cpu_ucsrb?>;
	resl = <?$usart:usart0:cpu_udr?>;
	// If error, return -1
	if ( status & (1<<<?$usart:usart0:cpu_fe?>)|(1<<<?$usart:usart0:cpu_dor?>)|(1<<<?$usart:usart0:cpu_pe?>) )
		return -1;
	// Filter the ninth bit, then return
	resh = (resh >> 1) & 0x01;
	return ((resh << 8) | resl);
}
<?if (B("usart:usart0:rxbuffer") && I("usart:usart0:databits") < 9) show(); else hide();?>
unsigned char <?P(usartName);?>_read(void)
{
	unsigned char c;
	while (<?P(usartName);?>_InPos == <?P(usartName);?>_OutPos) sleep();
	c = <?P(usartName);?>_InBuf[<?P(usartName);?>_OutPos++];
	if (<?P(usartName);?>_OutPos >= <?P(usartName);?>_InSize) <?P(usartName);?>_OutPos = 0;
	return c;
}
<?if (B("usart:usart0:rxbuffer") && I("usart:usart0:databits") >= 9) show(); else hide();?>
unsigned int <?P(usartName);?>_read(void)
{
	unsigned int c;
	while (<?P(usartName);?>_InPos == <?P(usartName);?>_OutPos) sleep();
	c = <?P(usartName);?>_InBuf[<?P(usartName);?>_OutPos++];
	if (<?P(usartName);?>_OutPos >= <?P(usartName);?>_InSize) <?P(usartName);?>_OutPos = 0;
	return c;
}
<?show();P("\r\n\r\n// generated by AvrWiz on "+System.DateTime.Now);?>
<?if (B("usart:help")) show(); else hide();?>
/*
USARTControl properties:
	num = <?$usart:usart0:num?>
	baud = <?$usart:usart0:baud?>
	databits = <?$usart:usart0:databits?>
	parity = <?$usart:usart0:parity?>
	stopbits = <?$usart:usart0:stopbits?>
	rx = <?$usart:usart0:rx?>
	tx = <?$usart:usart0:tx?>
	rxbuffer = <?$usart:usart0:rxbuffer?>
	rxbuflen = <?$usart:usart0:rxbuflen?>
	realbaud = <?$usart:usart0:realbaud?>
	err = <?$usart:usart0:err?>
	v_u2x = <?$usart:usart0:v_u2x?>
	v_ubrr = <?$usart:usart0:v_ubrr?>
	v_ubrrh = <?$usart:usart0:v_ubrrh?>
	v_ubrrl = <?$usart:usart0:v_ubrrl?>
	v_ucsra = <?$usart:usart0:v_ucsra?>
	v_ucsrb = <?$usart:usart0:v_ucsrb?>
	v_ucsrc = <?$usart:usart0:v_ucsrc?>
	irq_rx = <?$usart:usart0:irq_rx?>
	irq_tx = <?$usart:usart0:irq_tx?>
	irq_de = <?$usart:usart0:irq_de?>
	cpu_num = <?$usart:usart0:cpu_num?>
	cpu_ubrrh = <?$usart:usart0:cpu_ubrrh?>
	cpu_ubrrl = <?$usart:usart0:cpu_ubrrl?>
	cpu_udr = <?$usart:usart0:cpu_udr?>
	cpu_u2x = <?$usart:usart0:cpu_u2x?>
	cpu_udre = <?$usart:usart0:cpu_udre?>
	cpu_ucsra = <?$usart:usart0:cpu_ucsra?>
	cpu_ucsrb = <?$usart:usart0:cpu_ucsrb?>
	cpu_ucsrc = <?$usart:usart0:cpu_ucsrc?>
	cpu_ursel = <?$usart:usart0:cpu_ursel?>
	cpu_rxen = <?$usart:usart0:cpu_rxen?>
	cpu_txen = <?$usart:usart0:cpu_txen?>
	cpu_rxb8 = <?$usart:usart0:cpu_rxb8?>
	cpu_txb8 = <?$usart:usart0:cpu_txb8?>
	cpu_rxc = <?$usart:usart0:cpu_rxc?>
	cpu_ucsz0 = <?$usart:usart0:cpu_ucsz0?>
	cpu_ucsz1 = <?$usart:usart0:cpu_ucsz1?>
	cpu_ucsz2 = <?$usart:usart0:cpu_ucsz2?>
	cpu_upm0 = <?$usart:usart0:cpu_upm0?>
	cpu_upm1 = <?$usart:usart0:cpu_upm1?>
	cpu_usbs = <?$usart:usart0:cpu_usbs?>
	cpu_rxcie = <?$usart:usart0:cpu_rxcie?>
	cpu_txcie = <?$usart:usart0:cpu_txcie?>
	cpu_fe = <?$usart:usart0:cpu_fe?>
	cpu_dor = <?$usart:usart0:cpu_dor?>
	cpu_pe = <?$usart:usart0:cpu_pe?>
*/
<?show();?>