<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xml:space="default">
	<xsl:output method="html" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd" />
	<xsl:strip-space elements="*"/>

	<xsl:template match="/">
		<table border="1">
			<tr>
				<th>name</th>
				<th>max mhz</th>
				<th>voltage</th>
				<th>ram</th>
				<th>rom</th>
				<th>eeprom</th>
			</tr>
			<xsl:for-each select="/cpus/cpu">
				<tr>
					<td><xsl:value-of select="@name"/><xsl:if test="string-length(@inherit) &gt; 0"> (<xsl:value-of select="@inherit"/>)</xsl:if></td>
					<td><xsl:value-of select="@maxspeed div 1000000"/></td>
					<td><xsl:value-of select="@voltage"/></td>
					<td><xsl:value-of select="ram/@start"/> - <xsl:value-of select="ram/@end"/></td>
					<td><xsl:value-of select="rom/@start"/> - <xsl:value-of select="rom/@end"/></td>
					<td><xsl:value-of select="eeprom/@start"/> - <xsl:value-of select="eeprom/@end"/></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

</xsl:stylesheet>
