<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xml:space="default">
	<xsl:output method="html" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd" />
	<xsl:strip-space elements="*"/>

	<xsl:template match="/">
		<table border="1">
			<tr>
				<th>core</th>
				<th>cpu</th>
				<th>speed</th>
				<th>signature</th>
				<th>rom</th>
				<th>int. ram</th>
				<th>ext. ram</th>
				<th>eeprom</th>
<!--
				<th>power (active/idle/power down)</th>
-->
			</tr>
		<xsl:for-each select="/atmel/AVRPART">
			<xsl:sort select="CORE/CORE_VERSION" order="ascending" data-type="text"/>
			<xsl:sort select="ADMIN/PART_NAME" order="ascending" data-type="text"/>
			<tr>
				<td><xsl:value-of select="CORE/CORE_VERSION"/></td>
				<td><xsl:value-of select="ADMIN/PART_NAME"/></td>
				<td><xsl:value-of select="ADMIN/SPEED"/></td>
				<td><xsl:value-of select="ADMIN/SIGNATURE"/></td>
				<td><xsl:value-of select="MEMORY/PROG_FLASH"/></td>
				<td><xsl:value-of select="MEMORY/INT_SRAM/SIZE"/></td>
				<td><xsl:value-of select="MEMORY/EXT_SRAM/SIZE"/></td>
				<td><xsl:value-of select="MEMORY/EEPROM"/></td>
<!--
				<td>
					<xsl:value-of select="POWER/CLOCK"/>/<xsl:value-of select="POWER/TEMP"/>:
					<xsl:value-of select="POWER/ACTIVE"/>/
					<xsl:value-of select="POWER/IDLE"/>/
					<xsl:value-of select="POWER/POWER_DOWN"/>
				</td>
-->
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>

	<cpu name="ATmega8" maxspeed="16000000" voltage="5" mcusr="MCUCSR" wdtcsr="WDTCR" spi="true" reset="rjmp"></cpu>

</xsl:stylesheet>
