// generated with AvrWiz <?$version?> (by g@greschenz.de)
// -----------------------------------------
// cpu:     <?$cpu:cpu?>
// speed:   <?$cpu:mhz?> mhz (max: <?P(""+I("cpu:maxspeed")/1000000);?> mhz)
// voltage: <?$cpu:voltage?> V
// ram:     <?$cpu:ramsize?> bytes (<?$cpu:ramstart?>-<?$cpu:ramend?>)
// rom:     <?$cpu:romsize?> bytes (<?$cpu:romstart?>-<?$cpu:romend?>)
// eeprom:  <?$cpu:eepromsize?> bytes (<?$cpu:eepromstart?>-<?$cpu:eepromend?>)
// -----------------------------------------
/*
<?$projectinfo?>
*/
// -----------------------------------------

<?P(S("debug") == "true" ? "#define DEBUG\r\n" : "");?>
#include <avr/io.h>
#include <avr/interrupt.h>

#if !defined (__AVR_<?$cpu:basecpu?>__)
#error __AVR_<?$cpu:basecpu?>__ not defined !
#endif

#if !defined (F_CPU)
#define F_CPU <?$cpu:speed?>
#endif

#define RAMSTART <?$cpu:ramstart?>
//#define RAMEND <?$cpu:ramend?>
#define RAMSIZE (RAMEND-RAMSTART)
#define ROMSTART <?$cpu:romstart?>
#define ROMEND <?$cpu:romend?>
#define ROMSIZE (ROMEND-ROMSTART)
#define EEPROMSTART <?$cpu:eepromstart?>
#define EEPROMEND <?$cpu:eepromend?>
#define EEPROMSIZE (EEPROMEND-EEPROMSTART)

#define sleep()<?if (I("cpu:sleep:index") > 0) P(" asm volatile (\"sleep\")");?>
<?if (B("main:interrupts")) show(); else hide();?>
// ------------------
// --- interrupts ---
// ------------------
<?XmlNodeList irqs = CPU.SelectNodes("irqs/irq");
foreach (XmlNode irq in irqs)
{
	bool ok = true;
	string name = irq.Attributes["name"].InnerText;
	if (B("main:enable usart") == true && B("usart:interrupts") == true)
	{
		if		(S("usart:usart0:irq_rx") == name) ok = false;
		else if (S("usart:usart0:irq_tx") == name) ok = false;
		else if (S("usart:usart0:irq_de") == name) ok = false;
	}
	if (B("main:enable timer") == true && B("timer:interrupts") == true)
	{
		if		(S("timer:timer0:irq_ovf") == name) ok = false;
		else if (S("timer:timer0:irq_capt") == name) ok = false;
		else if (S("timer:timer0:irq_compa") == name) ok = false;
		else if (S("timer:timer0:irq_compb") == name) ok = false;
		else if (S("timer:timer0:irq_compc") == name) ok = false;
	}
	if (ok == true)
	{
		P("\r\n// "+irq.Attributes["desc"].InnerText+"\r\n");
		P("ISR("+name+"_vect)\r\n");
		P("{\r\n");
		P("\t// <todo: insert your interrupt code here ...>\r\n");
		P("}\r\n");
	}
}
if (B("main:check reset type")) show(); else hide();?>
// ---------------------------
// --- check type of reset ---
// ---------------------------

void onWatchdogReset()
{
	// <todo: insert your watchdog-reset code here ...>
}

void onPowerOnReset()
{
	// <todo: insert your poweron-reset code here ...>
}

void onExternalReset()
{
	// <todo: insert your code external-reset code here ...>
}

void onBrownOutReset()
{
	// <todo: insert your brownout-reset code here ...>
}
<?if (B("main:check reset type") && B("cpu:jtag")) show(); else hide();?>
void onJTAGReset()
{
	// <todo: insert your jtag-reset code here ...>
}
<?if (I("cpu:watchdog:index") > 0) show(); else hide();?>
// ----------------
// --- watchdog ---
// ----------------

#define watchdogReset() asm volatile ("wdr")

void watchdogOff(void)
{
	watchdogReset();
	<?$cpu:watchdog:wdtcsr?> |= (1<<WDCE) | (1<<WDE);
	<?$cpu:watchdog:wdtcsr?> = 0x00;
}
<?if (B("main:enable usart")) include("usart\\usart.c");?>
<?if (B("main:enable timer")) include("timer\\timer.c");?>
<?if (B("main:enable delayloop")) include("delayloop.c");?>
<?if (B("main:enable eeprom")) include("eeprom\\eeprom.c");?>
<?if (B("main:enable spi")) include("spi.c");?>
<?if (B("main:enable twi")) include("twi.c");?>
<?if (B("main:enable 1wire")) include("1wire.c");?>
<?show();?>
// ------------
// --- main ---
// ------------

int main()
{
<?if (B("main:check reset type")) show(); else hide();?>	// check reset type
	if (<?$cpu:mcusr?> & (1<<WDRF)) onWatchdogReset(); // Watchdog Reset Flag
	if (<?$cpu:mcusr?> & (1<<PORF)) onPowerOnReset(); // Power-on Reset Flag
	if (<?$cpu:mcusr?> & (1<<EXTRF)) onExternalReset(); // External Reset Flag
	if (<?$cpu:mcusr?> & (1<<BORF)) onBrownOutReset(); // Brown-out Reset Flag
<?if (B("main:check reset type") && B("cpu:jtag")) show(); else hide();?>	if (<?$cpu:mcusr?> & (1<<JTRF)) onJTAGReset(); // JTAG Reset Flag
<?if (I("cpu:sleep:index") > 0) { show(); P("//todo: enable sleep..."); }?>
<?show();?>	// <todo: insert your main code here ...>
	return 0;
}
<?show();P("\r\n\r\n// generated by AvrWiz on "+System.DateTime.Now);?>