#include "multitasking.h"

void taskCreate(Task *t, TaskFunction f, TaskPrio prio)
{
	cli();
	unsigned char a;
	// get ptr to end of stack
	unsigned char *s = (unsigned char *)(t->stack + sizeof(t->stack) - 3);
	// and fill the stack with 0
	for (a=31; a!=255; a--) *s-- = 0;
	// clear all bits in sreg
	t->sreg = 0;
	// set the stack pointer to the end of the stack
	t->sp = (unsigned char *)(t->stack + sizeof(t->stack) - 3);
	// store the taks prio (the value for '<?$multitasking1:timer0:cpu_counter?>')
	t->prio = prio;
	// set the return address to the task-function
	t->stack[sizeof(t->stack)-2] = ((unsigned int)f)>>8;
	t->stack[sizeof(t->stack)-1] = ((unsigned int)f)&0xff;
	// and finally enqueue task into tasklist
	for (a=0; a<NUM_TASKS; a++)
	{
		if (!tasks[a])
		{
			tasks[a] = t;
			break;
		}
	}
	sei();
}

void taskSwitch()
{
	cli();
	// this 'schedules' a timer overflow in some cpu ticks...
	<?$multitasking1:timer0:cpu_counter?> = 240;
	<?$multitasking1:timer0:cpu_control?> = <?$multitasking1:timer:prescaler:value:1:bits?>; // prescaler=<?$multitasking1:timer0:prescaler?>
	<?$multitasking1:timer0:cpu_enable?> = (1<<TOIE<?$multitasking1:timer?>); // Timer/Counter<?$multitasking1:timer?> Overflow Interrupt Enable
	sei();
	sleep(); // wait for timer irq
}

// the timer overflow interrupt handler
// this is the context-switcher
#define PUSH(r) asm volatile("push r"#r);
#define POP(r) asm volatile("pop r"#r);
void <?$multitasking1:timer:ovfvect?>_vect() __attribute__ ( ( signal, naked ) );
ISR(<?$multitasking1:timer:ovfvect?>_vect)
{
	// save the context
	PUSH(31);PUSH(30);PUSH(29);PUSH(28);PUSH(27);PUSH(26);PUSH(25);PUSH(24);
	PUSH(23);PUSH(22);PUSH(21);PUSH(20);PUSH(19);PUSH(18);PUSH(17);PUSH(16);
	PUSH(15);PUSH(14);PUSH(13);PUSH(12);PUSH(11);PUSH(10);PUSH( 9);PUSH( 8);
	PUSH( 7);PUSH( 6);PUSH( 5);PUSH( 4);PUSH( 3);PUSH( 2);PUSH( 1);PUSH( 0);
	<?$multitasking1:timer0:cpu_control?> = <?$multitasking1:timer:prescaler:bits:<?$multitasking1:timer0:prescaler:value?>; // prescaler=<?$multitasking1:timer0:prescaler:value?>
	Task *current = 0;
	if (currentTask != 255)
	{
		// get the structure for currently running task
		current = tasks[currentTask];
		// and save the SREG ...
		current->sreg = SREG;
		// ... and save the SP (PC is on the stack too)
		current->sp = (unsigned char *)(SP + 32);
	}
	// find next task to schedule
	do
	{
		currentTask++;
		if (currentTask >= NUM_TASKS)
			currentTask = 0;
		current = tasks[currentTask];
	}
	while (!current);
	if (current)
	{
		// restore new SREG from the saved task structure
		SREG = current->sreg;
		// and restore the new stack
		SP = (unsigned int)(current->sp - 32);
		// and set the new 'prio' (the time the task gets to run)
		<?$multitasking1:timer0:cpu_counter?> = current->prio;
	}
	// restore the context
	POP( 0);POP( 1);POP( 2);POP( 3);POP( 4);POP( 5);POP( 6);POP( 7);
	POP( 8);POP( 9);POP(10);POP(11);POP(12);POP(13);POP(14);POP(15);
	POP(16);POP(17);POP(18);POP(19);POP(20);POP(21);POP(22);POP(23);
	POP(24);POP(25);POP(26);POP(27);POP(28);POP(29);POP(30);POP(31);
	// return (with the new return address on the new stack !) from irq
	asm volatile("reti");
}
#undef PUSH
#undef POP
<?show();P("\r\n\r\n// generated by AvrWiz on "+System.DateTime.Now);?>