<?
int usartNum     = I("usart:usart");
string usartName = "USART"+S("usart:usart");
int baud         = I("usart:usart0:baud");
int realbaud     = I("usart:usart0:realbaud");
string usartErr  = S("usart:usart0:err");
?>; -------------
; --- usart ---
; -------------

; the values are calculated with AvrWiz for <?$cpu:cpu?> @ <?$cpu:mhz?> mhz
; <?P(usartName);?> settings: <?P(baud);?> baud <?$usart:usart0:databits?>-<?$usart:usart0:parity?>-<?$usart:usart0:stopbits?>
<?if (baud != realbaud) P("; !!! warning !!! real baud = "+realbaud+", err = "+usartErr+"% !!!\r\n");
if (B("usart:interrupts")) show(); else hide();?>
; todo: generate asm interrupts
<?if (B("usart:usart0:rxbuffer")) show(); else hide();?>
; todo: generate asm interrupt rx-buffer code
<?if (B("usart:help")) show(); else hide();?>
; for help see 'usart_impl.c'
<?show();?>
<?P(usartName);?>_init:
	; Set baud rate
	ldi r17, <?$usart:usart0:v_ubrrh?>
	ldi r16, <?$usart:usart0:v_ubrrl?>
	out <?$usart:usart0:cpu_ubrrh?>, r17
	out <?$usart:usart0:cpu_ubrrl?>, r16
	ldi r16, <?$usart:usart0:v_ucsra?>
	out <?$usart:usart0:cpu_ucsra?>,r16
	; Enable receiver and transmitter
	ldi r16, <?$usart:usart0:v_ucsrb?>
	out <?$usart:usart0:cpu_ucsrb?>,r16
	; Set frame format
	ldi r16, <?$usart:usart0:v_ucsrc?>
	out <?$usart:usart0:cpu_ucsrc?>,r16
	ret
<?if (B("usart:usart0:tx") && I("usart:usart0:databits") < 9) show(); else hide();?>
<?P(usartName);?>_write:
	; Wait for empty transmit buffer
	sbis <?$usart:usart0:cpu_ucsra?>, <?$usart:usart0:cpu_udre?>
	rjmp <?P(usartName);?>_write
	; Put data (r16) into buffer, sends the data
	out <?$usart:usart0:cpu_udr?>, r16
	ret
<?if (B("usart:usart0:tx") && I("usart:usart0:databits") >= 9) show(); else hide();?>
<?P(usartName);?>_write:
	; Wait for empty transmit buffer
	sbis <?$usart:usart0:cpu_ucsra?>, <?$usart:usart0:cpu_udre?>
	rjmp <?P(usartName);?>_write
	; Copy ninth bit from r17 to <?$usart:usart0:cpu_txb8?>
	cbi <?$usart:usart0:cpu_ucsrb?>, <?$usart:usart0:cpu_txb8?>
	sbrc r17, 0
	sbi <?$usart:usart0:cpu_ucsrb?>, <?$usart:usart0:cpu_txb8?>
	; Put LSB data (r16) into buffer, sends the data
	out <?$usart:usart0:cpu_udr?>, r16
	ret
<?if (B("usart:usart0:rx") && I("usart:usart0:databits") < 9) show(); else hide();?>
<?P(usartName);?>_read:
	; Wait for data to be received
	sbis <?$usart:usart0:cpu_ucsra?>, <?$usart:usart0:cpu_rxc?>
	rjmp <?P(usartName);?>_read
	; Get and return received data from buffer
	in r16, <?$usart:usart0:cpu_udr?>
	ret
<?if (B("usart:usart0:rx") && I("usart:usart0:databits") >= 9) show(); else hide();?>
<?P(usartName);?>_read:
	; Wait for data to be received
	sbis <?$usart:usart0:cpu_ucsra?>, <?$usart:usart0:cpu_rxc?>
	rjmp <?P(usartName);?>_read
	; Get status and ninth bit, then data from buffer
	in r18, <?$usart:usart0:cpu_ucsra?>
	in r17, <?$usart:usart0:cpu_ucsrb?>
	in r16, <?$usart:usart0:cpu_udr?>
	; If error, return -1
	andi r18,(1<<<?$usart:usart0:cpu_fe?>)|(1<<<?$usart:usart0:cpu_dor?>)|(1<<<?$usart:usart0:cpu_pe?>)
	breq <?P(usartName);?>_readNoError
	ldi r17, HIGH(-1)
	ldi r16, LOW(-1)
<?P(usartName);?>_readNoError:
	; Filter the ninth bit, then return
	lsr r17
	andi r17, 0x01
	ret
<?show();P("\r\n\r\n; generated by AvrWiz on "+System.DateTime.Now);?>