#ifndef _TASKS_H_
#define _TASKS_H_

#include <avr/io.h>
#include <avr/interrupt.h>
#include "gos_def.h"

// undefine to save memory if signal & wait are not needed


// supported / tested devices


#if defined(__AVR_ATmega8__)		|| \
	defined(__AVR_ATmega16__)		|| \
	defined(__AVR_ATmega32__)		|| \
	defined(__AVR_ATmega8515__)		|| \
	defined(__AVR_ATmega8535__)		|| \
	defined(__AVR_ATmega323__) 
#endif


#if defined (__AVR_ATmega8__)
#	define RAMSTART 	0x60
#	define STACK_SIZE	64
#	define TIMER_REG	TCCR0
#	define TIMER_ENABLE	TIMSK
#	define TIMER_VECTOR	TIMER0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS00)
#elif defined (__AVR_ATmega16__)
#	define RAMSTART 	0x60
#	define STACK_SIZE	64
#	define TIMER_REG	TCCR0
#	define TIMER_ENABLE	TIMSK
#	define TIMER_VECTOR	TIMER0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS00)
#elif defined (__AVR_ATmega32__)
#	define RAMSTART 	0x60
#	define STACK_SIZE	96
#	define TIMER_REG	TCCR0
#	define TIMER_ENABLE	TIMSK
#	define TIMER_VECTOR	TIMER0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS00)
#elif defined (__AVR_ATmega128__)
#	define RAMSTART 	0x100
#	define STACK_SIZE	128
#	define TIMER_REG	TCCR0
#	define TIMER_ENABLE	TIMSK
#	define TIMER_VECTOR	TIMER0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS01)|_BV(CS00)
#elif defined (__AVR_ATmega2560__)
#	define RAMSTART 	0x200
#	define STACK_SIZE	128
#	define TIMER_REG	TCCR0B
#	define TIMER_ENABLE	TIMSK0
#	define TIMER_VECTOR	TIMER0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS00)
#elif defined (__AVR_ATtiny44__)
#	define RAMSTART 	0x60
#	define STACK_SIZE	50
#	define TIMER_REG	TCCR0B
#	define TIMER_ENABLE	TIMSK0
#	define TIMER_VECTOR	TIM0_OVF_vect
#	define CLK1			_BV(CS00)
#	define CLK1024		_BV(CS02)|_BV(CS00)
#else
#	error "unsupported device in tasks.h"
#endif

// max number of tasks (depending on ram size)
//#define MAX_TASKS ((RAMEND-RAMSTART-100)/(STACK_SIZE+2))


#define GOS_NULLTIME     0    /* attesa infinita                        */                               
#define GOS_NULLEVNT     0    /* evento nullo                           */



typedef void (*TaskFunction)(void);

// times & cycles at 16MHz and CLK/1024:


typedef volatile struct Task
{
	volatile BYTE sreg;
	volatile BYTE* sp;
	volatile BYTE event;
	volatile unsigned int timeOut;
	volatile BYTE state;
	GOS_MSG *pQueue;       /* primo nella coda dei messaggi             */
    GOS_MSG *pIn;          /* pos. inserimento prossimo messaggio       */   
    GOS_MSG *pOut;         /* prossimo messaggio da prelevare           */   
    BYTE   nMaxMsg;        /* numero max. messaggi nella coda           */
    BYTE   nCntMsg;        /* numero messaggi presenti nella coda       */
	
} Task;



typedef volatile struct TAG_EVNT
{
  volatile unsigned char evnt;
  volatile unsigned char bFree; 
}TAG_EVNT;

//#define GOS_EVNT  struct TAG_EVNT

void blocca(void);
void sblocca(unsigned char val);

/*--- functions ---*/
void taskInit(void);
HANDLE taskCreate(Task *t, PFUNC f, BYTE* stackArea, BYTE stackSize, BYTE nMsg);
HANDLE task_gethandle(void);
void task_delay(WORD ms); 
BYTE task_wait(BYTE evnt, WORD time_out);
void task_signal(BYTE evnt);
BYTE task_getevent(void);
void task_releaseevent(BYTE evnt);
void task_resetevent(BYTE evnt);
void task_poll(void);
BYTE task_post(HANDLE hTask, GOS_MSG* pMsg);
BYTE task_pick(GOS_MSG* pMsg);
void task_switch(void);


#endif /* _TASKS_H_ */
<?show();P("\r\n\r\n// generated by AvrWiz on "+System.DateTime.Now);?>