	list	b=4
;************************************************************************
;																   		*
;	Filename:		UART_sender.asm										   	*
;																	 	*
;************************************************************************
;																		*
;	Files required: none												*
;																	 	*
;************************************************************************
;																		*
;	Can be used on:														*
;					16F1826											 	*
;																		*
;************************************************************************
;																	 	*
;	Notes:															   	*
;		Pin assignment													*
;	  		Port A											 			*
;				0..3 = Data input 0..3						input		*
;				4..7 = Address input 0..3					input		*
;																	 	*
;	  		Port B 														*
;				0 = Send data 								input		*
;				1 = UART Rx									input		*
;				2 = UART Tx									input		*
;				3 = Not used								input		*
;				4..7 = Data input 4..7						input		*
;																	 	*
;************************************************************************

	errorlevel	-302

	list	p=16f1826		; 16F1826 can be used
	#include <p16f1826.inc>	; processor specific variable definitions


		__CONFIG _CONFIG1, _CP_OFF & _WDTE_OFF & _BOREN_ON & _PWRTE_ON & _FOSC_INTOSC & _MCLRE_OFF & _CLKOUTEN_OFF
		__CONFIG _CONFIG2, _WRT_OFF & _STVREN_OFF & _BORV_LO & _LVP_OFF

	__idlocs		0x0000


F_OSC		EQU	.16000000
OSC			EQU	F_OSC/4

BaudRate	EQU	.19800

	cblock	0x0020
		UartTxChar:	.32	; Uart Tx fifo
	endc

	cblock	0x0070
		Temp			; Scratch registers
		Temp2
		Temp3

		Rs232Temp		; Temporary save for WREG 
		UartTxChWp		; UART transmit buffer write pointer 
		UartTxChRp		; UART transmit buffer read  pointer 
		UartTxChNum		; Number os characters in buffer to send

		portb			; Just for testing, message sent at falling edge of bit 0
	endc


	org		0x0000
		goto	Init


	org		0x0004
Int
;		No register save			; WREG, STATUS, BSR saved by the hardware
									; FSR1 used only by the ISR

		banksel	PIE1
		btfss	PIR1,TXIE			; Transmit interrupt enabled
		goto	TxIntEnd			; No, leave transmit ISR routine
		banksel	PIR1
		btfss	PIR1,TXIF			; Transmit interrupt requested
		goto	TxIntEnd			; No, leave transmit ISR routine


		banksel	UartTxChNum
		movf	UartTxChNum,f		; Get next char from buffer if there is one
		btfsc	STATUS,Z
		goto	INT_TX_NOCHAR		; No more chars in buffer

		movf	UartTxChRp,w		; Get read pointer to buffer
		movwf	FSR1L
		movlw	high(UartTxChar)	; Init FSR1 to buffer
		movf	INDF1,w				; Get character from buffer
		banksel	TXREG
		movwf	TXREG				; Send it
		incf	FSR1,w				; Move pointer
		andlw	0x1F				; in circular way
		banksel	UartTxChRp
		iorlw	low(UartTxChar)
		movwf	UartTxChRp			; Store new read pointer
		decfsz	UartTxChNum,f		; Sign one char read from buffer
		goto	TxIntEnd			; Skip disabling transmit interrupt if more chars in buffer

INT_TX_NOCHAR						; No more chars to transmit
		banksel	PIE1
		bcf		PIE1,TXIE			; Disable transmit int

TxIntEnd
;		No register restore			; WREG, STATUS, BSR restored by the hardware
		retfie						; Exit from ISR

Init
		banksel	OSCCON				; Set frequencz of internal oscillator
		movlw	(1<<IRCF3)|(1<<IRCF2)|(1<<IRCF1)|(1<<IRCF0)		; 16MHz
		movwf	OSCCON

		banksel	ANSELA
		clrf	ANSELA				; Switch ports to digital mode
		clrf	ANSELB

		banksel	WPUA				; Enable pull-ups
		movlw	0xFF
		movwf	WPUA
		movwf	WPUB

		banksel	TRISA				; Set port directions
		movlw	0xFF
		movwf	TRISA
		movwf	TRISB

;		bcf		TRISB,2

		banksel	RCSTA				; Set up UART
	if	BaudRate<.9600				; Set up Baud rate
		bcf		TXSTA,BRGH
		movlw	(F_OSC/.64/BaudRate)-1
	else
		bsf		TXSTA,BRGH
		movlw	(F_OSC/.16/BaudRate)-1
	endif

		movwf	SPBRG				; Store Baud divide ratio
		bsf		TXSTA,TXEN			; Enable transmission
		bsf		RCSTA,SPEN			; Enable UART

		banksel	UartTxChWp			; Init buffer pointers
		movlw	UartTxChar			; Get address of buffer
		movwf	UartTxChWp			; Store it in write pointer
		movwf	UartTxChRp			; Store it in read  pointer
		clrf	UartTxChNum			; No character in buffer

		movlw	0xFF
		movwf	portb				; Just for testing 

		banksel	INTCON
		bsf		INTCON,PEIE			; Enable peripheral interrupts
		bsf		INTCON,GIE			; Enable global interrupts

MainLoop:
		banksel	PORTB				; Check for data validation
		btfsc	PORTB,0
;		btfsc	portb,0				; Just for debugging
		goto	MainLoop

;		bsf		portb,0				; Just for debugging
									; Data valid, send it

		movf	PORTA,w				; Read data and address form ports
		movwf	Temp2				; and store in temporary variables
		movf	PORTB,w
		movwf	Temp3

		movlw	'a'					; Send telegram start character
		call	Send
		swapf	Temp2,w				; Send address
		call	SendNibble
		movlw	'c'					; Send separator
		call	Send
		swapf	Temp3,w
		call	SendNibble			; Send high nibble of data
		movf	Temp2,w
		call	SendNibble			; Send low  nibble of data
		goto	MainLoop

SendNibble
		andlw	0x0F				; Use lower 4 bits only
		movwf	Temp
		sublw	0x09				; Check for values .10 .. .15
		clrw
		btfss	STATUS,C			; If nibble > 9 add 7, and use lower case character
		movlw	0x27				; Convert to letters
		addwf	Temp,w
		addlw	0x30				; Convert to ACSII

Send								; Sends char in w
		banksel	Rs232Temp
		btfsc	UartTxChNum,5		; Test number of chars in buff
		goto	Send				; Wait for a place in buffer if needed

		movwf	Rs232Temp			; Store data to send

		banksel	PIE1
		bcf		PIE1,TXIE			; Disable TX interrupt

		banksel	UartTxChWp
		movf	UartTxChWp,w		; Get write pointer
		movwf	FSR0L
		movlw	high(UartTxChar)
		movwf	FSR0H				; Set up FSR0 to point to buffer

		movf	Rs232Temp,w			; Get char to send
		movwf	INDF0				; Store it in buffer
		incf	FSR0L,w				; Move the pointer
		andlw	0x1F				; in circular way
		iorlw	low(UartTxChar)
		movwf	UartTxChWp			; Store modified write pointer
		incf	UartTxChNum,f		; Increment number of available characters

		banksel	PIE1	
		bsf		PIE1,TXIE			; Enable TX interrupt

		banksel	Rs232Temp
		movf	Rs232Temp,w			; Get char just sent
		return

	END
