	list	b=4
;************************************************************************
;																   		*
;	Filename:		UART_receiver.asm										   	*
;																	 	*
;************************************************************************
;																		*
;	Files required: none												*
;																	 	*
;************************************************************************
;																		*
;	Can be used on:														*
;					16F1826											 	*
;																		*
;************************************************************************
;																	 	*
;	Notes:															   	*
;		Pin assignment													*
;	  		Port A											 			*
;				0..3 = Data output 0..3						output		*
;				4..7 = Address input 0..3					input		*
;																	 	*
;	  		Port B 														*
;				0 = Data received 							output		*
;				1 = UART Rx									input		*
;				2 = UART Tx									input		*
;				3 = Not used								input		*
;				4..7 = Data output 4..7						output		*
;																	 	*
;************************************************************************

	errorlevel	-302

	list	p=16f1826		; 16F1826 can be used
	#include <p16f1826.inc>	; processor specific variable definitions


		__CONFIG _CONFIG1, _CP_OFF & _WDTE_OFF & _BOREN_ON & _PWRTE_ON & _FOSC_INTOSC & _MCLRE_OFF & _CLKOUTEN_OFF
		__CONFIG _CONFIG2, _WRT_OFF & _STVREN_OFF & _BORV_LO & _LVP_OFF

	__idlocs		0x0000


F_OSC		EQU	.16000000
OSC			EQU	F_OSC/4

BaudRate	EQU	.19800

	cblock	0x0020
		UartRxChar:	.32	; Uart Rc fifo
	endc

	cblock	0x0070
		Temp			; Scratch registers

		Rs232Flags
		Rs232Temp		; Temporary save for WREG 
		Rs232Status

		UartRxChWp		; UART receive buffer write pointer 
		UartRxChRp		; UART receive buffer read  pointer 
		UartRxChNum		; Number os characters in buffer to send
		MyAddress
		Address
		Command
	endc

;PORTB
bDataReady			EQU	0

;Rs232Flags
bWaitAddressPrefix	EQU	7
bWaitCommandPrefix	EQU	6
bWaitAddress		EQU	5
bWaitCommand		EQU	4
;					EQU	3
;					EQU	2
bNibbleCount1		EQU	1
bNibbleCount0		EQU	0


	org		0x0000
		goto	Init


	org		0x0004
Int
;		No register save			; WREG, STATUS, BSR saved by the hardware
									; FSR1 used only by the ISR

		banksel	PIE1
		btfss	PIR1,RCIE			; Transmit interrupt enabled
		goto	RcIntEnd			; No, leave transmit ISR routine
		banksel	PIR1
		btfss	PIR1,RCIF			; Transmit interrupt requested
		goto	RcIntEnd			; No, leave transmit ISR routine

		banksel	UartRxChWp
		movf	UartRxChWp,w		; Put receive char to buffer if no error
		movwf	FSR1L
		movlw	high(UartRxChar)
		movwf	FSR1H
		banksel	RCSTA
		movf	RCSTA,w				; Check for error
		andlw	(1 << FERR) | (1 << OERR)
		btfss	STATUS,Z
		goto	UART_ERR			; If error not to read char
		movf	RCREG,w				; Read character
		movwf	INDF1				; Write it to buffer
		incf	FSR1L,w				; Move pointer in circular way
		andlw	0x0F
		iorlw	low(UartRxChar)
		banksel	UartRxChWp
		movwf	UartRxChWp
		incf	UartRxChNum,f		; Sign one more char in buffer
		goto	RcIntEnd

UART_ERR							; Receive error, reenable receive
		bcf		RCSTA,CREN			; Turn off receiver
		movf	RCREG,w				; Clear receive interrupt flag, drop character
		bsf		RCSTA,CREN			; Turn on  receiver

RcIntEnd
;		No register restore			; WREG, STATUS, BSR restored by the hardware
		retfie						; Exit from ISR

Init
		banksel	OSCCON				; Set frequencz of internal oscillator
		movlw	(1<<IRCF3)|(1<<IRCF2)|(1<<IRCF1)|(1<<IRCF0)		; 16MHz
		movwf	OSCCON

		banksel	ANSELA
		clrf	ANSELA				; Switch ports to digital mode
		clrf	ANSELB

		banksel	TRISA				; Set port directions
		movlw	0xF0
		movwf	TRISA
		movlw	0x0F
		movwf	TRISB

		banksel	LATB				; Clear data ready signal
		clrf	LATB

		banksel	RCSTA				; Set up UART
	if	BaudRate<.9600				; Set up Baud rate
		bcf		TXSTA,BRGH
		movlw	(F_OSC/.64/BaudRate)-1
	else
		bsf		TXSTA,BRGH
		movlw	(F_OSC/.16/BaudRate)-1
	endif

		movwf	SPBRG				; Store Baud divide ratio
		bcf		TXSTA,TXEN			; Disable transmitter
		bsf		RCSTA,CREN			; Enable receiver
		bsf		RCSTA,SPEN			; Enable UART

		banksel	UartRxChWp			; Init buffer pointers
		movlw	UartRxChar			; Get address of buffer
		movwf	UartRxChWp			; Store it in write pointer
		movwf	UartRxChRp			; Store it in read  pointer
		clrf	UartRxChNum			; No character in buffer

		clrf	Rs232Flags			; Initialize receive state machine
		bsf		Rs232Flags,bWaitAddressPrefix

		swapf	PORTA,w				; Get address of unit
		andlw	0x0F
		movwf	MyAddress			; Store unit address

		banksel	PIE1
		bsf		PIE1,RCIE			; Enable receiver interrupt

		banksel	INTCON
		bsf		INTCON,PEIE			; Enable peripheral interrupts
		bsf		INTCON,GIE			; Enable global interrupts

MainLoop:
		call	UART_Receive		; Look for character received
		btfsc	STATUS,C
		goto	MainLoop			; No character

		xorlw	'a'					; Check for address prefix
		btfsc	STATUS,Z
		goto	AddressPrefix		; Process address prefix
		xorlw	'c' ^ 'a'			; Check for command prefix
		btfsc	STATUS,Z
		goto	CommandPrefix		; Process command prefix

		call	ConvToNibble		; Convert to hex nibble
		btfsc	STATUS,C
		goto	WaitForStart		; Wait for a new telegram if no hex digit character found 

		btfsc	Rs232Flags,bWaitAddress; If address to receive
		goto	SetAddress			; Process nibble as address

SetCommand							; Process nibble as command
		btfss	Rs232Flags,bWaitCommand
		goto	WaitForStart
		swapf	Command,f			; Swap last received data to most significand nibble
		iorwf	Command,f			; Combine with new nibble
		decf	Rs232Flags,w		; Decrease count of nibbles to received
		xorwf	Rs232Flags,w		; Modify only the bit 1..0
		andlw	(1 << bNibbleCount1)|(1 << bNibbleCount0)
		xorwf	Rs232Flags,f

		movf	Rs232Flags,w		; Get count of niobbles to receive
		andlw	(1 << bNibbleCount1)|(1 << bNibbleCount0)
		btfss	STATUS,Z			; Process telegram if no more nibbles to receive
		goto	MainLoop

		movf	Address,w			; Check address 
		xorwf	MyAddress,w
		btfss	STATUS,Z
		goto	MainLoop			; Process data only if address match

		banksel	Command				; Dispatch data to ports
		movf	Command,w
		banksel	LATA				; Low nibble to PORTA
		xorwf	LATA,w
		andlw	0x0F
		xorwf	LATA,f
		banksel	Command
		movf	Command,w
		banksel	LATB				; High nibble to PORTB
		xorwf	LATB,w
		andlw	0xF0
		xorwf	LATB,f				; Sign data ready
		bsf		LATB,bDataReady
		banksel	Command
		goto	WaitForStart		; Wait for next telegram

		
SetAddress							; Process address
		banksel	Rs232Flags
		btfss	Rs232Flags,bWaitAddress; If address to receive
		goto	WaitForStart		; No, wait for a new telegram
		clrf	Rs232Flags
		movwf	Address				; Store address
		bsf		Rs232Flags,bWaitCommandPrefix; Command prefix to receive
		goto	MainLoop

CommandPrefix
		btfss	Rs232Flags,bWaitCommandPrefix; If command prefix to receive
		goto	WaitForStart
		clrf	Rs232Flags			; No, wait for a new telegram
		bsf		Rs232Flags,bWaitCommand
		clrf	Command				; Initialize command value
		bsf		Rs232Flags,bNibbleCount1; A comamnd needs 2 nibbles to receive
		goto	MainLoop
		

AddressPrefix						; Process address prefix
		btfss	Rs232Flags,bWaitAddressPrefix
		goto	WaitForStart		; No, wait for a new telegram
		clrf	Rs232Flags
		bsf		Rs232Flags,bWaitAddress; Address to receive
		goto	MainLoop

WaitForStart						; Wait for a new telegram
		clrf	Rs232Flags
		bsf		Rs232Flags,bWaitAddressPrefix; Address prefix to receive
		goto	MainLoop

;*************************************************************
; Convert too nibble
; Input:	value in Rs232Temp
; output:	nibble in W
;			C = 1 if no hexadecimal digit character processed

ConvToNibble						; Convert to nibble
		movf	Rs232Temp,w
		addlw	-'0'
		movwf	Temp
		btfsc	Temp,7
		goto	NoHexDigit
		sublw	.9
		btfsc	STATUS,C
		goto	Number
		movf	Rs232Temp,w
		addlw	-'A'
		movwf	Temp
		btfsc	Temp,7
		goto	NoHexDigit
		sublw	.5
		btfss	STATUS,C
		goto	NoHexDigit
Number
		movf	Rs232Temp,w
		btfsc	Rs232Temp,6
		addlw	-.7		
		addlw	-'0'
		andlw	0x0F
		bcf		STATUS,C
		return

NoHexDigit
		bsf		STATUS,C
		retlw	0

;**********************************************************************
; Get a character from receive buffer

UART_Receive						; Gets char into w, C == 1 if no char was in fifo
		banksel	Rs232Status
		bsf		STATUS,C			; Set no character received
		swapf	STATUS,w			; Save STATUS
		movwf	Rs232Status

		banksel	PIE1
		bcf		PIE1,RCIE			; Disable RC interrupt

		banksel	Rs232Temp
		clrf	Rs232Temp
		banksel	UartRxChNum
		movf	UartRxChNum,w		; Check number of available chars
		btfsc	STATUS,Z
		goto	NO_REC_CHAR			; Jump if no character available

		movf	UartRxChRp,w		; Get read pointer
		movwf	FSR0
		movlw	high(UartRxChar)
		movwf	FSR0H
		movf	INDF0,w				; Read it from buffer
		movwf	Rs232Temp
		incf	FSR0,w				; Move the pointer
		andlw	0x0F				; in circular way
		iorlw	low(UartRxChar)
		movwf	UartRxChRp
		decf	UartRxChNum,f		; Decrement number of available characters
		bcf		Rs232Status,C+4		; Valid character received - !Status was swapped!

NO_REC_CHAR
		banksel	PIE1
		bsf		PIE1,RCIE			; Enable RC interrupt

		banksel	Rs232Status
		swapf	Rs232Status,w		; Restore STATUS
		movwf	STATUS
		movf	Rs232Temp,w			; Get char sent / just received
		return

	END
