	list	b=4
;                                                                 		*
;************************************************************************
;                                                               		*
;    Filename:	    Szoveg.asm                                        	*
#define	VersionMajor	0x02	;										*
#define	VersionMinor	0x33	;										*
;                                                                     	*
;************************************************************************
;                                                                    	*
;	Can be used on:                                                    	*
;					16F628, 16F628A, 16F648A, 16F819, 16F87, 16F88     	*
;                                                                    	*
;************************************************************************

#include CharGen628.asm

; Special characters
; euro - 0x80
; heart 	0x81,0x82
; smilly	0x83,0x84
; Copyright 0x8B 
;  - 0x8C,  - 0x8D,  - 0x8E,  - 0x8F,  - 0x90,  - 0x91  - 0x92,  - 0x93,  - 0x94,
; celsius fok - 0x95
; A - 0x96,  - 0x97,  - 0x98,  - 0x99,  - 0x9A,  - 0x9B  - 0x9C,  - 0x9D,  - 0x9E,
; fok  - 0x9F
;************************************************************************

	ifdef	__16F628
		list	p=16f628              ; 16F628 can be used
		#include <p16f628.inc>        ; processor specific variable definitions
EEPROM_SIZE	EQU	128
    endif
	ifdef	__16F628A
		list	p=16f628A             ; 16F628A can be used
		#include <p16f628A.inc>       ; processor specific variable definitions
EEPROM_SIZE	EQU	128
	endif
	ifdef	__16F648A
		list	p=16f648A             ; 16F648A can be used
		#include <p16f648A.inc>       ; processor specific variable definitions
EEPROM_SIZE	EQU	256
	endif
	ifdef	__16F819
		list	p=16f819			  ; 16F819 can be used
		#include <p16f819.inc>		  ; processor specific variable definitions
		#define	T0IE	TMR0IE
		#define	T0IF	TMR0IF
		#define	_MCLRE_OFF	_MCLR_OFF
EEPROM_SIZE	EQU	128
	endif
	ifdef	__16F87
		list	p=16f87				  ; 16F87 can be used
		#include <p16f87.inc>		  ; processor specific variable definitions
		#define	T0IE	TMR0IE
		#define	T0IF	TMR0IF
		#define	_MCLRE_OFF	_MCLR_OFF
EEPROM_SIZE	EQU	256
	endif
	ifdef	__16F88
		list	p=16f88				  ; 16F88 can be used
		#include <p16f88.inc>		  ; processor specific variable definitions
		#define	T0IE	TMR0IE
		#define	T0IF	TMR0IF
		#define	_MCLRE_OFF	_MCLR_OFF
EEPROM_SIZE	EQU	256
	endif

	ifndef	EEPROM_SIZE
		error	"Invalid processor type selected"
	endif

;******************************************************************************
;	Define EEPROM content for messages - Strings have to be 0x00 terminated
;******************************************************************************

	if	EEPROM_SIZE==256
		ORG		0x2180			; Start off message 2 in EEPROM
		de	"===> Displays day of week, rotation speed and store times in PCF8583 RTC ",0x83,0x84," <==="
		de	0x00
	endif

		ORG		0x2170			; Static text
		de	"Propeller clock", 0x00

		ORG     0x2100			; Start off message 1 in EEPROM
		de	"===> This version of Bob Blick's Propeller Clock was build and programmed by Henk Soubry ",0x83,0x84
    ifdef	__16F628
		de	" 16F628"
	endif
    ifdef	__16F628A
		de	" 16F628A"
	endif
	ifdef	__16F648A
		de	" 16F648A"
	endif
	ifdef	__16F819
		de	" 16F819"
	endif
	ifdef	__16F88
		de	" 16F88"
	endif
	ifdef	__16F87
		de	" 16F87"
	endif
		de	" V",VersionMajor+.48,".",((VersionMinor/.16)+.48),((VersionMinor%.16)+.48)," <==="
		de	0x00

	END
