#include "p18F6722.h"
#include "adc.h"
#include "delays.h"

#pragma config WDT=OFF, OSC=HS, DEBUG=OFF


void SetLed( int idx )
{
   PORTBbits.RB0 = 0;   
   PORTBbits.RB1 = 0;   
   PORTBbits.RB2 = 0;   
   switch ( idx ) {
   case 1: PORTBbits.RB0 = 1; break;
   case 2: PORTBbits.RB1 = 1; break;
   case 3: PORTBbits.RB2 = 1; break;
   }   
}


void main(void) {
   unsigned int ADCRes;
   float Vout = 0;
   // A0..A3 input
   TRISAbits.TRISA0 = 1;
   TRISAbits.TRISA1 = 1;
   TRISAbits.TRISA2 = 1;
   TRISAbits.TRISA3 = 1;
   // B0..B2 output
   TRISBbits.TRISB0 = 0;
   TRISBbits.TRISB1 = 0;
   TRISBbits.TRISB2 = 0;


   // csak hogy lssam...
   ADRESH = 0;
   ADRESL = 0;
   // ahogy az az adatlapon le vagyon rva...
   ADCON1bits.VCFG = 0;        // Vss - Vdd
   ADCON1bits.PCFG = 11;       // AN0..AN3 analog input
   // Select A/D input channel (ADCON0)
   ADCON0bits.CHS = 0;          // channel 0
   // Select A/D acquisition time (ADCON2)
   // min. 2.45us 
   // 1.6 * 2 = 3.2us 
   ADCON2bits.ACQT = 2;        // 2 TAD
   // Select A/D conversion clock (ADCON2)
   // 20 MHz clock / 32 ==> 1.6us
   // ADCON2bits.ADCS = 2;        // FOSC/32
   ADCON2bits.ADCS = 6;        // FOSC/64
   ADCON2bits.ADFM = 1;        // Right justified   
   // Turn on A/D module (ADCON0)
   ADCON0bits.ADON = 1;        // Enable ADC module  
   // Wait the required acquisition time (12TCY)
   Delay10TCY();
   Delay10TCY();
   ADCON0bits.GO = 1;
   while ( ADCON0bits.GO );
   // itt lehet megnzni mit csinlt.... 
   // ... semmit... 0x00000000
   while (1) {
   	ADCON0bits.CHS = 0;
      Delay10TCY();
      Delay10TCY();
      ADCON0bits.GO = 1;
      while ( ADCON0bits.GO );
   	ADCRes = (((unsigned int)ADRESH)<<8)|(ADRESL) & 0x03FF;
   	
   	Vout = ((float)5/1023) * ADCRes;
   	if ( Vout < 1.7 ) SetLed(1);
      else {
         if ( Vout < 3.3 ) SetLed(2); 
         else SetLed(3);
      }   
		Delay10KTCYx(200);
	}	
}
