/*Hi-Tech C  */
	#include "htc.h"

//SK include
	#include "constans.h"
	#include "SK_Type.h"

//I/O Config	
	#include "io_config.h"

//RS232 LCD Parancsok
	#include "parancsok.h"

	__CONFIG(LVPDIS & WDTDIS & INTIO & UNPROTECT & PWRTEN & BORDIS);

//EEPROM
__EEPROM_DATA(20, 90, 3, 4, 5, 6, 7, 8);

	#define _XTAL_FREQ 4000000


//Brmely vltoz bitelrse
//bitset(valtozo,1);
	#define bitset(var, bitno)    ((var) |= 1UL << (bitno))
	#define bitclr(var, bitno)    ((var) &= ~(1UL << (bitno)))


//LCD prototpusok
	void Adat_Ki_LCD(unsigned char Adat_8bit);
	void LCD_2x4bit_Parancs(unsigned char Adat_2x4bit);
	void LCD_2x4bit_Karakter(unsigned char Adat_2x4bit);
	void Szoveg_LCD(unsigned char LCD_Cim, const unsigned char * Szoveg_Cim);
	void Contrast_Hatter_ini(void);
	void LCD_Init(void);
	void Karakter_to_LCD(void);
	void Uj_Karakter_Generalas(void);


//zenetek. program terlet
	const unsigned char Verzio[]="Kazan Vezerlo 1.0";
	//LCD tesztek
	const unsigned char ele[]="ele irja";
	const unsigned char moge[]="moge irja";
	const unsigned char bele[]="bele";


//Globlis Vltozk
	//Timer0 LED
	unsigned int T0_LEDcount;

	//Szoftveres PWM
	unsigned char	S_PWM_Period, S_PWM_Dutty, Contr_PWM_Dutty;
	
	//LCD
	unsigned char	LCD_Cim;  
	
	//USART REC
	unsigned char REC_Counter;
	unsigned char LCD_Buffer[30];
	unsigned int REC_Err_Count;

	//Flags
	 TFLAGbits_1 Flag_1;




//main **********************************************************************************************
void main (void )
{
	unsigned char REC_temp;

// I/O irnyok
	TRISA=0b00010000;
	TRISB=0b11000010;
	
// Compartor off
	CMCON = 7;

//Timer0 belltsa
	PSA=1; //eloszt nem a Timer0-hoz van rendelve
/*	PS0=1;
	PS1=1;
	PS2=1;	//Eloszts 256
*/
	T0CS=0; // bels rajel forrs

//Vltozk alapbelltsa
	//Timer0 LED szmll
	T0_LEDcount = 0;	//Timer0 megszakts szmll

//EEPROM
	//eeprom_write(0, 20);	
	//eeprom_write(1, 95);

// LCD inicializlsa
	LCD_Init();

//USART REC init
	RX9=0; 		//8bit md
	CREN=1; 	//folyamatos vtel engedlyezve
	BRGH=1;		//Baud magas tartomny
	SPBRG=6;	//25->9600, 12->19200 bit/sec, 6-> 38400 4MHz esetn
	SPEN=Be;	//Soros port bekapcsolva
	RCIE=Be;	//Megszakts engedlyezve
	REC_Counter=0;
	Flag_1.REC_Kesz=False;
	Flag_1.REC_1Byte=Ki;

	//dvzl szveg
	Szoveg_LCD(193, Verzio);
	//Szoveg_LCD(128, ele);
	//Szoveg_LCD(148, moge);
	//Szoveg_LCD(195, bele);

	REC_temp=RCREG;

// Megszaktsok belltsa
	PEIE=Be;	//Perifria megszakts engedlyezve
	GIE=Be;		// Globlis megszakts engedlyezve
	T0IE=Be;	//Timer0 megszakts engedlyezve

	while(True)
	{
		//Vett adatok(RS232) lekezelse
		if(Flag_1.REC_Kesz)
		{
			switch	(LCD_Buffer[0])		//Parancs bjt kirtkelse	
			{			
				case	Karakter_LCDre:	//LCD_Adat		
					Karakter_to_LCD();	
					LED=Ki;				
					break;
				case	LCD_Beallitas:
					LED=Ki;		
					break;
				case	Karakter_Gen:	//Csomag felpts: 0: parancs, 1: CG RAM cm, 2..9: pixel bjtok
					Uj_Karakter_Generalas();
					LED=Ki;
					break;
				case	LCD_Torles:
					LCD_2x4bit_Parancs(0b00000001);	// DISPLAY TRLS
					LED=Ki;
					break;
				case	Kontraszt:
					if(LCD_Buffer[1]<101)
					{
						eeprom_write(0, LCD_Buffer[1]);
						Contr_PWM_Dutty=LCD_Buffer[1];
					}
					LED=Ki;
					break;
				case	Hatter_LED:
					if(LCD_Buffer[1]<101)
					{
						eeprom_write(1, LCD_Buffer[1]);
						S_PWM_Dutty=LCD_Buffer[1];
					}
					LED=Ki;
					break;
				case	LED_Be:
					LED=Be;
					break;
				case	LED_Ki:	
					LED=Ki;
					break;
				default:
					break;	
			}
			Flag_1.REC_Kesz=Clear;
			LCD_Buffer[0]=0;
		}
	}
}

//*********************************************************************************************************
//****************************           LCD rutinok                                  *********************
//*********************************************************************************************************
//________________________________________________________
//  	 Kontraszt s httrvilgts belltsa  		  |
/*
	A kontraszt s a httrvilgts szoftveres
	PWM-el Timer0 megszakts temvel van belltva	
*/
//________________________________________________________|
void Contrast_Hatter_ini(void)
{
	S_PWM_Dutty = eeprom_read(1); 		//Httr LED-eket majdnem teljesen bekapcsoljuk
	Contr_PWM_Dutty = eeprom_read(0); 	//kontraszt belltsa
}

void LCD_Init(void)
{
	unsigned char	a;

	//Szoftveres PWM belltsa
	S_PWM_Period = 0;	//50 rszre lesz osztva
	Contrast_Hatter_ini();

	LCD_Tiltva();
	LCD_Write();
	LCD_Parancs();
	__delay_ms(1000);			// 1s vrakozs az LCD felledsre	
	Adat_Ki_LCD(0b00000011);
	__delay_ms(42);			// 41,6ms vrakozs 
	Adat_Ki_LCD(0b00000011);	
	__delay_ms(42);			// 41,6ms vrakozs 
	Adat_Ki_LCD(0b00000011);
	__delay_ms(42);			// 41,6ms vrakozs 
	Adat_Ki_LCD(0b00000010);	// PARANCS: 4BITES, 1 SOROS
	__delay_ms(17);			// 16,6ms vrakozs 
	// Innen 4 bites mkds
	LCD_2x4bit_Parancs(0b00101000);	// FUNC_SET  4 BITES MD, 2 SOROS KIJELZS, 5x8 PONT
	LCD_2x4bit_Parancs(0b00001011);	// DISPL OFF, CURSOR ON, VILLOG		
	LCD_2x4bit_Parancs(0b00000001);	// DISPLAY TRLS
	LCD_2x4bit_Parancs(0b00000110);	// KURZOR JOBBRA LP, SHIFT OFF
	LCD_2x4bit_Parancs(0b00001100);	// DISPLAY ON, CURSOR OFF
}


//________________________________________________________
//  	     Adatok kivitele az LCD portra.   			  |
//________________________________________________________|
void Adat_Ki_LCD(unsigned char Adat_8bit)
{
	unsigned char temp;
	temp = PORTA & 0b11110000;
	Adat_8bit = Adat_8bit & 0b00001111;
	PORTA = temp + Adat_8bit;
	LCD_Engedely();
	__delay_us(Delay_LCD);			//  vrakozs 
	LCD_Tiltva();
	__delay_us(Delay_LCD);			//  vrakozs		
}//End void Adat_Ki_LCD(unsigned char Adat_8bit)

//________________________________________________________
//  	     Parancsok kivitele 2x4 bitben LCD-re 			  |
//________________________________________________________|
/*		; TADOTT ADAT(Adat_2x4bit)  (DDDDdddd)	
		; KIVITEL AZ LCD_PORT-ra     (xxxxDDDD) D=HIGH ADATBITEK 
		; KIVITEL A LCD_PORT-ra      (xxxxdddd) d=LOW  ADATBITEK
		; AZ LCD 			 	  	 (DDDDnnnn) LBAIRA MEGY AZ ADAT
		; A LCD_PORT xxxx BITJEI NEM VLTOZNAK. nnnn AZ LCD-n TESTRE KTVE */
void LCD_2x4bit_Parancs(unsigned char Adat_2x4bit)
{		
	unsigned char temp;
	temp = PORTA & 0b11110000;
	PORTA = temp + (Adat_2x4bit >> 4);
	
	LCD_Write();	
	LCD_Parancs();	
	LCD_Engedely();
	__delay_us(Delay_LCD);			//  vrakozs 
	LCD_Tiltva();
	__delay_us(Delay_LCD);			//  vrakozs
	
	temp = PORTA & 0b11110000;
	Adat_2x4bit = Adat_2x4bit & 0b00001111;
	PORTA = temp + Adat_2x4bit;

	LCD_Engedely();
	__delay_us(Delay_LCD);			//  vrakozs 
	LCD_Tiltva();
	__delay_us(Delay_LCD);			//  vrakozs
}

//________________________________________________________
//  	     Karakterek kivitele 2x4 bitben LCD-re 			  |
//________________________________________________________|
/*		; TADOTT ADAT(Adat_2x4bit)  (DDDDdddd)	
		; KIVITEL AZ LCD_PORT-ra     (xxxxDDDD) D=HIGH ADATBITEK 
		; KIVITEL A LCD_PORT-ra      (xxxxdddd) d=LOW  ADATBITEK
		; AZ LCD 			 	  	 (DDDDnnnn) LBAIRA MEGY AZ ADAT
		; A LCD_PORT xxxx BITJEI NEM VLTOZNAK. nnnn AZ LCD-n TESTRE KTVE */
void LCD_2x4bit_Karakter(unsigned char Adat_2x4bit)
{		
	unsigned char temp;
	temp = PORTA & 0b11110000;
	PORTA = temp + (Adat_2x4bit >> 4);
	
	LCD_Write();	
	LCD_Karakter();	
	LCD_Engedely();
	__delay_us(Delay_LCD);			//  vrakozs 
	LCD_Tiltva();
	__delay_us(Delay_LCD);			//  vrakozs
	
	temp = PORTA & 0b11110000;
	PORTA = temp + (Adat_2x4bit & 0b00001111);

	LCD_Engedely();
	__delay_us(Delay_LCD);			//  vrakozs 
	LCD_Tiltva();
	__delay_us(Delay_LCD);			// vrakozs
}

//________________________________________________________
//	Szvegek kivitele az LCD-re rom ban trolt helyrl	  |
//________________________________________________________|
void Szoveg_LCD(unsigned char LCD_Cim, const unsigned char * Szoveg_Cim)
{
/*	;LCD SORCMEK:
		; 1. 128-147
		; 2. 192-211	
		; 3. 148-167	
		; 4. 212-231
*/
	unsigned char Char_rom, cikl;
	LCD_2x4bit_Parancs(LCD_Cim);	// Els karakter kezd pozcijnak cme
	cikl=0;
	do
	{
		Char_rom = Szoveg_Cim[cikl];
		cikl++;
		if (Char_rom!=0) LCD_2x4bit_Karakter(Char_rom);	// Soron kvetkez karakter kivitele az LCD-re
	}while(Char_rom!=0);
}

//________________________________________________________
//	Soros porton rkezett szvegek kivitele az LCD-re	  |
//________________________________________________________|
void Karakter_to_LCD(void)
{
	unsigned char counter, Char_temp;

	counter=1;
	Char_temp=LCD_Buffer[counter];
	LCD_2x4bit_Parancs(Char_temp);	// Els karakter kezd pozcijnak cme
	do
	{
		counter++;
		Char_temp=LCD_Buffer[counter];
		if(Char_temp!=ENTER) LCD_2x4bit_Karakter(Char_temp);
	}while(Char_temp!=ENTER);
}
//_________________________________________________________________
//	Soros porton rkezett j karakterkdok bevitele CG RAM_ba	   |
//	8 karakter, minden karakternek 8 bjt ponttrol.			   |	
//	Kezdcmek: 0, 8, 16, 24, 32, 40, 48, 56 					   | 
//  Csomag felpts: 0: parancs, 1: CG RAM cm, 2..9: pixel bjtok|
//_________________________________________________________________|
void Uj_Karakter_Generalas(void)
{
	unsigned char a;
	LCD_2x4bit_Parancs(0B01000000 | LCD_Buffer[1]); 		//CG Karaktertbla parancs
	for(a=2;a<10;a++)
	{
		LCD_2x4bit_Karakter(LCD_Buffer[a]);		// A nyolc pontokat ler bjt betltse CG RAM-ba	
	}		
}

//Megszakts kezelse
void interrupt tc_int(void)
{
	unsigned char REC_temp;	

    if (T0IE && T0IF) 
	{
		//Szoftveres PWM
		S_PWM_Period++;

		if (S_PWM_Period==100) 
		{
			LCD_Hatter_LED = Be;
			Contrast = Be;
			S_PWM_Period=0;
		}
		if (S_PWM_Dutty==S_PWM_Period)
		{ 
			LCD_Hatter_LED=Ki;
		}
		if (Contr_PWM_Dutty==S_PWM_Period)
		{ 
			Contrast=Ki;
		}


		//USART Idtllps
		if(Flag_1.REC_1Byte){
			if(REC_Err_Count==500){
				SPEN=Ki;	
				SPEN=Be;	//Soros port bekapcsolva
				REC_Counter=0;
				REC_Err_Count++;
				Flag_1.REC_1Byte=Ki;
				LED=Ki;			
			}
			else{
				if(REC_Err_Count<500)	REC_Err_Count++;
			}
		}
        T0IF=Clear;
		TMR0 = TMR0 + 100;
    }

	// USART
    if (RCIE && RCIF) 
	{
		LED=Be;
		if(Flag_1.REC_1Byte==Ki){
			REC_Err_Count=Clear; 	//Idtllps kezelse
			Flag_1.REC_1Byte=Be;	//Jelzs az idtllps lekezelshez, hogy bejtt az els bjt.
		}

		REC_temp=RCREG;
		if(LCD_Buffer[0]==Karakter_Gen)
		{
			LCD_Buffer[REC_Counter]=REC_temp;
			REC_Counter++;			
			if(REC_Counter==11)
			{
				REC_Counter=0;
				Flag_1.REC_1Byte=Ki;
				Flag_1.REC_Kesz=True;		// Vtel ksz jelz belltsa, adatok feldolgozsa kezddhet.
			}
		}
		else
		{
			if (REC_temp!=ENTER) 
			{
				LCD_Buffer[REC_Counter]=REC_temp;
				REC_Counter++;
			}
			else
			{
				LCD_Buffer[REC_Counter]=REC_temp; //vge karaktert is rgztjk
				REC_Counter=0;
				Flag_1.REC_1Byte=Ki;
				Flag_1.REC_Kesz=True;		// Vtel ksz jelz belltsa, adatok feldolgozsa kezddhet.
			}
		}	
	}

    return;
}

