/*
 * main.c
 */
#include <msp430.h>
#include "i2c_g2xx2.h"

char adat_f[11];
const char bitek[11] = {"Hello World"};


void main(void){

	char i;

	WDTCTL = WDTPW + WDTHOLD;             // Stop watchdog
	BCSCTL1 = CALBC1_1MHZ;                // Set DCO
	DCOCTL = CALDCO_1MHZ;

	P1DIR |= BIT0;
	P1OUT &= ~BIT0;
	
	i2c_init();                          // i2c setup
	                              // ------------------ eeprom rs
	i2c_start();                         // i2c start
    i2c_slave_cim(0x50,0);               // slave cm 1-el jobbra tolva + rs
    i2c_write_byte(0x00);                // eeprom register cm. Ahova az adat kerl

    for(i=0; i < 11; i++){
    	i2c_write_byte(bitek[i]);        // Szveg rsa az eepromba
	     __delay_cycles(100);
    }
    i2c_stop();                          // i2c stop
	 __delay_cycles(100000);
	                              // ------------------ eeprom olvass
     i2c_start();                        // i2c start
     i2c_slave_cim(0x50,0);              // slave cm 1-el jobbra tolva + rs
     i2c_write_byte(0x00);               // eeprom register cm. Ahonnan kiolvassuk az adatot
     i2c_start_ismetles();               // jra start
     i2c_slave_cim(0x50,1);              // slave cm 1-el jobbra tolva + olvass

     for(i=0; i < 11; i++){
    	 adat_f[i] = i2c_read_byte();    // A visszatrsi rtk lesz az olvasott bjt
	     __delay_cycles(100);
	     i2c_ack(1);
     }
     i2c_ack(0);
	 i2c_stop();                         // i2c stop

	 while(1){
		 P1OUT ^= BIT0;
		 __delay_cycles(20000);
	 }

}
