// ---------------------------- Szitkovits Gbor ---------- 2012.06.01 -----------------------------
// ------------ MSP430g2xx1-g2xx2 USI I2C kommunikci ---------------------------------------------
/* Megjegyzs: 
               - "i2c init" : USI perifria belltsa i2c master mdra
               - "i2c start" : i2c kommunikci indtsa
               - "i2c stop" : i2c kommunikci lelltsa
               - "i2c slave cm" : Slave eszkz cme. A program balra igaztja !!! 
                                   A program balra igaztja !!! Nem midegyik eszkzhz j !!!
                                   rsnl 0xXY,0 , ahol a "0" az R/W bit.
                                   Olvassnl 0xXY,1 , ahol a "1" az R/W bit. 
               - "i2c write byte" : egy bjt kldse, slave eszkznek.
               - "i2c read byte" : egy bjt fogadsa, slave eszkzrl.
               - "i2c ack" : NACK/ACK klds. Ha "1", akkor ACK klds, ha "0", akkor NACK.
*/
#include <msp430.h>
#include "stdint.h"
#include "i2c_g2xx2.h"

// --------------------- i2c inicializls ---------------------------------------------------------
void i2c_init(void){
    USICTL0 = USIPE7 + USIPE6 + USIMST + USIOE + USISWRST;
    // master md, adat ki engedlyezs, P1.6 SCL P1.7 SDA engedlyezs, szoftveres reset
    USICKCTL = USIDIV_7 + USISSEL_2 + USICKPL;                // ra=SMCLK/64
    USICTL1 = USII2C;                                         // I2C md
    USICTL0 &= ~USISWRST;                                     // reset USI engedlyezs
    USICTL1 &= ~(USIIFG + USISTTIFG);                         // flag trlse
}                                   // void
// --------------------- i2c indtsa --------------------------------------------------------------
void i2c_start(void){
    USISRL = 0xff;
    USICTL0 |= USIGE;
    USICTL0 &= ~(USIGE + USIOE);  
    __delay_cycles(100);
    USISRL = 0x00;
    USICTL0 |= USIGE + USIOE;
    USICTL0 &= ~USIGE;
}                                   // void
// --------------------- i2c start ismtls --------------------------------------------------------
void i2c_start_ismetles(void){
    USICTL0 |= USIOE;
    USISRL = 0xFF;
    USICNT = 1;
    while((USICTL1 & USIIFG) != 0x01);
    __delay_cycles(100);
    USISRL = 0x00;
    USICTL0 |= USIGE+USIOE;
    USICTL0 &= ~USIGE;
}                                   // void
// --------------------- i2c lelltsa ------------------------------------------------------------
void i2c_stop(void){
    USICTL0 |= USIOE;
    USISRL = 0x00;
    USICNT = 1;                             // 1 bit kldse
    while((USICTL1 & USIIFG) != 0x01);      // vrunk mg USIIFG, egy nem lesz
    USISRL = 0xFF;
    USICTL0 |= USIGE;
    USICTL0 &= ~(USIGE + USIOE);
}                                   // void
// --------------------- i2c slave cm kldse -----------------------------------------------------
uint8_t i2c_slave_cim(uint8_t scim, char olvas){
    scim <<= 1;
    if(olvas){
        scim |= 0x01;
    }
    return(i2c_write_byte(scim));
}                                   // int
// --------------------- i2c 1 bjt kldse --------------------------------------------------------
uint8_t i2c_write_byte(uint8_t byte){
    USICTL0 |= USIOE;                       // klds
    USISRL = byte;                          // kldend bjt
    USICNT = 8;                             // 8 bit
    while((USICTL1 & USIIFG) != 0x01);      // vrunk mg USIIFG, egy nem lesz
                      //  NACK/ACK ellenrzs
    USICTL0 &= ~USIOE;
    USICNT = 1;
    while((USICTL1 & USIIFG) != 0x01);      // vrunk mg USIIFG, egy nem lesz

    if(USISRL & 0x01){
	return 0;
    }
    return 1;
}                                   // int
// --------------------- i2c 1 bjt olvassa -------------------------------------------------------
uint8_t i2c_read_byte(void){
    USICTL0 &= ~USIOE;
    USICNT = 8;
    while((USICTL1 & USIIFG) != 0x01);      // vrunk mg USIIFG, egy nem lesz
    return USISRL;
}                                   // int
// --------------------- NACK/ACK kldse ----------------------------------------------------------
void i2c_ack(char ack){                    // (N)ACK bit kldse
    USICTL0 |= USIOE;
    if(ack){
        USISRL = 0x00;
    }
    else{
        USISRL = 0xff;
    }
    USICNT = 1;
    while((USICTL1 & USIIFG) != 0x01);      // vrunk mg USIIFG, egy nem lesz
    USICTL0 &= ~USIOE;
}                                   // void
