///////////////////////////////////////////////////////////////////////////
////                      ex_pcd_load.c                                ////
////                                                                   ////
////  This program is an example application program that can be       ////
////  be loaded, recompiled and reloaded by a stand alone bootloader.  ////
////                                                                   ////
////  Before loading this program the bootloader (ex_pcd_bootloader.c) ////
////  must be compiled and loaded into the target chip.                ////
////                                                                   ////
////  Use an RS232 link and the SIOW.EXE program to load this HEX file ////
////  into the target chip.  See ex_pcd_bootloader.c for more          ////
////  information.                                                     ////
////                                                                   ////
////                                                                   ////
////  This example will work with the PCD compiler.  The               ////
////  following conditional compilation lines are used to include a    ////
////  valid device for each compiler.  Change the device, clock,       ////
////  push button, and RS232 pins for your hardware if needed.         ////
///////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,2008 Custom Computer Services           ////
//// This source code may only be used by licensed users of the CCS    ////
//// C compiler.  This source code may only be distributed to other    ////
//// licensed users of the CCS C compiler.  No other use,              ////
//// reproduction or distribution is permitted without written         ////
//// permission.  Derivative programs created using this software      ////
//// in object code form are not restricted in any way.                ////
///////////////////////////////////////////////////////////////////////////

//These defines control the chip family that this program will compile for.
//The setup for 4 different chips, one from each of these chip families,
//is listed below.
#define DSPIC33FJ
//#define DSPIC30F
//#define PIC24FJ
//#define PIC24HJ


//This define controls whether or not the bootloader is included in the
//final hex file for programming.(Defined=yes, commented out = no)

//#define _bootloader


#if defined DSPIC33FJ
   #include <33FJ128GP706.h>
   #fuses HS,NOWDT,NOCOE,NODEBUG,PR, NOWRTB, NOPUT, NOWRTSS, NOWRT, NOPROTECT, NORSS 
   #define PUSH_BUTTON PIN_B2
   #define FUSE_START 
   #device adc=8
   #use delay(clock=12000000)
   #use rs232(baud=9600, parity=N, rcv=PIN_F4, xmit=PIN_F5)
#endif

#if defined DSPIC30F
   #include <30F2012.h>
   #fuses HS,NOWDT,NOCOE,NODEBUG,FRC, NOPUT, NOWRT, NOPROTECT 
   #define PUSH_BUTTON PIN_B2
   #device adc=8
   #use delay(clock=7350000)
   #use rs232(baud=9600, UART1A)
#endif

#if defined PIC24FJ
   #include <24FJ64GA004.h>
   #fuses HS,NOWDT,NODEBUG,FRC,  NOWRT, NOPROTECT 
   #define PUSH_BUTTON PIN_A9
   #pin_select U2TX = PIN_C9 
   #pin_select U2RX = PIN_C3
   #device adc=8
   #use delay(clock=8000000)
   #use rs232(baud=9600, UART2)
#endif

#if defined PIC24HJ
   #include <24HJ128GP306.h>
   #fuses HS,NOWDT,NODEBUG,FRC,  NOWRT, NOPROTECT 
   #define PUSH_BUTTON PIN_F6
   #device adc=8
   #use delay(clock=7350000)
   #use rs232(baud=9600, rcv=PIN_F4, xmit=PIN_F5)
#endif

//This is a neccessary include file.  It reserves space so that the
//bootloader is not overwritten.
#include "pcd_bootloader.h"

#org default

void main(void)
{
   setup_adc_ports(NO_ANALOGS);
   setup_adc_ports2(NO_ANALOGS);    //33FJ128GP706 only
   
   delay_ms(100);
   
//On powerup, if the designated button/pin is held low, the program
//will jump to the bootloader, allowing for serial programming.
   if(!input(PUSH_BUTTON))
   {
      #asm
      goto LOADER_ADDR
      #endasm
   }
   
   printf("You can put whatever code you want here.\r\n");
   printf("So enjoy!\r\n");
   
   while(1);
}
