
///  THIS PROGRAM IS A FIXED PROGRAM THAT RESIDES ALWAYS IN THE PIC TO
///  ALLOW BOOTLOADING OF THE APPLICATION AND TO PROVIDE STANDARD RESIDENT
///  FUNCTIONS TO THE APPLICATION

#include <18F4520.h>
#fuses HS,NOWDT,NOPROTECT,NOLVP

#define LOADER_END   0x4FF

#export(c,file="api.h",only="api_load_program,api_getc,api_putc,api_kbhit", \
         hexcomment="This file is created by compiling 'bootloader.c'")

#build(share_interrupts) // allows both programs to receive interrupts

#reserve 0x005:0x4FF     // For the application
#ORG LOADER_END+1,getenv("PROGRAM_MEMORY")-1 {}  // For the application

int1 app_running=FALSE;
int32 ticks=0;

#int_timer0
void timer0_isr(void) {
   // our code here
   ticks++;   
   // now execute the applications isr
   if(app_running)
      jump_to_isr(LOADER_END+5*(getenv("BITS_PER_INSTRUCTION")/8));
}

#int_default
void default_isr(void) {
   if(app_running)
      jump_to_isr(LOADER_END+5*(getenv("BITS_PER_INSTRUCTION")/8));
}


#use delay(clock=20000000)
#use rs232(baud=9600, xmit=PIN_C6, rcv=PIN_C7) 


///////////////////////////////////////////////////////// BOOTLOADER
#define BUFFER_LEN_LOD 64

int  buffidx;
char buffer[BUFFER_LEN_LOD];

#define ACKLOD 0x06
#define XON    0x11
#define XOFF   0x13



unsigned int atoi_b16(char *s) {  // Convert two hex characters to a int8
   unsigned int result = 0;
   int i;

   for (i=0; i<2; i++,s++)  {
      if (*s >= 'A')
         result = 16*result + (*s) - 'A' + 10;
      else
         result = 16*result + (*s) - '0';
   }

   return(result);
}

void api_load_program (void)
{
   int1  do_ACKLOD, done=FALSE;
   int8  checksum, line_type;
   int16 l_addr,h_addr=0;
   int32 addr;
   #if getenv("FLASH_ERASE_SIZE")>2
      int32 next_addr;
   #endif
   int8  dataidx, i, count;
   int8  data[32];

   while (!done)  // Loop until the entire program is downloaded
	{
      buffidx = 0;  // Read into the buffer until 0x0D ('\r') is received or the buffer is full
      do {
         buffer[buffidx] = getc();
      } while ( (buffer[buffidx++] != 0x0D) && (buffidx <= BUFFER_LEN_LOD) );

      putchar (XOFF);  // Suspend sender

      do_ACKLOD = TRUE;

		// Only process data blocks that start with ':'
      if (buffer[0] == ':') {
         count = atoi_b16 (&buffer[1]);  // Get the number of bytes from the buffer

			// Get the lower 16 bits of address
         l_addr = make16(atoi_b16(&buffer[3]),atoi_b16(&buffer[5]));

         line_type = atoi_b16 (&buffer[7]);

         addr = make32(h_addr,l_addr);

         #if defined(__PCM__)  // PIC16 uses word addresses
            addr /= 2;
         #endif

			// If the line type is 1, then data is done being sent
         if (line_type == 1) {
            done = TRUE;
         #if defined(__PCM__)
         } else if ((addr > LOADER_END) && addr < 0x2000){
         #elif defined(__PCH__)
         } else if ((addr > LOADER_END) && addr < 0x300000){
         #endif
            checksum = 0;  // Sum the bytes to find the check sum value
            for (i=1; i<(buffidx-3); i+=2)
               checksum += atoi_b16 (&buffer[i]);
            checksum = 0xFF - checksum + 1;

            if (checksum != atoi_b16 (&buffer[buffidx-3]))
               do_ACKLOD = FALSE;
            else	{
               if (line_type == 0) {
						// Loops through all of the data and stores it in data
						// The last 2 bytes are the check sum, hence buffidx-3
                  for (i = 9,dataidx=0; i < buffidx-3; i += 2)
                     data[dataidx++]=atoi_b16(&buffer[i]);

                  #if getenv("FLASH_ERASE_SIZE") > getenv("FLASH_WRITE_SIZE")
                     #if defined(__PCM__)
                        if ((addr!=next_addr)&&(addr&(getenv("FLASH_ERASE_SIZE")-1)!=0))
                     #else
                        if ((addr!=next_addr)&&(addr&(getenv("FLASH_ERASE_SIZE")/2-1)!=0))
                     #endif
                           erase_program_eeprom(addr);
                     next_addr = addr + 1;
                  #endif
                  write_program_memory(addr, data, count);
               }
               else if (line_type == 4)
                  h_addr = make16(atoi_b16(&buffer[9]), atoi_b16(&buffer[11]));
            }
         }
      }

      if (do_ACKLOD)
         putchar (ACKLOD);

      putchar(XON);
   }

   putchar (ACKLOD);
   putchar(XON);
   reset_cpu();
}

///////////////////////////////////////////////////////////// POWER UP CODE

void main(void) {
   setup_timer_0(RTCC_INTERNAL);
   enable_interrupts(INT_TIMER0);
   enable_interrupts(GLOBAL);

   if(!input(PIN_B5))
   {
      api_load_program();
   }
   app_running=TRUE;
   goto_address(LOADER_END+1); 
}

///////////////////////////////////////////////////////////// APPLICATION INTERFACE

void api_putc(char c) {
   putc(c);
}


char api_getc(void) {
   return getc();
}


int8 api_kbhit() {
   return kbhit();
}

