/////////////////////////////////////////////////////////////////////////
////                             EX_FFT.C                            ////
////                                                                 ////
////  This program performs FFT operation on a block of an input.    ////
////  The FFT is performed in place. The input is taken in natural   ////
////  ordering and then bit reversal is performed on it.             ////
////  The samples are sorted in bit-reversed order by using the      ////
////  MODCON and XBREV register.                                     ////
////  The twiddle factors used for the butterfly computation are     ////
////  calculated and stored in data memory.                          ////
////  The algorithm implements a radix-2 FFT on a block 256 data     ////
////  elements stored in X data space.                               ////
////                                                                 ////
////  This example will work only with the PCD Compiler.             ////
/////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,2009 Custom Computer Services         ////
//// This source code may only be used by licensed users of the CCS  ////
//// C compiler.  This source code may only be distributed to other  ////
//// licensed users of the CCS C compiler.  No other use,            ////
//// reproduction or distribution is permitted without written       ////
//// permission.  Derivative programs created using this software    ////
//// in object code form are not restricted in any way.              ////
/////////////////////////////////////////////////////////////////////////

#if defined(__PCD__)
#include <33FJ128GP306.h>
#fuses HS, NOWDT, NOPROTECT, PR
#use delay(clock=12000000)
#else 
#error This example works only for PCD. Please select the PCD Compiler
#endif

int log2N=8;   // Number of stages of the FFT : 8 for 256 point FFT

#include <math.h>
#include "fft.h"
#include "twid_factors.c"
#include "fft.c"


void main(void)
{
   int * ptrin;
   int * twid;


   Init_Twid_factors();

  
   ptrin = &input[0];
   twid = &Twid_factor[0];
   
   // Call routine to load input values into buffer   
   load_input(&input[0]);
    
   // Call function to reverse the bit order of the data
   // before processing calculating the FFT
   Call_bit_reverse(ptrin);

   // Call the FFT routine
   fft_complex(ptrin, twid);
   
   while(1);
   
}

