
#include "project.h"

#include "report.h"

#define WINDOW_SIZE 10

long history[WINDOW_SIZE];
int points, history_ptr;


void filter_clear() {
   points=0;
   history_ptr=0;
}


int32 calculate_average() {
   int i;
   int32 sum;

   for(sum=0,i=0; (i<WINDOW_SIZE) && (i<points); i++)
      sum+=history[i];
   return sum/i;
}


long filter_data(long value) {
   long filtered;
   
   points++;
   history[history_ptr]=value;
   history_ptr=(history_ptr+1) % WINDOW_SIZE;

   filtered = calculate_average();
   if(value > (filtered+100))
     report_error(err_too_far);
   
   return filtered;
}


