#ifndef _ONEWIRE_H_
#define _ONEWIRE_H_

#include "mal.h"

#define	HIGH	1
#define	LOW		0
#define	OUTPUT	0
#define	INPUT 	1
#define	SET		1
#define	CLEAR	0

#define OW_SEARCH_ROM		0xF0
#define OW_READ_ROM			0x33
#define OW_MATCH_ROM		0x55
#define OW_SKIP_ROM			0xCC
#define OW_ALARM_SEARCH		0xEC

#define DELAY_6Us	6
#define DELAY_9Us	9
#define DELAY_10Us	10
#define DELAY_55Us	55
#define DELAY_60Us	60
#define DELAY_64Us	64
#define DELAY_70Us	70


typedef struct _OW_device_struct {
	unsigned char family;
	unsigned char serial_number[6];
	unsigned char crc;
} OW_device_struct;

typedef union _OW_device {
	OW_device_struct value;
	unsigned char byte[8];
} OW_device;

typedef enum _OW_ADDRESSING_MODE {
	OW_SKIP_ROM_ADDRESS,
	OW_MATCH_ROM_ADDRESS
} OW_ADDRESSING_MODE;

extern void drive_OW_low (void);
extern void drive_OW_high (void);
extern unsigned char read_OW (void);
extern unsigned char OW_reset_pulse(void);
extern void OW_write_bit (unsigned char write_bit);
extern unsigned char OW_read_bit (void);
extern void OW_write_byte (unsigned char write_data);
extern unsigned char OW_read_byte (void);
extern void set_OW_addressing_mode(OW_ADDRESSING_MODE new_OW_addressing_mode);
extern void OW_address_device(OW_device ow_device);
extern unsigned char OW_read_rom(OW_device *ow_device);

#endif
