#include "Config.h"
#include "1wire.h"
#include "ds1820.h"
#include <stdio.h>

unsigned char ds1820_get_temperature(OW_device ow_device, float *temperature) {
	unsigned char result = 0;
	if (temperature != NULL) {
		switch (ow_device.value.family) {
			case DS18B20_FAMILY_CODE : {
				//ds18b20_init(ow_device);
				ds18b20_set_resolution(ow_device, DS18B20_12bit);
				if (ds18b20_get_temperature(ow_device, temperature)) {
					result = 1;
				} else {
					result = 0;
				}
				break;
			}
			case DS18S20_FAMILY_CODE : {
				//ds18s20_init(ow_device);
				if (ds18s20_get_temperature(ow_device, temperature)) {
					result = 1;
				} else {
					result = 0;
				}
				break;
			}
			default : {
				break;
			}
		}
	} else {
	}
	return result;
}
