#include "Config.h"
#include "1wire.h"
#include "ds18s20.h"
#include <stdio.h>
#include "1wireCRC.h"

DS18S20_POWERING ds18s20_powering = DS18S20_EXTERNAL_SUPPPLY;

static float ds18s20_convert_temperature(unsigned int rawTemp);
static DS18S20_device ds18s20_read_scratchpad(OW_device ow_device);

void ds18s20_init(OW_device ow_device) {
	ds18s20_set_powering(ds18s20_detect_powering(ow_device));
}

DS18S20_POWERING ds18s20_detect_powering(OW_device ow_device) {
	DS18S20_POWERING result = DS18S20_EXTERNAL_SUPPPLY;
	if (!OW_reset_pulse()) {
		OW_address_device(ow_device);
		OW_write_byte(DS18S20_READ_POWER_SUPPLY);
		result = OW_read_bit();
		if (result) {
			//printf("Power 1\r\n");
		} else {
			//printf("Power 0\r\n");
		}
	} else {
		result = DS18S20_NO_POWER;
	}
	return result;
}

void ds18s20_set_powering(DS18S20_POWERING new_ds18s20_powering) {
	ds18s20_powering = new_ds18s20_powering;
}

unsigned char ds18s20_get_temperature(OW_device ow_device, float *temperature) {
	unsigned char result = 0;
	if (temperature != NULL) {
		unsigned int i = 0;
		DS18S20_device ds18s20_device;
		
		if (!OW_reset_pulse()) {
			//present
			OW_address_device(ow_device);
			OW_write_byte(DS18S20_CONVERT_T);
			switch (ds18s20_powering) {
				case DS18S20_PARASITIC : {
					drive_OW_high();
					for (i = 0; i < 7500; i++) {
						wait(200);
					}
					read_OW();
					break;
				}
				case DS18S20_EXTERNAL_SUPPPLY : {
					for (i = 0; i < 7500; i++) {
						wait(100);
						if (OW_read_bit() == 1) {
							//printf("Conversion done.\r\n");
							break;
						}
					}
					break;
				}
				default : {
					break;
				}
			}
			ds18s20_device = ds18s20_read_scratchpad(ow_device);
			{
				unsigned char myCRC = 0;
				unsigned char receivedCRC = ds18s20_device.value.crc;
				myCRC =  calculateOneWireCRC(ds18s20_device.byte, (sizeof(ds18s20_device.byte) / sizeof(*ds18s20_device.byte)));
				if (myCRC == receivedCRC) {
					if ((ds18s20_device.value.reserved1 == 0xFF) && (ds18s20_device.value.reserved2 == 0xFF)) {
						*temperature = ds18s20_convert_temperature(ds18s20_device.value.temperature);
						result = 1;
					} else {
					}
				} else {
				}
			}

		} else {
			//not present
		}
	} else {
	}
	return result;
	
}

static DS18S20_device ds18s20_read_scratchpad(OW_device ow_device) {
	DS18S20_device result;
	unsigned int i = 0;
	result.longint[0] = 0;
	result.longint[1] = 0;
	if (!OW_reset_pulse()) {
		//present
		OW_address_device(ow_device);
		OW_write_byte(DS18S20_READ_SCRATCHPAD);
		//printf("------------\r\n");
		for (i = 0; i < 8; i++) {
			result.byte[i] = OW_read_byte();
			//printf("Data[%u]:0x%2.2X\r\n", i, result.byte[i]);
		}
		//printf("Temperature:0x%4.4X %u\r\n", result.value.temperature, result.value.temperature / 16);
	} else {
		//not present
	}
	return result;
}

static float ds18s20_convert_temperature(unsigned int rawTemp) {
	float result = 0;
	int temp = 0;
	temp = (int)rawTemp;
	result = temp;
	//printf("Raw:%u\r\n", rawTemp);
	//printf("Raw:%d\r\n", temp);
	result /= 2;
	//printf("Raw:%d\r\n", (int)result);
	return result;
}
