// ---------------------- Nokia 5110 drive ---------------------------------------------------------
// ---------------------------------------- Reset nlkl!!!!!! -------------------------------------
// ------- A reset lbat fel kell hzni 47k-val ----------------------------------------------------

#include "nokia_lcd.h"

extern char neg ;

const unsigned char font6x8[][6] = {
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   // sp
    { 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00 },   // !
    { 0x00, 0x00, 0x07, 0x00, 0x07, 0x00 },   // "
    { 0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14 },   // #
    { 0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12 },   // $
    { 0x00, 0x62, 0x64, 0x08, 0x13, 0x23 },   // %
    { 0x00, 0x36, 0x49, 0x55, 0x22, 0x50 },   // &
    { 0x00, 0x00, 0x05, 0x03, 0x00, 0x00 },   // '
    { 0x00, 0x00, 0x1c, 0x22, 0x41, 0x00 },   // (
    { 0x00, 0x00, 0x41, 0x22, 0x1c, 0x00 },   // )
    { 0x00, 0x14, 0x08, 0x3E, 0x08, 0x14 },   // *
    { 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08 },   // +
    { 0x00, 0x00, 0x00, 0xA0, 0x60, 0x00 },   // ,
    { 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },   // -
    { 0x00, 0x00, 0x60, 0x60, 0x00, 0x00 },   // .
    { 0x00, 0x20, 0x10, 0x08, 0x04, 0x02 },   // /
    { 0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E },   // 0
    { 0x00, 0x00, 0x42, 0x7F, 0x40, 0x00 },   // 1
    { 0x00, 0x42, 0x61, 0x51, 0x49, 0x46 },   // 2
    { 0x00, 0x21, 0x41, 0x45, 0x4B, 0x31 },   // 3
    { 0x00, 0x18, 0x14, 0x12, 0x7F, 0x10 },   // 4
    { 0x00, 0x27, 0x45, 0x45, 0x45, 0x39 },   // 5
    { 0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30 },   // 6
    { 0x00, 0x01, 0x71, 0x09, 0x05, 0x03 },   // 7
    { 0x00, 0x36, 0x49, 0x49, 0x49, 0x36 },   // 8
    { 0x00, 0x06, 0x49, 0x49, 0x29, 0x1E },   // 9
    { 0x00, 0x00, 0x36, 0x36, 0x00, 0x00 },   // :
    { 0x00, 0x00, 0x56, 0x36, 0x00, 0x00 },   // ;
    { 0x00, 0x08, 0x14, 0x22, 0x41, 0x00 },   // <
    { 0x00, 0x14, 0x14, 0x14, 0x14, 0x14 },   // =
    { 0x00, 0x00, 0x41, 0x22, 0x14, 0x08 },   // >
    { 0x00, 0x02, 0x01, 0x51, 0x09, 0x06 },   // ?
    { 0x00, 0x32, 0x49, 0x59, 0x51, 0x3E },   // @
    { 0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C },   // A
    { 0x00, 0x7F, 0x49, 0x49, 0x49, 0x36 },   // B
    { 0x00, 0x3E, 0x41, 0x41, 0x41, 0x22 },   // C
    { 0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C },   // D
    { 0x00, 0x7F, 0x49, 0x49, 0x49, 0x41 },   // E
    { 0x00, 0x7F, 0x09, 0x09, 0x09, 0x01 },   // F
    { 0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A },   // G
    { 0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F },   // H
    { 0x00, 0x00, 0x41, 0x7F, 0x41, 0x00 },   // I
    { 0x00, 0x20, 0x40, 0x41, 0x3F, 0x01 },   // J
    { 0x00, 0x7F, 0x08, 0x14, 0x22, 0x41 },   // K
    { 0x00, 0x7F, 0x40, 0x40, 0x40, 0x40 },   // L
    { 0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F },   // M
    { 0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F },   // N
    { 0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E },   // O
    { 0x00, 0x7F, 0x09, 0x09, 0x09, 0x06 },   // P
    { 0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E },   // Q
    { 0x00, 0x7F, 0x09, 0x19, 0x29, 0x46 },   // R
    { 0x00, 0x46, 0x49, 0x49, 0x49, 0x31 },   // S
    { 0x00, 0x01, 0x01, 0x7F, 0x01, 0x01 },   // T
    { 0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F },   // U
    { 0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F },   // V
    { 0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F },   // W
    { 0x00, 0x63, 0x14, 0x08, 0x14, 0x63 },   // X
    { 0x00, 0x07, 0x08, 0x70, 0x08, 0x07 },   // Y
    { 0x00, 0x61, 0x51, 0x49, 0x45, 0x43 },   // Z
    { 0x00, 0x00, 0x7F, 0x41, 0x41, 0x00 },   // [
    { 0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55 },   // 55
    { 0x00, 0x00, 0x41, 0x41, 0x7F, 0x00 },   // ]
    { 0x00, 0x04, 0x02, 0x01, 0x02, 0x04 },   // ^
    { 0x00, 0x40, 0x40, 0x40, 0x40, 0x40 },   // _
    { 0x00, 0x00, 0x01, 0x02, 0x04, 0x00 },   // '
    { 0x00, 0x20, 0x54, 0x54, 0x54, 0x78 },   // a
    { 0x00, 0x7F, 0x48, 0x44, 0x44, 0x38 },   // b
    { 0x00, 0x38, 0x44, 0x44, 0x44, 0x20 },   // c
    { 0x00, 0x38, 0x44, 0x44, 0x48, 0x7F },   // d
    { 0x00, 0x38, 0x54, 0x54, 0x54, 0x18 },   // e
    { 0x00, 0x08, 0x7E, 0x09, 0x01, 0x02 },   // f
    { 0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C },   // g
    { 0x00, 0x7F, 0x08, 0x04, 0x04, 0x78 },   // h
    { 0x00, 0x00, 0x44, 0x7D, 0x40, 0x00 },   // i
    { 0x00, 0x40, 0x80, 0x84, 0x7D, 0x00 },   // j
    { 0x00, 0x7F, 0x10, 0x28, 0x44, 0x00 },   // k
    { 0x00, 0x00, 0x41, 0x7F, 0x40, 0x00 },   // l
    { 0x00, 0x7C, 0x04, 0x18, 0x04, 0x78 },   // m
    { 0x00, 0x7C, 0x08, 0x04, 0x04, 0x78 },   // n
    { 0x00, 0x38, 0x44, 0x44, 0x44, 0x38 },   // o
    { 0x00, 0xFC, 0x24, 0x24, 0x24, 0x18 },   // p
    { 0x00, 0x18, 0x24, 0x24, 0x18, 0xFC },   // q
    { 0x00, 0x7C, 0x08, 0x04, 0x04, 0x08 },   // r
    { 0x00, 0x48, 0x54, 0x54, 0x54, 0x20 },   // s
    { 0x00, 0x04, 0x3F, 0x44, 0x40, 0x20 },   // t
    { 0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C },   // u
    { 0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C },   // v
    { 0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C },   // w
    { 0x00, 0x44, 0x28, 0x10, 0x28, 0x44 },   // x
    { 0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C },   // y
    { 0x00, 0x44, 0x64, 0x54, 0x4C, 0x44 },   // z
    { 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 }    // horiz lines
};
/*--------------------------- Egyedi szmok s jelek ---------------------------------------------*/
const unsigned char jelek_hex[]= {
    // .
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x70, 0xf8, 0xf8, 0xf8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    // -
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00,
    // C
    0xe0, 0xf8, 0xfc, 0xfe, 0xfe, 0x07, 0x01, 0x01, 0x01, 0x03, 0x1e, 0x1c, 0x00, 
    0x0f, 0x3f, 0x7f, 0x7f, 0xff, 0xe0, 0xc0, 0x80, 0x80, 0x80, 0x60, 0x7c, 0x1c,
    // fok
    0x0e, 0x1f, 0x1b, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    
    // SP
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
   };
const unsigned char szamok_hex[] = {
    // 0
    0xf0, 0xfc, 0xfe, 0xfe, 0xff, 0x03, 0x01, 0x03, 0xff, 0xfe, 0xfe, 0xfc, 0xf0, 
    0x0f, 0x3f, 0x7f, 0x7f, 0xff, 0xc0, 0x80, 0xc0, 0xff, 0x7f, 0x7f, 0x3f, 0x0f,
    // 1
    0x00, 0x00, 0x18, 0x1c, 0x1e, 0x0e, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    // 2
    0x00, 0x3c, 0x3e, 0x42, 0x01, 0x01, 0x01, 0x81, 0xc3, 0xff, 0xfe, 0x7e, 0x3c, 
    0x00, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xf7, 0xf3, 0xf1, 0xf0, 0xf0, 0x70,
    // 3
    0x00, 0x10, 0x0e, 0x12, 0x81, 0x81, 0x81, 0x81, 0xc3, 0xff, 0x7e, 0x7e, 0x3c, 
    0x00, 0x38, 0x78, 0xc0, 0x80, 0x80, 0x80, 0xc1, 0xff, 0xff, 0x7f, 0x7f, 0x3e,
    // 4
    0x00, 0x00, 0x00, 0x80, 0xc0, 0x70, 0x18, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x1c, 0x1e, 0x1b, 0x19, 0x18, 0x18, 0xff, 0xff, 0xff, 0xff, 0x18, 0x18,
    // 5
    0x00, 0x00, 0xf8, 0xff, 0xc7, 0x67, 0x67, 0xe7, 0xe7, 0xe7, 0xc7, 0x87, 0x00, 
    0x00, 0x38, 0x79, 0xe1, 0xc0, 0xc0, 0xc0, 0xe0, 0xf1, 0x7f, 0x7f, 0x3f, 0x1f,
    // 6
    0xf0, 0xfc, 0xfe, 0xfe, 0xff, 0xc7, 0x61, 0xe1, 0xe1, 0xe3, 0xce, 0xce, 0x00, 
    0x0f, 0x3f, 0x7f, 0x7f, 0xff, 0xc0, 0x80, 0xc0, 0xff, 0xff, 0x7f, 0x3f, 0x1f,
    // 7
    0x00, 0x0e, 0x0f, 0x0f, 0x0f, 0x0f, 0x8f, 0xcf, 0xef, 0xff, 0x7f, 0x1f, 0x06, 
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00,
    // 8
    0x38, 0xfe, 0xff, 0xf7, 0xe3, 0xe3, 0xc3, 0xc3, 0xe6, 0xbe, 0x9c, 0x00, 0x00, 
    0x1c, 0x3e, 0x7b, 0xe1, 0xe1, 0xc3, 0xc7, 0xc7, 0xcf, 0x7f, 0x7f, 0x3f, 0x1e,
    // 9
    0xf8, 0xfc, 0xfe, 0xff, 0xff, 0x03, 0x01, 0x03, 0xff, 0xfe, 0xfe, 0xfc, 0xf8, 
    0x00, 0x73, 0x7b, 0xc7, 0x87, 0x87, 0xc2, 0xf9, 0xff, 0x7f, 0x3f, 0x1f, 0x07
};
// ------------------- kezetes betk --------------------------------------------------------------
const unsigned char ekezet[90] = {
     0x78,0x14,0x12,0x14,0x7b,         // 
     0x7c,0x54,0x56,0x55,0x56,         //  
     0x00,0x44,0x7e,0x45,0x00,         // 
     0x38,0x45,0x44,0x45,0x38,         // 
     0x38,0x46,0x45,0x46,0x39,         // 
     0x38,0x44,0x46,0x45,0x38,         // 
     0x3c,0x42,0x40,0x42,0x3c,         // 
     0x3c,0x42,0x41,0x42,0x3d,         // 
     0x3c,0x40,0x42,0x41,0x3c,         // 
     0x20,0x54,0x56,0x55,0x78,         // 
     0x38,0x54,0x56,0x55,0x18,         // 
     0x00,0x00,0x7a,0x01,0x00,         // 
     0x30,0x4a,0x48,0x4a,0x30,         // 
     0x30,0x4a,0x49,0x4a,0x31,         // 
     0x30,0x48,0x4a,0x49,0x30,         // 
     0x38,0x42,0x40,0x42,0x38,         // 
     0x38,0x42,0x41,0x42,0x39,         // 
     0x38,0x40,0x42,0x41,0x38,         // 
};
// ------------------- lcd init --------------------------------------------------------------------
void lcd_init(void){
    
    P2OUT &= ~LCD_CE;
    __delay_cycles(1);
    P2OUT |= LCD_CE;
    __delay_cycles(1);
    
    lcd_write_byte (0x21, 0);    // 
    lcd_write_byte (0xbf, 0);    // 
    lcd_write_byte (0x06, 0);    // 
    lcd_write_byte (0x13, 0);    // 
    lcd_write_byte (0x20, 0);    // 
    lcd_write_byte (0x08, 0);    // 
    lcd_write_byte (0x0c, 0);    //
    
    lcd_clear ();                // clear the screen

    P2OUT &= ~LCD_CE;
}
// ------------------- lcd trls ------------------------------------------------------------------
void lcd_clear(void){
    
    unsigned int i;

    lcd_write_byte(0x0c, 0);			
    lcd_write_byte(0x80, 0);			

    for (i=0; i<504; i++)
        lcd_write_byte(0, 1);
}
// ------------------- lcd koordinta --------------------------------------------------------------
void lcd_set_XY(unsigned char X, unsigned char Y){
    lcd_write_byte(0x40 | Y, 0);		// column
    lcd_write_byte(0x80 | X, 0);          	// row
}
// ------------------- lcd karakter rs -----------------------------------------------------------
void lcd_write_char(unsigned char c){
    
    unsigned char line;

    c -= 32;

    for (line=0; line<6; line++)
        lcd_write_byte(font6x8[c][line], 1);
}
// ------------------- lcd kezetek ----------------------------------------------------------------
void ek(char e){
        char i,ii=5*e;
    for(i=0;i<5;i++){
        lcd_write_byte(ekezet[ii+i],1);
    }
}
// ------------------- lcd szveg rsa ------------------------------------------------------------
void lcd_print(unsigned char X,unsigned char Y,char *s){
    lcd_set_XY(X,Y);
    while(*s){
        char c;
        switch(*s){
            case '': c = 0; ek(c); break;
            case '': c = 1; ek(c); break;
            case '': c = 2; ek(c); break;
            case '': c = 3; ek(c); break;
            case '': c = 4; ek(c); break;
            case '': c = 5; ek(c); break;
            case '': c = 6; ek(c); break;
            case '': c = 7; ek(c); break;
            case '': c = 8; ek(c); break;
            case '': c = 9; ek(c); break;
            case '': c = 10; ek(c); break;
            case '': c = 11; ek(c); break;
            case '': c = 12; ek(c); break;
            case '': c = 13; ek(c); break;
            case '': c = 14; ek(c); break;
            case '': c = 15; ek(c); break;
            case '': c = 16; ek(c); break;
            case '': c = 17; ek(c); break;
          default:
            lcd_write_char(*s); break;
        }
        s++;
    }
}
// ------------------- lcd kp/logo rs -----------------------------------------------------------
void lcd_write_logo(unsigned const char* ptr){
    unsigned int ctr = 0; 
    while(ctr++ < 504){
        lcd_write_byte(*ptr++,1);
    }
}
// ------------------- lcd byte rs ---------------------------------------------------------------
void lcd_write_byte(unsigned char dat, unsigned char command){
    unsigned char i;
    P2OUT &= ~LCD_CE;    
    if (command == 0)
        P2OUT &= ~LCD_DC;
    else
        P2OUT |= LCD_DC;
    for(i=0;i<8;i++){
        if(dat&0x80)
            //SDIN = 1;
            P2OUT |= LCD_DIN;
        else
            //SDIN = 0;
            P2OUT &= ~LCD_DIN;
        //SCLK = 0;
        P2OUT &= ~LCD_CLK;
        dat = dat << 1;
        //SCLK = 1;
        P2OUT |= LCD_CLK;
    }
    P2OUT |= LCD_CE;
}
// ------------------- lcd egyedi szmok rs ------------------------------------------------------
void szamok(char szam, int x, int y){
    lcd_set_XY(x,y);
    szam_1sor(szam);
    lcd_set_XY(x,y+1);
    szam_2sor(szam);
}
//------------------------------------------------------------------
void szam_1sor(char m){
        char i,ii=26*m;
    for(i=0;i<13;i++){
        lcd_write_byte(szamok_hex[ii+i],1);
    }
}
//------------------------------------------------------------------
void szam_2sor(char m){
        char i,ii=(26*m)+13;
    for(i=0;i<13;i++){
        lcd_write_byte(szamok_hex[ii+i],1);
    }
}
//-----------------------------------------------------------------
void jelek(char szam, int x, int y){
    lcd_set_XY(x,y);
    jel_1sor(szam);
    lcd_set_XY(x,y+1);
    jel_2sor(szam);
}
//------------------------------------------------------------------
void jel_1sor(char m){
        char i,ii=26*m;
    for(i=0;i<13;i++){
        lcd_write_byte(jelek_hex[ii+i],1);
    }
}
//------------------------------------------------------------------
void jel_2sor(char m){
        char i,ii=(26*m)+13;
    for(i=0;i<13;i++){
        lcd_write_byte(jelek_hex[ii+i],1);
    }
}
//------------------------------------------------------------------
void lcd_ertek(int sz){
    unsigned char tiz,egy,tized;
    if(neg){
        jelek(1, 0, 2);         // -
        neg = 0;
    }else{
        jelek(4, 0, 2);         // SP
    }
    tiz = sz / 100;
    szamok(tiz, 13, 2);
    egy = (sz %100) /10;
    szamok(egy, 28, 2);
    tized = sz %10;
    jelek(0, 42, 2);            // .
    szamok(tized, 49, 2);
    jelek(2, 64, 2);
   // jelek(3, 79, 2);
}
