// --------------------------- Szitkovits Gbor ---- 2012.07.06 ------------------------------------
// ----------- Napelemes hmr --------------------------------------------------------------------
// ---------------------------- napelem + 1,2v akksi + TPS61221 DC/DC konverter + TMP35 ------------
// ---------------------------- TMP36 szmtsa : volt = (ADC10_value)*(ref/1024)
//                                                  C = (volt - 500)/10 
//                               magyarzat : volt = volt, ADC10_value = beolvasott rtk
//                                            (ref = referencia fesz / 1024 = ADC felbonts)
//                                            C = volt - 500 = 0C / 10 = 10mV/C
// --- Teht: a volt kiszmolsa = ADC rtk * referencia fesz / AD felbonts,
// ---------- C = volt - 500mV, ami a 0C / C/mV

#include "io430.h"
#include "delay_ms.h"
//#include "stdint.h"
#include "nokia_lcd.h"

#define lcd_be BIT0
#define TMP_shutdown BIT3
#define feny_erzek BIT2
#define lcd_hv BIT6
#define TX BIT6

unsigned int szamlalo=1;
unsigned int homero_1[16];
long homero_atlag = 0, volt;
int fok;
char neg;

void analog_setup(unsigned int csat){
    ADC10CTL0 &= ~ENC;
    ADC10CTL1 = CONSEQ_2 + csat;                      // tbbszri konverzi, a "csat" bemenetrl
    ADC10CTL0 = SREF_1 + ADC10SHT_2 + MSC + REFON + REF2_5V + ADC10ON + ADC10IE; 
    // ADC10ON, megszakts eng, referencia be, ref 2.5volt
    ADC10DTC1 = 0x14;                                 // 20 konverzi
    ADC10AE0 |= BIT1;                                 // P1.1 ADC bemenet
}
void homero_olv(void){
    ADC10CTL0 &= ~ENC;
    while (ADC10CTL1 & BUSY);                  // vrunk, ha ADC10 foglalt
    ADC10SA = (unsigned int) homero_1;         // adatok mentse "homero_1"-be
    ADC10CTL0 |= ENC + ADC10SC;                // mintavtel s konverzi indtsa
    __low_power_mode_0();                      // LPM0 md bekapcsols
}
void main(void){
    
    WDTCTL = WDTPW + WDTHOLD;     // Stop WDT
    BCSCTL1 = CALBC1_1MHZ;        // A gyrilag kalibrlt 1 MHz
    DCOCTL = CALDCO_1MHZ;         // DCO frekvencia belltsa
    
    P1DIR |= (lcd_be + TMP_shutdown + lcd_hv);   // P1.0 (LCD bekapcs), P1.3 (TMP Shutdown) P1.6 (prba led)
    P1OUT &= ~TMP_shutdown;                      // P1.0,3,6 digitlis kimenet, mind alacsony
    P1OUT |= lcd_be + lcd_hv;
    P1DIR &= ~feny_erzek;                // P1.2 (fnyrzkel) bemenet
    P1OUT &= ~feny_erzek;                // P1.2 lefele hzs
    P1REN |= feny_erzek;                 // P1.2 felhz ell.
    P1IES |= feny_erzek;                 // P1.2 felfut lre
    P1IFG &= ~feny_erzek;                // P1.2 IFG trls
    P2SEL = 0;
    P2DIR |= 0x0f;                       // P2.0,1,2,3 digitlis kimenet (Nokia LCD)
    
    TACTL = ID_3 + TASSEL_2 + MC_2;      // SMCLK, folyamatos sz.
    
    while(1){
        while(szamlalo){
            if(P1OUT & lcd_be){
                TACTL = ID_3 + TASSEL_2 + MC_2 + TAIE;      // SMCLK, folyamatos sz.
                analog_setup(INCH_1);                 // ADC10 belltsok
                __enable_interrupt();                 // megszakts engedlyezse
                P1OUT &= ~lcd_be;                     // bekapcsoljuk az lcd-t
                delay_ms(50);                         // vrunk egy kicsit, hogy az lcd maghoz trjen
                lcd_init();                           // LCD inicializls
	        lcd_clear();                          // Kperny trls
                lcd_print(13,0,"Szitkovits");
                lcd_print(28,1,"Gbor");              // Logo
                lcd_print(8,3,"Solar Hmr");        // kirsa
                delay_ms(3000);                       // vrunk 3mp-et
                lcd_clear();                          // kperny trlse
            }
            homero_olv();                       // hmr rtk beolvassa
            homero_atlag = 0;                   // trljk a vtozt
            for(char i=0; i<16; i++){           // beolvasott rtkek
                homero_atlag += homero_1[i];    // sszeadsa
            }
            homero_atlag = homero_atlag >> 4;   // tlag szmols
            volt = homero_atlag * 2500;         // mV kiszmts
            volt /= 1024;
            fok = (volt - 500);                 // C kiszmols
            if(fok<0){
                neg=1;
                fok = -fok;
            }
            lcd_ertek(fok);                     // C kirsa lcd-re, egy tizedesig!
            delay_ms(1000);                     // vrunk egy kicsit
        }
        __disable_interrupt();
        szamlalo = 1;
        TACTL &= ~0xffff;
        ADC10CTL0 &= ~0xffff;
        P2OUT &= ~0xff;
        P1OUT &= ~TMP_shutdown;          // hszenzor ki
        P1OUT &= ~lcd_hv;                // lcd httrvilgts ki
        P1OUT |= lcd_be;                 // lcd trany be, (lcd ki)
        P1IE |= feny_erzek;              // fnyrzkel be
        P1IFG &= ~feny_erzek;            // flag trlse
        __low_power_mode_4();            // vezrl ki
    }       // while
}           // main

// ----------------------- ADC10 megszakts
#pragma vector=ADC10_VECTOR
__interrupt void ADC10_ISR (void){
  __low_power_mode_off_on_exit();        // breszt
}
// ----------------------- Port 1 megszakts
#pragma vector=PORT1_VECTOR
__interrupt void Port_1(void){
    delay_ms(260);
    while(P1IN & feny_erzek);
    P1OUT |= lcd_hv;                           // P1.6 lcd httrvilgts be
    P1IE &= ~feny_erzek;                       // P1.2 megszakts ki
    P1IFG &= ~feny_erzek;                      // P1.2 IFG trls
    
    __low_power_mode_off_on_exit();          // breszt a mly lombl
}
// ----------------------- Timer_1 megszakts
#pragma vector=TIMER0_A1_VECTOR
__interrupt void Timer(void){
    switch( TA0IV ){
        case  2: break;
        case  4: break;
        case 10: szamlalo++;        // tulcsorduls
        break;
    }
    if(szamlalo >= 200)
        szamlalo = 0;
}