// ---------------------- Nokia LCD hw SPI drive ---------------------------------------------------
// ---------------------------------------- Reset nlkl!!!!!! -------------------------------------
// ------- A reset lbat fel kell hzni 47k-val ----------------------------------------------------

#include "nok_hw_spi.h"
#include "font_5x7.h"

// ------------------- kezetes betk --------------------------------------------------------------
const unsigned char ekezet[90] = {
     0x78,0x14,0x12,0x14,0x7b,         // 
     0x7c,0x54,0x56,0x55,0x56,         //  
     0x00,0x44,0x7e,0x45,0x00,         // 
     0x38,0x45,0x44,0x45,0x38,         // 
     0x38,0x46,0x45,0x46,0x39,         // 
     0x38,0x44,0x46,0x45,0x38,         // 
     0x3c,0x42,0x40,0x42,0x3c,         // 
     0x3c,0x42,0x41,0x42,0x3d,         // 
     0x3c,0x40,0x42,0x41,0x3c,         // 
     0x20,0x54,0x56,0x55,0x78,         // 
     0x38,0x54,0x56,0x55,0x18,         // 
     0x00,0x00,0x7a,0x01,0x00,         // 
     0x30,0x4a,0x48,0x4a,0x30,         // 
     0x30,0x4a,0x49,0x4a,0x31,         // 
     0x30,0x48,0x4a,0x49,0x30,         // 
     0x38,0x42,0x40,0x42,0x38,         // 
     0x38,0x42,0x41,0x42,0x39,         // 
     0x38,0x40,0x42,0x41,0x38,         // 
};
// ------------------- lcd init --------------------------------------------------------------------
void lcd_init(void){
     
     chip_e_off;                 // chip enable lb alacsony
     __delay_cycles(1);
     chip_e_on;                  // chip enable lb magas
     __delay_cycles(1);
    
     lcd_write_byte (0x21, 0);    // 
     lcd_write_byte (0xbf, 0);    // kontraszt
     lcd_write_byte (0x06, 0);    // 
     lcd_write_byte (0x13, 0);    // 
     lcd_write_byte (0x20, 0);    // 
     lcd_write_byte (0x08, 0);    // 
     lcd_write_byte (0x0c, 0);    // lcd norml md
    
     lcd_clear ();                // kperny trls

     chip_e_off;                  // chip enable lb alacsony
}
// ------------------- lcd trls ------------------------------------------------------------------
void lcd_clear(void){
     
     unsigned int i;
     
     lcd_write_byte(0x0c, 0);
     lcd_write_byte(0x80, 0);
     
     for (i=0; i<504; i++)
          lcd_write_byte(0, 1);
}
// ------------------- lcd koordinta --------------------------------------------------------------
void lcd_set_XY(unsigned char X, unsigned char Y){
     lcd_write_byte(0x40 | Y, 0);		// column
     lcd_write_byte(0x80 | X, 0);          	// row
}
// ------------------- lcd karakter rs -----------------------------------------------------------
void lcd_write_char(unsigned char c){
     
     unsigned char line;
     
     c -= 32;
     
     for (line = 0; line < 5; line++)
          lcd_write_byte(font[c][line], 1);
     lcd_write_byte(0x00, 1);
}
// ------------------- lcd kezetek ----------------------------------------------------------------
void ek(char e){
     char i,ii=5*e;
     for(i=0;i<5;i++)
          lcd_write_byte(ekezet[ii+i],1);
     lcd_write_byte(0x00, 1);
}
// ------------------- lcd szveg rsa ------------------------------------------------------------
void lcd_print(unsigned char X,unsigned char Y,char *s){
     lcd_set_XY(X,Y);
     while(*s){
          char c;
          switch(*s){
               case '': c = 0; ek(c); break;
               case '': c = 1; ek(c); break;
               case '': c = 2; ek(c); break;
               case '': c = 3; ek(c); break;
               case '': c = 4; ek(c); break;
               case '': c = 5; ek(c); break;
               case '': c = 6; ek(c); break;
               case '': c = 7; ek(c); break;
               case '': c = 8; ek(c); break;
               case '': c = 9; ek(c); break;
               case '': c = 10; ek(c); break;
               case '': c = 11; ek(c); break;
               case '': c = 12; ek(c); break;
               case '': c = 13; ek(c); break;
               case '': c = 14; ek(c); break;
               case '': c = 15; ek(c); break;
               case '': c = 16; ek(c); break;
               case '': c = 17; ek(c); break;
               default:
                    lcd_write_char(*s); break;
          }
          s++;
     }
}
// ------------------- lcd kp/logo rs -----------------------------------------------------------
void lcd_write_logo(unsigned const char* ptr){
     unsigned int ctr = 0; 
     while(ctr++ < 504){
          lcd_write_byte(*ptr++,1);
     }
}
// ------------------- lcd byte rs ---------------------------------------------------------------
void lcd_write_byte(unsigned char dat, unsigned char command){
     
     chip_e_off;              // chip enable lb alacsony
     
     if (command == 0)
          mode_s_off;         // Mode select lb alacsony
     else
          mode_s_on;          // Mode select lb magas

     UCB0TXBUF = dat;
     while (!(IFG2 & UCB0TXIFG));
     
     chip_e_on;               // chip enable lb magas
}
// -------------------------------------------------------------------------------------------------
void hour_print(char x, char y, char sz){
     char ten, one;
     ten = (sz %100) /10;
     lcd_set_XY(x,y);
     for(char i=0;i<5;i++)
          lcd_write_byte(font[ten + 0x10][i],1);
     lcd_write_byte(0x00, 1);

     one = sz %10;
     lcd_set_XY(x+6, y);
     for(char i=0;i<5;i++)
          lcd_write_byte(font[one + 0x10][i],1);
     lcd_write_byte(0x00, 1);
}
