/* ------ Szitkovits Gbor - rs5c372a RTC + Nokia lcd --------------------------------------------*/

#include "io430.h"
#include "stdint.h"
#include "nok_hw_spi.h"
#include "d:\Msp430_and_all_Msp\Projektek\Modulok\delay_ms\delay_ms.h"
#include "d:\Msp430_and_all_Msp\Projektek\Modulok\rs5c372a\rs5c372a.h"

#define SCL BIT6
#define SDA BIT7
#define INTRA BIT5

extern uint8_t time_date[8];
uint8_t sec=0, min=0, hour=0, day=0, month=0, year=0;

void i2c_setup(void){
     UCB0CTL1 &= ~UCSWRST;                     // reset tilts
     UCB0CTL1 |= UCSWRST;                      // SW reset engedlyezs
     UCB0CTL0 = UCMST + UCMODE_3 + UCSYNC;     // I2C md kivlasztsa, I2C Master, szinkron md
     UCB0CTL1 = UCSSEL_2 + UCSWRST;            // SMCLK,  SW rezet
     UCB0BR0 = 2;                              // SMCLK/2 = 500kHz, I2C freki
     UCB0BR1 = 0;
     UCB0I2CSA = 0x32;                         // rs5c372a Slave cme
     UCB0CTL1 &= ~UCSWRST;                     // reset tilts
   //  IE2 |= UCB0RXIE;                        // rx megszakts engedlyezse most nem kell!!!!!!!!
}

void spi_setup(void){
     UCB0CTL1 &= ~UCSWRST;                             // reset tilts
     UCB0CTL1 |= UCSWRST;
     UCB0CTL0 = UCCKPH + UCMSB + UCMST + UCSYNC;       // SPI master, 8 bit
     UCB0CTL1 = UCSSEL_2;                              // SMCLK
     UCB0BR0 = 0x01;                                   // rajel 1:1
     UCB0BR1 = 0;
     UCB0CTL1 &= ~UCSWRST;                             //  SW reset
}

void main( void ){
     
     WDTCTL = WDTPW + WDTHOLD;         // Stop watchdog timer to prevent time out reset
     BCSCTL1 = CALBC1_1MHZ;                      // 1MHz clock
     DCOCTL = CALDCO_1MHZ;
     
     // ------ PIN init -------------------------
     
     P1DIR |= BIT0;                       // Led
     P1OUT &= ~BIT0;                      // led alacsony, vagy inkbb a kimenet alacsony, a led nem
     
     P2DIR &= ~INTRA;                     // INTRA = P2.5 bemenet
     P2IES |= INTRA;                      // felfut l
     P2IFG &= ~INTRA;                     // flag trlse
     
     P2SEL = 0;                           // P2sel nullzsa
     P2DIR |= 0x0f;                       // P2.2,3 digitlis kimenet (Nokia lcd)
     
     P1SEL |= LCD_SCL + SCL + SDA;        // P1.5 P1.6 P1.7 sel1
     P1SEL2 |= LCD_SCL + SCL + SDA;       // P1.5 P1.6 P1.7 sel2 (egyb hasznlat)
     
     /* RTC belltsa */
     i2c_setup();             // I2C bellts, slave cm=RTC
     delay_ms(20);
     control_1_reg(0x82);     // 2Hz-es impulzus, INTRA engedlyezs
     control_2_reg(0x24);     // 24 rs zemmd, CTFG bit peridikus megszakts engedlyezse
     set_time_date(0, 0, 12, 14, 9);           // id belltsa
     /* msodperc, perc, ra, nap, hnap a sorrend */
     
     /* LCD belltsa */
     spi_setup();             // SPI bellts (LCD)
          // LCD indts, kirs, meg miegyms......
     lcd_init();                         // LCD inicializls
     lcd_clear();                        // Kperny trls
     lcd_print(13,0,"MSP430G2553");
     lcd_print(18,1,"Nokia LCD");
     lcd_print(20,3,"SPI teszt");        // kirsa
     lcd_print(30,5,"Hell");
     delay_ms(3000);                     // teszt vrakozs 3mp, az rtc miatt !!!!!!
     lcd_clear();                        // Kperny trls
     
     P2IE |= INTRA;                      // RTC INTRA engedlyezse
     __low_power_mode_0();         // pihen, de csak egy kicsit !!!
     
     while(1){                           // Az soksos led ki-be
          P1OUT ^= BIT0;
          delay_ms(100);                 // ssze-vissza villog, 
          P1OUT ^= BIT0;                 // a kiolvass, s az lcd-re
          delay_ms(100);                 // rs miatt.
     }     // vgtelen ciklus vge
}          // main
// ----------------------- Port 2 megszakts ------------------------------------------------------
#pragma vector=PORT2_VECTOR
__interrupt void Port2_rtc_int(void){   // A megszaktst, az RTC generlja 2Hz-knt
     
     i2c_setup();               // I2C bellts RTC-hez
     time_date_read();          // RTC olvassa, adatok a "time_date" tblzatban !!!
          
     sec = (time_date[1] >> 4)*10 + (time_date[1] & 15);    // msodper, BCD -> DEC
     min = (time_date[2] >> 4)*10 + (time_date[2] & 15);    // perc, BCD -> DEC
     hour = (time_date[3] >> 4)*10 + (time_date[3] & 15);   // ra, BCD -> DEC
          
     day = (time_date[5] >> 4)*10 + (time_date[5] & 15);    // nap, BCD -> DEC
     month = (time_date[6] >> 4)*10 + (time_date[6] & 15);  // hnap, BCD -> DEC
     year = (time_date[7] >> 4)*10 + (time_date[7] & 15);   // v, BCD -> DEC
     
     spi_setup();                  // SPI bellts Nokia LCD-hez
     lcd_print(12, 0, "20");       // sor kezd
     hour_print(24, 0, year);      // +12
     lcd_print(36, 0, "-");        // +12
     hour_print(42, 0, month);     // +6
     lcd_print(54, 0, "-");        // +12
     hour_print(60, 0, day);       // +6
     
     switch(time_date[4]){                         // a ht napjai
     case 0: lcd_print(22, 2, "Vasrnap"); break;
     case 1: lcd_print(27, 2, "Htf"); break;
     case 2: lcd_print(29, 2, "Kedd");  break;
     case 3: lcd_print(25, 2, "Szerda"); break;
     case 4: lcd_print(20, 2, "Cstrtk"); break;
     case 5: lcd_print(25, 2, "Pntek"); break;
     case 6: lcd_print(23, 2, "Szombat"); break;
     }
     
     hour_print(20, 4, hour);      // kezd sor
     lcd_print(32, 4, ":");        // +12
     hour_print(37, 4, min);       // +5
     lcd_print(49, 4, ":");        // +12
     hour_print(54, 4, sec);       // +5

     P2IFG &= ~INTRA;                         // P2.5 IFG trls

     __low_power_mode_off_on_exit();          // breszt a mly lombl
}