/* ---------- Szitkovits Gbor RS5C372A RTC HW I2C driver - MSP430G2..3 --------------------------*/

#include "io430.h"
#include "stdint.h"
#include "d:\Msp430_and_all_Msp\Projektek\Modulok\delay_ms\delay_ms.h"
#include "d:\Msp430_and_all_Msp\Projektek\Modulok\rs5c372a\rs5c372a.h"

uint8_t time_date[8] = {0, 0, 0, 0, 0, 0, 0, 0}; 
     
// ------ Control 1 regiszter rsa ----------------------------------------------------------------
void control_1_reg(uint8_t reg){
     UCB0CTL1 |= UCTR + UCTXSTT;            // adat klds, i2c tx, plusz start
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     UCB0TXBUF = 0xe0;                      // control 1 regiszter cme
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     __delay_cycles(100);
     UCB0TXBUF = reg;                       // 24 rs m
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     __delay_cycles(100);
     UCB0CTL1 |= UCTXSTP;                   // I2C stop 
     while (UCB0CTL1 & UCTXSTP);            // Stop ksz?
}
// ------ Control 2 regiszter rsa ----------------------------------------------------------------
void control_2_reg(uint8_t reg){
     UCB0CTL1 |= UCTR + UCTXSTT;            // adat klds, i2c tx, plusz start
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     UCB0TXBUF = 0xf0;                      // control 2 regiszter cme
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     __delay_cycles(100);
     UCB0TXBUF = reg;                       // 24 rs m
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     __delay_cycles(100);
     UCB0CTL1 |= UCTXSTP;                   // I2C stop 
     while (UCB0CTL1 & UCTXSTP);            // Stop ksz?
}
// ------ id s dtum belltsa ------------------------------------------------------------------
void set_time_date(uint8_t set_sec, uint8_t set_min, uint8_t set_hour, uint8_t set_day, uint8_t set_month){
     
     time_date[1] = set_sec;     // msodperc
     time_date[2] = set_min;     // perc
     time_date[3] = set_hour;    // ra
     time_date[4] = 0x05;        // a ht napjai
     time_date[5] = set_day;     // nap
     time_date[6] = set_month;   // hnap
     time_date[7] = 0x12;        // v (2012)
     
     
     UCB0CTL1 |= UCTR + UCTXSTT;            // adat klds, i2c tx, plusz start
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     
     for(char i=0; i<8; i++){
          UCB0TXBUF = time_date[i];         // id s dtum belltsa
          while (!(IFG2 & UCNACKIFG));      // ACK-ra vr
          __delay_cycles(200);
     }  
     UCB0CTL1 |= UCTXSTP;                   // I2C stop 
     while (UCB0CTL1 & UCTXSTP);            // Stop ksz?
}
// ------ adat fogads -----------------------------------------------------------------------------
void time_date_read(void){
     UCB0CTL1 |= UCTR + UCTXSTT;            // adat klds, i2c tx, plusz start
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr     
     UCB0TXBUF = 0x00;                      // id cme
     while (!(IFG2 & UCNACKIFG));           // ACK-ra vr
     UCB0CTL1 &= ~UCTR;                     // I2C RX
     UCB0CTL1 |= UCTXSTT;                   // I2C restart !!!
     
     for(char i=0; i<8; i++){               // id dtum kiolvassa
          time_date[i] = UCB0RXBUF;         // id dtum mentse
          delay_ms(1);
     }
     UCB0CTL1 |= UCTXSTP;                   // I2C stop 
     while (UCB0CTL1 & UCTXSTP);            // Stop ksz?
}
