#include "hardware.inc"

#include "config.inc"

#include "utils.inc"

#include "eprtables.inc"
    extern  seltable
    extern  devtable
    extern  chrgen




#define     PAUSE   .300000


#define     RB_SIZE     .64
#define     RB_HIGH     .24
#define     RB_LOW      .16

#define     TB_SIZE     .64
#define     TB_HIGH     .24
#define     TB_LOW      .16

#define     LINE_SIZE   .80
#define     HB_SIZE     .32

#define     C_XOFF      'S'-.64
#define     C_XON       'Q'-.64
#define     C_SPACE     ' '
#define     C_CR        0x0D
#define     C_LF        0x0A
#define     C_BS        0x08

#define     PROMPT      '#'

#define     RX_HOLD     flags,0
#define     TX_HOLD     flags,1
#define     TX_XON      flags,2
#define     TX_XOFF     flags,3
#define     TESTMODE    flags,4
#define     VERIFY      flags,5
#define     VERROR      flags,6


    cblock  0
MSG_OK      
MSG_ERR     
MSG_SYNTAX  
MSG_ARG
MSG_STATE
MSG_NOTSUPP
MSG_DEVICE
MSG_METHOD
MSG_VPP
MSG_POWER
MSG_MODE
MSG_TESTMODE
MSG_WRITE
MSG_VERIFY
MSG_MODULE1
MSG_MODULE2
MSG_NONE
MSG_LISTHEADER
MSG_DEVNOTFND
MSG_INVDMOD
MSG_VERROR
MSG_OFFSET
    endc

    cblock  0
ST_POWEROFF
ST_STANDBY
ST_PREPROG
    endc



    udata
rxbuf       res     RB_SIZE
txbuf       res     TB_SIZE
linebuf     res     LINE_SIZE
hexbuf      res     HB_SIZE


    udata_acs
flags       res     1
tmp         res     1
htmp        res     1
ntmp        res     1
cnt         res     1
cntl        res     1
cnth        res     1

isr_w       res     1
isr_status  res     1
isr_bsr     res     1
isr_fsr0    res     2

lnrd        res     1
lnwr        res     1
token       res     1

rxrd        res     1
rxwr        res     1
rxnum       res     1

txrd        res     1
txwr        res     1
txnum       res     1

numl        res     1
numh        res     1
crcl        res     1
crch        res     1

adrl        res     1
adrh        res     1

hex_addrl   res     1
hex_addrh   res     1
hex_numb    res     1
hex_type    res     1
hex_crc     res     1


epr_device  res     1
epr_module  res     1
epr_vpp     res     1
epr_method  res     1
epr_state   res     1
epr_sadrl   res     1
epr_sadrh   res     1
epr_eadrl   res     1
epr_eadrh   res     1
epr_pulses  res     1
epr_errl    res     1
epr_errh    res     1
epr_offl    res     1
epr_offh    res     1


stblptrl    res     1
stblptrh    res     1
stblptru    res     1
sdev        res     1
smod        res     1
sopt        res     1
smet        res     1




resvec      code    0x0
    goto    start

intvec      code    0x8
    goto    isr

    code

start:
    ; set internal clock to 4MHz
    bsf     OSCCON,IRCF2
    bsf     OSCCON,IRCF1
    bcf     OSCCON,IRCF0

    clrf    flags


    ; init ports to digital
    MOVLW   0Fh
    MOVWF   ADCON1
    MOVWF   07h
    MOVWF   CMCON

    CLRF    LATA
    CLRF    LATB
    CLRF    LATC
    CLRF    LATD
    CLRF    LATE

    MOVLW   0FFh
    MOVWF   TRISA
    MOVWF   TRISB
    MOVWF   TRISC
    MOVWF   TRISD
    MOVLW   0Fh
    MOVWF   TRISE

    ; init USART
    movlw   .25
    movwf   SPBRG
    bsf     TXSTA,BRGH
    bsf     TXSTA,TXEN
    bcf     BAUDCON,BRG16
    ; inverted polarities on TX and RX
    bsf     BAUDCON,TXCKP
    bsf     BAUDCON,RXDTP
    ; enable transmit and receive
    bsf     RCSTA,SPEN
    bsf     RCSTA,CREN

    ; init receive buffer
    clrf    rxrd
    clrf    rxwr
    clrf    rxnum

    ; init transmit buffer
    clrf    txrd
    clrf    txwr
    clrf    txnum

    ; init serial interrupts
    bsf     INTCON,GIE
    bsf     INTCON,PEIE
    bcf     PIR1,TXIF
    bcf     PIR1,RCIF
    bsf     PIE1,TXIE
    bsf     PIE1,RCIE

    ; init line buffer
    clrf    lnwr
    clrf    lnrd

    ; init hardware
    bcf     ADRRST_TRIS
    bcf     ADRCLK_TRIS

    bcf     VCCEN
    bcf     VCCEN_TRIS

    bcf     VPPEN
    bcf     VPPEN_TRIS

    bcf     VPPVCC
    bcf     VPPVCC_TRIS

    bsf     VPPSEL1
    bsf     VPPSEL2
    bcf     VPPSEL1_TRIS
    bcf     VPPSEL2_TRIS

    bcf     OE
    bcf     OE_TRIS

    bcf     CE
    bcf     CE_TRIS

    bcf     A12
    bcf     A12_TRIS
    bcf     A13
    bcf     A13_TRIS
    bcf     A14
    bcf     A14_TRIS
    bcf     A15
    bcf     A15_TRIS

    setf    EDATA_TRIS


    bcf     LEDR_TRIS
    bcf     LEDY_TRIS
    bcf     LEDG_TRIS
    bsf     BTN1_TRIS

    ; module ID bits
    bsf     MID0_TRIS
    bsf     MID1_TRIS
    bsf     MID2_TRIS
    bsf     MID3_TRIS


    clrf    epr_device
    clrf    epr_module
    clrf    epr_offl
    clrf    epr_offh


    bcf     VPPVCC
    bsf     VPPSEL1
    bsf     VPPSEL2

    movlw   TOK_VPP_12V
    movwf   epr_vpp
    movlw   .100
    call    delay1ms

    movlw   TOK_MET_STANDARD
    movwf   epr_method

    call    state_poweroff

    movlw   MSG_OK
    call    sermsgout

    bsf     ADRRST
    bcf     ADRRST


lnloop:
    call    lineread

lnl1:
    call    chrgot
    bz      lnloop

    movlw   TBL_CMD
    call    findword
    bz      notoken

    call    docmd

    bra     lnloop

notoken:
    movlw   MSG_SYNTAX
    call    sermsgout
    bra     lnloop

;    call    chrgot
;    bz      lnloop
;    call    upcase
;    call    serout
;
;    incf    lnrd,f
;    bra     notoken


docmd:
    addlw   -1
    addwf   WREG,w
    addwf   WREG,w

    movwf   tmp
    movlw   high cmdjumps
    movwf   PCLATH
    movlw   upper cmdjumps
    movwf   PCLATU
    movlw   low cmdjumps
    addwf   tmp,f
    movlw   0
    addwfc  PCLATH,f
    addwfc  PCLATU,f
    movf    tmp,w
    movwf   PCL


lnlend:
    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout
    bra     lnloop




cmd_show:
    movlw   MSG_TESTMODE
    call    sermsgout

    movlw   TBL_OPT
    call    seltable
    movlw   TOK_OPT_ON ^ TOK_OPT_OFF
    movwf   tmp

    btfsc   TESTMODE
    clrf    tmp

    movlw   TOK_OPT_ON
    xorwf   tmp,w
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_DEVICE
    call    sermsgout
    movf    epr_device,w
    bnz     cs_dev

    movlw   MSG_NONE
    call    sermsgout
    bra     cs_vpp

cs_dev:
    movlw   TBL_DEV
    call    seltable
    movf    epr_device,w
    call    sertokout

cs_vpp:
    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_VPP
    call    sermsgout

    movlw   TBL_VPP
    call    seltable
    movf    epr_vpp,w
    call    sertokout

    movlw   ','
    call    serout
    movlw   ' '
    call    serout

    movlw   TBL_OPT
    call    seltable
    movlw   1
    btfss   VPPEN
    addlw   1
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_POWER
    call    sermsgout

    movlw   TBL_OPT
    call    seltable
    movlw   TOK_OPT_ON ^ TOK_OPT_OFF
    movwf   tmp

    movlw   ST_POWEROFF
    cpfseq  epr_state
    clrf    tmp

    movlw   TOK_OPT_ON
    xorwf   tmp,w
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_METHOD
    call    sermsgout

    movlw   TBL_MET
    call    seltable
    movf    epr_method,w
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_MODE
    call    sermsgout

    movlw   MSG_WRITE
    btfsc   VERIFY
    movlw   MSG_VERIFY
    call    sermsgout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_MODULE1
    call    sermsgout

    movf    epr_module,w
    call    serhexout

    movlw   ':'
    call    serout

    movlw   TBL_MOD
    call    seltable
    movf    epr_module,w
    addlw   1
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_MODULE2
    call    sermsgout

    call    getmodule
    call    serhexout

    movlw   ':'
    call    serout

    movlw   TBL_MOD
    call    seltable
    call    getmodule
    addlw   1
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movlw   MSG_OFFSET
    call    sermsgout

    movf    epr_offh,w
    call    serhexout
    movf    epr_offl,w
    call    serhexout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    return


cmd_prog:
    btfss   TESTMODE
    goto    err_syntax

    call    getnum
    movf    numl,w

    call    cmd_pjump

    movf    numh,w
    call    serhexout
    movf    numl,w
    call    serhexout

    return

cmd_pjump:
    bz      cmd_p0
    addlw   -.1
    bz      cmd_p1
    addlw   -.1
    bz      cmd_p2
    addlw   -.1
    bz      cmd_p3
    addlw   -.1
    bz      cmd_p4
    addlw   -.1
    bz      cmd_p5
    addlw   -.1
    bz      cmd_p6
    addlw   -.1
    bz      cmd_p7
    return

    ; full cycle
cmd_p0:
    call    cmd_p1
    call    cmd_p2
    call    cmd_p3
    call    cmd_p4
    call    cmd_p5
    call    cmd_p6
    call    cmd_p7
    return

    ; poweron
cmd_p1:
    call    state_poweron
    return

    ; programming standby
cmd_p2:
    call    state_preprog
    return

    ; program pulse start
cmd_p3:
    call    ewstart
    return

    ; program pulse end
cmd_p4:
    movlw   .20
    call    delay1ms
    call    ewend
    return

    ; program verify
cmd_p5:
    call    epr_verify
    call    serhexout
    return


    ; 5V standby mode
cmd_p6:
    call    state_poweron
    return

    ; poweroff
cmd_p7:
    call    state_poweroff
    return




cmd_hexline:
    call    getmodule
    xorwf   epr_module,w
    btfss   STATUS,Z
    goto    err_invdmodule

    call    gethexline
    bnc     hl_ok
    movlw   MSG_ERR
    call    sermsgout
    return

hl_ok:
;    movlw   .0
;    call    sermsgout
    call    state_preprog
    movff   hex_addrl,numl
    movff   hex_addrh,numh
    call    setaddr
    lfsr    FSR1,hexbuf

hl_cyc:
    movf    hex_numb,f
    bz      hl_done
    movf    INDF1,w

    btfss   VERIFY
    call    epr_write

    btfss   TESTMODE
    bra     hl_notest
    movf    epr_pulses,w
    call    serhexout

hl_notest:
    movf    POSTINC1,w
    movwf   tmp
    call    epr_verify
    xorwf   tmp,f

    movlw   '.'
    movf    tmp,f
    bz      hl_stchar

    btfsc   VERROR
    goto    hl_sterr

    bsf     VERROR
    movff   adrl,epr_errl
    movff   adrh,epr_errh

hl_sterr:
    movlw   '!'

hl_stchar:
    call    serout

    decf    hex_numb,f
    call    incaddr
    bra     hl_cyc

hl_done:
    call    state_poweron
    movf    hex_type,w
    xorlw   0x01
    bnz     hl_ret

    call    state_poweroff
    btfss   VERROR
    goto    hl_okret

    movlw   MSG_VERROR
    call    sermsgout
    movf    epr_errh,w
    call    serhexout
    movf    epr_errl,w
    call    serhexout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    bcf     VERROR

hl_ret:
    return

hl_okret:
    movlw   MSG_OK
    call    sermsgout
    return


gethexline:
    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   hex_numb
    movwf   cnt
    movwf   hex_crc
    sublw   HB_SIZE
    bnc     hl_err

    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   hex_addrh
    addwf   hex_crc,f

    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   hex_addrl
    addwf   hex_crc,f

    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   hex_type
    addwf   hex_crc,f

    lfsr    FSR1,hexbuf

hl_next:
    movf    cnt,f
    bz      hl_end

    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   POSTINC1
    addwf   hex_crc,f

    decf    cnt,f
    bra     hl_next

hl_end:
    call    gethexbyte
    btfsc   STATUS,C
    return
    movwf   POSTINC1
    addwf   hex_crc,f
    bcf     STATUS,C
    btfsc   STATUS,Z
    return

hl_err:
    bsf     STATUS,C
    return


gethexbyte:
    call    getnibble
    bnz     gh_err
    movwf   tmp
    swapf   tmp,f

    incf    lnrd,f
    call    getnibble
    bnz     gh_err
    iorwf   tmp,f

    incf    lnrd,f
    bcf     STATUS,C
    movf    tmp,w
    return

gh_err:
    bsf     STATUS,C
    return


cmd_setaddr:
    btfss   TESTMODE
    goto    err_syntax

    call    chrgot
    xorlw   '+'
    bz      incaddr

    call    getnum

setaddr:
    bsf     ADRRST
    bcf     ADRRST

    movf    epr_offl,w
    addwf   numl,f
    movf    epr_offh,w
    addwfc  numh,f

    movff   numl,adrl
    movff   numh,adrh

    movlw   b'00001111'
    andwf   numh,f

sa_cyc:
    movf    numl,w
    iorwf   numh,w
    bz      sa_highbits

    bsf     ADRCLK
    bcf     ADRCLK
    decf    numl,f
    btfss   STATUS,C
    decf    numh,f
    bra     sa_cyc

sa_highbits:
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      sa_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      sa_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      sa_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      sa_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      sa_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      sa_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      sa_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      sa_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      sa_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      sa_28256

    return
sa_27256:
sa_27512:
    bcf     A14
    bcf     A15
    btfsc   adrh,6
    bsf     A14
    btfsc   adrh,7
    bsf     A15
sa_2764:
sa_27128:
    bcf     A12
    bcf     A13
    btfsc   adrh,4
    bsf     A12
    btfsc   adrh,5
    bsf     A13
sa_2716:
sa_2732:
    return
sa_28256:
sa_2864:
    bcf     EE_A12
    bcf     EE_A13
    bcf     EE_A14
    btfsc   adrh,4
    bsf     EE_A12
    btfsc   adrh,5
    bsf     EE_A13
    btfsc   adrh,6
    bsf     EE_A14
    return
sa_2532:
sa_2564:
    bcf     E25_A11
    bcf     E25_A12
    btfsc   adrh,3
    bsf     E25_A11
    btfsc   adrh,4
    bsf     E25_A12
    return

incaddr:
    bsf     ADRCLK
    bcf     ADRCLK
    incf    adrl,f
    btfsc   STATUS,C
    incf    adrh,f
    movf    adrh,w
    andlw   b'00000111'
    iorwf   adrl,w
    bz      sa_highbits
    return



cmd_setvpp:
    movlw   TBL_VPP
    call    findword
    bnz     setvpp

    btfss   TESTMODE
    goto    err_syntax

    movlw   TBL_OPT
    call    findword
    bz      setvpp_notok

    xorlw   TOK_OPT_ON
    bz      setvpp_on

    xorlw   TOK_OPT_ON ^ TOK_OPT_OFF
    bz      setvpp_off
    bra     setvpp_notok

setvpp:
    movwf   tmp
    xorlw   TOK_VPP_12V
    bz      setvpp_12V

    xorlw   TOK_VPP_12V ^ TOK_VPP_21V
    bz      setvpp_21V

    xorlw   TOK_VPP_21V ^ TOK_VPP_25V
    bz      setvpp_25V

setvpp_notok:
    goto    err_arg

setvpp_on:
    bsf     VPPEN
    return

setvpp_off:
    bcf     VPPEN
    return

setvpp_12V:
    bsf     VPPSEL1
    bsf     VPPSEL2
    bsf     VPPVCC
    bra     setvpp_end

setvpp_21V:
    bsf     VPPSEL1
    bcf     VPPSEL2
    bsf     VPPVCC
    bra     setvpp_end

setvpp_25V:
    bcf     VPPSEL1
    bcf     VPPSEL2
    bsf     VPPVCC
    bra     setvpp_end

setvpp_end:
    movff   tmp,epr_vpp
    movlw   .10
    call    delay1ms
    return


cmd_test:
    movlw   TBL_OPT
    call    findword
    bz      test_notok

    xorlw   TOK_OPT_ON
    bz      test_on

    xorlw   TOK_OPT_ON ^ TOK_OPT_OFF
    bz      test_off

    goto    err_arg

test_on:
    bsf     TESTMODE
    return

test_off:
    bcf     TESTMODE
    return

test_notok:
    goto    err_syntax


cmd_device:
    movlw   TBL_DEV
    call    findword
    btfsc   STATUS,Z
    goto    err_arg

    movwf   epr_device
    call    state_poweroff
    return


cmd_power:
    btfss   TESTMODE
    goto    err_syntax

    movlw   TBL_OPT
    call    findword
    btfsc   STATUS,Z
    goto    err_arg

    xorlw   TOK_OPT_ON
    bz      power_on

    xorlw   TOK_OPT_ON ^ TOK_OPT_OFF
    bz      power_off

    goto    err_arg

power_on:
    call    state_poweron
    return

power_off:
    call    state_poweroff
    return


cmd_read:
    bcf     VERROR

    call    getmodule
    xorwf   epr_module,w
    btfss   STATUS,Z
    goto    err_invdmodule

    movlw   ST_STANDBY
    xorwf   epr_state,w
    bz      cr_ok

    call    state_poweron

cr_ok:
    call    dev_params

    call    getnibble
    bnz     cr_nostart
    call    getnum
    movff   numl,epr_sadrl
    movff   numh,epr_sadrh

cr_nostart:
    call    chrgot
    xorlw   ','
    bnz     cr_noend

    call    chrget
    call    getnum
    movf    numl,w
    addwf   epr_offl,w
    movwf   epr_eadrl
    movf    numh,w
    addwfc  epr_offh,w
    movwf   epr_eadrh

cr_noend:
    movff   epr_sadrl,numl
    movff   epr_sadrh,numh
    call    setaddr

    clrf    hex_type

cr_nextline:
    lfsr    FSR1,hexbuf
    clrf    hex_crc
    clrf    hex_numb

    movff   adrl,numl
    movff   adrh,numh

cr_cyc:
    call    epr_read
    movwf   POSTINC1
    incf    hex_numb,f

    movf    adrl,w
    xorwf   epr_eadrl,w
    movwf   tmp
    movf    adrh,w
    xorwf   epr_eadrh,w
    iorwf   tmp,w
    bz      cr_last

    call    incaddr
    movf    hex_numb,w
    xorlw   0x10
    bnz     cr_cyc
    call    cr_hexline
    bra     cr_nextline

cr_last:
    call    cr_hexline
    clrf    hex_numb
    clrf    numl
    clrf    numh
    movlw   1
    movwf   hex_type
    call    cr_hexline

    call    state_poweroff
    return


cr_hexline:
    movlw   ':'
    call    serout
    movf    hex_numb,w
    call    serhexout
    movf    numh,w
    call    serhexout
    movf    numl,w
    call    serhexout
    movf    hex_type,w
    call    serhexout

    lfsr    FSR1,hexbuf
cr_hl_cyc:
    movf    hex_numb,f
    bz      cr_hl_end
    movf    POSTINC1,w
    call    serhexout
    decf    hex_numb,f
    bra     cr_hl_cyc

cr_hl_end:
    comf    hex_crc,w
    addlw   1
    call    serhexout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    return

dev_params:
    clrf    epr_sadrl
    clrf    epr_sadrh
    setf    epr_eadrl
    setf    epr_eadrh

    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      dp_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      dp_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      dp_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      dp_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      dp_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      dp_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      dp_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      dp_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      dp_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      dp_28256
    movlw   0xFF
    bra     dp_pars

dp_2716:
    movlw   0x07
    bra     dp_pars
dp_2532:
dp_2732:
    movlw   0x0F
    bra     dp_pars
dp_2564:
dp_2764:
dp_2864:
    movlw   0x1F
    bra     dp_pars
dp_27128:
    movlw   0x3F
    bra     dp_pars
dp_27256:
dp_28256:
    movlw   0x7F
    bra     dp_pars
dp_27512:
    movlw   0xFF
    bra     dp_pars
dp_pars:
    movwf   epr_eadrh
    return


cmd_check:
    bcf     VERROR

    call    getmodule
    xorwf   epr_module,w
    btfss   STATUS,Z
    goto    err_invdmodule

    movlw   ST_STANDBY
    xorwf   epr_state,w
    bz      cc_ok

    call    state_poweron

cc_ok:
    call    dev_params
    movff   epr_sadrl,numl
    movff   epr_sadrh,numh
    call    setaddr

cc_cyc:
    call    epr_read
    addlw   1
    bnz     cc_err

    movf    adrl,w
    xorwf   epr_eadrl,w
    movwf   tmp
    movf    adrh,w
    xorwf   epr_eadrh,w
    iorwf   tmp,w
    bz      cc_last

    call    incaddr
    bra     cc_cyc

cc_err:
    movlw   MSG_ERR
    call    sermsgout
    movf    adrh,w
    call    serhexout
    movf    adrl,w
    call    serhexout
    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

cc_last:
    call    state_poweroff
    return


cmd_method:
    movlw   TBL_MET
    call    findword
    btfsc   STATUS,Z
    goto    err_arg

    movwf   epr_method
    return


cmd_write:
    bcf     VERIFY
    return


cmd_verify:
    bsf     VERIFY
    return


cmd_erase:
    bcf     VERROR

    call    getmodule
    xorwf   epr_module,w
    btfss   STATUS,Z
    goto    err_invdmodule

    movf    epr_device,w
    xorlw   TOK_DEV_2864
    bz      ce_erase
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      ce_erase

    movlw   MSG_NOTSUPP
    call    sermsgout
    return

ce_erase:
    call    state_poweron

    bsf     VPPVCC
    bcf     CE
    movlw   1
    call    delay100us

    bcf     EE_WR
    movlw   .20
    call    delay1ms
    bsf     EE_WR

    movlw   1
    call    delay100us

    bsf     CE
    bcf     VPPVCC
    movlw   1
    call    delay100us

    call    state_poweroff
    return


cmd_list:
    movlw   MSG_LISTHEADER
    call    sermsgout

    ltblptr devtable

cl_cyc:
    tblrd   *
    movf    TABLAT,w
    bz      cl_end

cl_name:
    tblrd   *+
    movf    TABLAT,w
    bz      cl_next
    call    serout
    bra     cl_name

cl_next:
    tblrd   *+
    movff   TABLAT,sdev
    tblrd   *+
    movff   TABLAT,smod
    tblrd   *+
    movff   TABLAT,sopt
    tblrd   *+
    movff   TABLAT,smet
    movff   TBLPTRL,stblptrl
    movff   TBLPTRH,stblptrh
    movff   TBLPTRU,stblptru

    movlw   '\t'
    call    serout

    movlw   TBL_DEV
    call    seltable
    movf    sdev,w
    call    sertokout

    movlw   '\t'
    call    serout

    movf    smod,w
    call    serhexout

    movlw   '\t'
    call    serout

    movlw   TBL_VPP
    call    seltable
    movf    sopt,w
    call    sertokout

    movlw   '\t'
    call    serout

    movlw   TBL_MET
    call    seltable
    movf    smet,w
    call    sertokout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    movff   stblptrl,TBLPTRL
    movff   stblptrh,TBLPTRH
    movff   stblptru,TBLPTRU
    bra     cl_cyc

cl_end:
    return


cmd_select:
    bcf     VERROR

    call    chrgot
    ltblptr devtable

cs_restart:
    lfsr    FSR0,linebuf
    movf    lnrd,w
    addwf   FSR0L,f
    tblrd   *
    movf    TABLAT,w
    bz      cs_notfound     ; not found

cs_next:
    tblrd   *+
    movf    TABLAT,w
    bz      cs_found

    movf    POSTINC0,w
    call    upcase
    xorwf   TABLAT,w
    bz      cs_next

cs_nextword:
    tblrd   *+
    movf    TABLAT,w
    bnz     cs_nextword

cs_skip:
    tblrd   *+
    tblrd   *+
    tblrd   *+
    tblrd   *+
    bra     cs_restart

cs_found:
    movf    POSTINC0,w
    bnz     cs_skip
    ; found entry

    tblrd   *+
    movff   TABLAT,epr_device
    tblrd   *+
    movff   TABLAT,epr_module
    tblrd   *+
    movff   TABLAT,epr_vpp
    tblrd   *+
    movff   TABLAT,epr_method

    return

cs_notfound:
    movlw   MSG_DEVNOTFND
    call    sermsgout
    return


cmd_help:
    movlw   TBL_CMD
    call    seltable

ch_cyc:
    tblrd   *
    movf    TABLAT,w
    bz      ch_end
    call    serstrout

    movlw   '\t'
    call    serout
    bra     ch_cyc

ch_end:
    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout
    return


cmd_offset:
    clrf    epr_offl
    clrf    epr_offh

    call    getnibble
    bnz     co_nostart
    call    getnum
    movff   numl,epr_offl
    movff   numh,epr_offh

co_nostart:
    return


cmd_chksum:
    bcf     VERROR

    call    getmodule
    xorwf   epr_module,w
    btfss   STATUS,Z
    goto    err_invdmodule

    movlw   ST_STANDBY
    xorwf   epr_state,w
    bz      cch_ok

    call    state_poweron

cch_ok:
    call    dev_params

    call    getnibble
    bnz     cch_nostart
    call    getnum
    movff   numl,epr_sadrl
    movff   numh,epr_sadrh

cch_nostart:
    call    chrgot
    xorlw   ','
    bnz     cch_noend

    call    chrget
    call    getnum
    movf    numl,w
    addwf   epr_offl,w
    movwf   epr_eadrl
    movf    numh,w
    addwfc  epr_offh,w
    movwf   epr_eadrh

cch_noend:
    movff   epr_sadrl,numl
    movff   epr_sadrh,numh
    call    setaddr

    clrf    numl
    clrf    numh
    clrf    crcl
    clrf    crch

cch_cyc:
    call    epr_read
    movwf   tmp
    addwf   numl,f
    movlw   0
    addwfc  numh,f

    movf    tmp,w
    subwf   crcl,f
    movlw   0
    subwfb  crch,f

    movf    adrl,w
    xorwf   epr_eadrl,w
    movwf   tmp
    movf    adrh,w
    xorwf   epr_eadrh,w
    iorwf   tmp,w
    bz      cch_last

    call    incaddr
    bra     cch_cyc

cch_last:
    movf    numh,w
    call    serhexout
    movf    numl,w
    call    serhexout

    movlw   '\t'
    call    serout

    movf    crch,w
    call    serhexout
    movf    crcl,w
    call    serhexout

    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout

    call    state_poweroff
    return






; eprom handling routines

;normal read
epr_read:
    setf    EDATA_OUT
    setf    EDATA_TRIS
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      er_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      er_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      er_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      er_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      er_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      er_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      er_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      er_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      er_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      er_28256

    movlw   0xFF
    return

er_2532:
    bcf     E25_PGM
    nop
    nop
    nop
    nop
    nop
    movf    EDATA_IN,w
    bsf     E25_PGM
    nop
    nop
    nop
    nop
    nop
    return
er_2564:
    bcf     E25_CS1
    bcf     E25_CS2
    bcf     E25_PGM
    nop
    nop
    nop
    nop
    nop
    movf    EDATA_IN,w
    bsf     E25_PGM
    bsf     E25_CS1
    bsf     E25_CS2
    nop
    nop
    nop
    nop
    nop
    return
er_2732:
    bcf     CE
    bcf     VPPEN
    nop
    nop
    nop
    nop
    nop
    movf    EDATA_IN,w
    bsf     VPPEN
    nop
    nop
    nop
    nop
    nop
    bsf     CE
    return
er_2716:
er_2764:
er_27128:
er_27256:
    bcf     CE
    bcf     OE
    nop
    movf    EDATA_IN,w
    bsf     OE
    bsf     CE
    return
er_27512:
    bcf     CE
    bcf     VPPEN
    nop
    nop
    nop
    nop
    nop
    movf    EDATA_IN,w
    bsf     VPPEN
    nop
    nop
    nop
    nop
    nop
    bsf     CE
    return
er_2864:
er_28256:
    bcf     VPPEN
    nop
    nop
    nop
    nop
    nop
    bcf     CE
    nop
    movf    EDATA_IN,w
    bsf     CE
    bsf     VPPEN
    nop
    nop
    nop
    nop
    nop
    return


; read when programming
epr_verify:
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      ev_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      ev_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      ev_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      ev_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      ev_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      ev_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      ev_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      ev_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      ev_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      ev_28256

    movlw   0xFF
    return

ev_2532:
ev_2564:
    bcf     VPPVCC
    bcf     VPPEN
    nop
    nop
    bsf     VPPEN
    nop
    nop
    nop
    bcf     E25_PGM
    nop
    movf    EDATA_IN,w
    bsf     E25_PGM
    nop
    bsf     VPPVCC
    nop
    nop
    nop
    nop
    nop
    return
ev_2732:
ev_27512:
    bcf     VPPEN
    nop
    nop
    nop
    nop
    nop
    bcf     CE
    nop
    movf    EDATA_IN,w
    bsf     CE
    nop
    bsf     VPPEN
    nop
    nop
    nop
    nop
    nop
    return
ev_2716:
ev_2764:
ev_27128:
ev_27256:
    bcf     OE
    nop
    movf    EDATA_IN,w
    bsf     OE
    return
ev_2864:
ev_28256:
    bcf     VPPEN
    nop
    nop
    nop
    nop
    nop
    bcf     CE
    nop
    movf    EDATA_IN,w
    bsf     CE
    bsf     VPPEN
    nop
    nop
    nop
    nop
    nop
    return


epr_write:
    movwf   tmp
    movf    epr_method,w
    xorlw   TOK_MET_STANDARD
    bz      ew_standard
    xorlw   TOK_MET_STANDARD ^ TOK_MET_FAST
    bz      ew_fast
    xorlw   TOK_MET_FAST ^ TOK_MET_QUICK
    bz      ew_quick
    xorlw   TOK_MET_QUICK ^ TOK_MET_EEPROM
    bz      ew_eeprom
    xorlw   TOK_MET_EEPROM ^ TOK_MET_EEFAST
    bz      ew_eefast
    return


ew_standard:
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    call    ewstart
    movlw   .45
    call    delay1ms
    call    ewend
    setf    EDATA_TRIS
    return


ew_fast:
    clrf    epr_pulses

ewf_cyc:
    movf    epr_pulses,w
    xorlw   .25
    bz      ewf_end

    incf    epr_pulses,f
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    nop
    nop
    nop
    nop
    nop
    call    ewstart
    movlw   .1
    call    delay1ms
    call    ewend
    setf    EDATA_OUT
    setf    EDATA_TRIS
    nop
    nop
    nop
    nop
    nop
    call    epr_verify
    xorwf   tmp,w
    bnz     ewf_cyc

ewf_end:
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    nop
    nop
    nop
    nop
    nop
    call    ewstart

    movf    epr_pulses,w
    addwf   epr_pulses,w
    addwf   epr_pulses,w
    call    delay1ms
    call    ewend
    setf    EDATA_OUT
    setf    EDATA_TRIS
    nop
    nop
    nop
    nop
    nop

    return


ew_quick:
    clrf    epr_pulses

ewq_cyc:
    movf    epr_pulses,w
    xorlw   .25
    bz      ewq_end

    incf    epr_pulses,f
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    nop
    nop
    nop
    nop
    nop
    call    ewstart
    movlw   .1
    call    delay100us
    call    ewend
    setf    EDATA_OUT
    setf    EDATA_TRIS
    nop
    nop
    nop
    nop
    nop
    call    epr_verify
    xorwf   tmp,w
    bnz     ewq_cyc

ewq_end:
    return


ew_eeprom:
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    call    ewstart
    movlw   .1
    call    delay100us
    call    ewend
    setf    EDATA_TRIS

    movlw   .10
    call    delay1ms
    return


ew_eefast:
    movf    tmp,w
    clrf    EDATA_TRIS
    movwf   EDATA_OUT
    call    ewstart
    movlw   .1
    call    delay100us
    call    ewend
    setf    EDATA_TRIS

    clrf    epr_pulses

ewef_cyc:
    movf    epr_pulses,w
    xorlw   .100
    bz      ewef_end

    incf    epr_pulses,f
    movf    tmp,w

    movlw   .1
    call    delay100us

    call    epr_verify
    xorwf   tmp,w

    bnz     ewef_cyc

ewef_end:
    return


ewstart:
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      ews_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      ews_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      ews_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      ews_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      ews_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      ews_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      ews_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      ews_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      ews_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      ews_28256

ews_2532:
    bcf     E25_PGM
    return
ews_2564:
    bcf     E25_PGM
    return
ews_2716:
    bsf     CE
    return
ews_2732:
    bcf     CE
    return
ews_2764:
    bcf     EPGM
    return
ews_27128:
    bcf     EPGM
    return
ews_27256:
    bcf     CE
    return
ews_27512:
    bcf     CE
    return
ews_2864:
ews_28256:
    bcf     CE
    bcf     EE_WR
    return

ewend:
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      ewe_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      ewe_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      ewe_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      ewe_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      ewe_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      ewe_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      ewe_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      ewe_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      ewe_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      ewe_28256

ewe_2532:
    bsf     E25_PGM
    return
ewe_2564:
    bsf     E25_PGM
    return
ewe_2716:
    bcf     CE
    return
ewe_2732:
    bsf     CE
    return
ewe_2764:
    bsf     EPGM
    return
ewe_27128:
    bsf     EPGM
    return
ewe_27256:
    bsf     CE
    return
ewe_27512:
    bsf     CE
    return
ewe_2864:
ewe_28256:
    bsf     EE_WR
    bsf     CE
    return






; hardware state settings

state_poweron:
    bcf     VPPVCC
    nop
    nop
    nop
    nop
    nop

    bcf     LEDR
    setf    EDATA_TRIS

    bsf     VCCEN

    bsf     CE
    bsf     OE
    bsf     EPGM
    bsf     EE_WR

    bsf     VPPEN

    movlw   ST_STANDBY
    movwf   epr_state

    movlw   .10
    call    delay1ms

    bsf     LEDY
    bcf     LEDG

    return


state_poweroff:
    bcf     VPPEN
    movlw   1
    call    delay100us

    setf    EDATA_TRIS
    bcf     OE
    bcf     CE

    bcf     RDY_TRIS
    movf    epr_device,w
    xorlw   TOK_DEV_2864
    btfsc   STATUS,Z
    bsf     RDY_TRIS

    bsf     ADRRST
    bcf     ADRRST

    clrf   adrl
    clrf   adrh

    bcf     A12
    bcf     A13
    bcf     A14
    bcf     A15

    bcf     VCCEN

    movlw   ST_POWEROFF
    movwf   epr_state

    movlw   .10
    call    delay1ms

    bcf     LEDY
    bsf     LEDG

    return


state_preprog:
    movlw   ST_STANDBY
    xorwf   epr_state,w
    bz      spp_ok

    call    state_poweron

spp_ok:
    movf    epr_device,w
    xorlw   TOK_DEV_2532
    bz      spp_2532
    xorlw   TOK_DEV_2532 ^ TOK_DEV_2564
    bz      spp_2564
    xorlw   TOK_DEV_2564 ^ TOK_DEV_2716
    bz      spp_2716
    xorlw   TOK_DEV_2716 ^ TOK_DEV_2732
    bz      spp_2732
    xorlw   TOK_DEV_2732 ^ TOK_DEV_2764
    bz      spp_2764
    xorlw   TOK_DEV_2764 ^ TOK_DEV_27128
    bz      spp_27128
    xorlw   TOK_DEV_27128 ^ TOK_DEV_27256
    bz      spp_27256
    xorlw   TOK_DEV_27256 ^ TOK_DEV_27512
    bz      spp_27512
    xorlw   TOK_DEV_27512 ^ TOK_DEV_2864
    bz      spp_2864
    xorlw   TOK_DEV_2864 ^ TOK_DEV_28256
    bz      spp_28256
    goto    spp_end

spp_2716:
    bcf     CE
    nop
    nop
    nop
    nop
    nop
    bra     spp_end
spp_2564:
    bsf     E25_PGM
    bcf     E25_CS1
    bcf     E25_CS2
spp_2532:
spp_2732:
    bra     spp_end
spp_2764:
    bcf     CE
    nop
    nop
    nop
    nop
    nop
    bra     spp_end
spp_27128:
    bcf     CE
    nop
    nop
    nop
    nop
    nop
    bra     spp_end
spp_27256:
    bra     spp_end
spp_27512:
    bra     spp_end
spp_2864:
spp_28256:
    bra     spp_endvcc

spp_end:
    bsf     VPPVCC
    nop
    nop
    nop
    nop
    nop

spp_endvcc:
    movlw   ST_PREPROG
    movwf   epr_state

    bsf     LEDR

    return








getmodule:
    movlw   .0
    btfss   MID0
    iorlw   .1
    btfss   MID1
    iorlw   .2
    btfss   MID2
    iorlw   .4
    btfss   MID3
    iorlw   .8
    return


err_syntax:
    movlw   MSG_SYNTAX
    bra     errout
err_arg:
    movlw   MSG_ARG
    bra     errout
err_state:
    movlw   MSG_STATE
    bra     errout
err_invdmodule:
    movlw   MSG_INVDMOD
    bra     errout
errout:
    call    sermsgout
    return



lineread:
    clrf    lnrd
    clrf    lnwr
    movlw   PROMPT
    call    serout

lr0:
    call    serin
    movwf   tmp
    xorlw   C_CR
    bz      lr_cr
    xorlw   C_CR ^ C_BS
    bz      lr_bs

    movlw   0x1F
    cpfsgt  tmp
    bra     lr0
    movlw   0x80
    cpfslt  tmp
    bra     lr0

    movlw   LINE_SIZE-1
    cpfslt  lnwr
    bra     lr0

    lfsr    FSR0,linebuf
    movf    lnwr,w
    addwf   FSR0L,f
    movf    tmp,w
    movwf   INDF0
    call    serout
    incf    lnwr,f
    bra     lr0

lr_bs:
    movf    lnwr,f
    bz      lr0
    decf    lnwr,f
    movlw   C_BS
    call    serout
    movlw   C_SPACE
    call    serout
    movlw   C_BS
    call    serout
    bra     lr0

lr_cr:
    lfsr    FSR0,linebuf
    movf    lnwr,w
    addwf   FSR0L,f
    movlw   0
    movwf   INDF0
    movlw   C_CR
    call    serout
    movlw   C_LF
    call    serout
    return


upcase:
    addlw   0xFF - 'z'      ; Get the High limit
    addlw   'z' - 'a' + 1   ; Add Lower Limit to Set Carry
    btfss   STATUS, C       ; If Carry Set, then Lower Case
    addlw   'a'-'A'         ; Carry NOT Set, Restore Character
    addlw   'A'             ; Add 'A' to restore the Character
    return


getnum:
    clrf    numl
    clrf    numh

gn_next:
    call    getnibble
    btfss   STATUS,Z
    return

    movwf   tmp
    swapf   numh,w
    andlw   b'11110000'
    movwf   numh
    swapf   numl,w
    andlw   b'00001111'
    iorwf   numh,f
    swapf   numl,w
    andlw   b'11110000'
    iorwf   tmp,w
    movwf   numl

    incf    lnrd,f
    bra     gn_next


getnibble:
    call    chrgot
    call    upcase
    addlw   -'A'
    btfss   STATUS,C
    addlw   'A'-'0' - .10
    addlw   .10
    movwf   ntmp
    andlw   b'11110000'
    movff   ntmp,WREG
    return


chrget:
    incf    lnrd,f
chrgot:
    lfsr    FSR0,linebuf
    movf    lnrd,w
    addwf   FSR0L,f
    movf    INDF0,w
    btfsc   STATUS,Z
    return

    xorlw   C_SPACE
    bz      chrget
    xorlw   C_SPACE
    return


findword:
    call    seltable
    call    chrgot
    clrf    token

fw_restart:
    incf    token,f
    lfsr    FSR0,linebuf
    movf    lnrd,w
    addwf   FSR0L,f
    tblrd   *
    movf    TABLAT,w
    btfsc   STATUS,Z
    return              ; not found

fw_next:
    tblrd   *+
    movf    TABLAT,w
    bz      fw_found

    movf    POSTINC0,w
    call    upcase
    xorwf   TABLAT,w
    bz      fw_next

fw_nextword:
    tblrd   *+
    movf    TABLAT,w
    bnz     fw_nextword
    bra     fw_restart

fw_found:
    movlw   low linebuf
    subwf   FSR0L,w
    movwf   lnrd
    movf    token,w
    return


serout:
    movwf   tmp
serout_w:
    movf    txnum,w
    xorlw   TB_SIZE
    bz      serout_w

    lfsr    FSR0,txbuf
    movf    txwr,w
    addwf   FSR0L,f

    movff   tmp,INDF0

    ; cyclic increment write pointer
    incf    txwr,f
    movlw   TB_SIZE
    xorwf   txwr,w
    btfsc   STATUS,Z
    clrf    txwr

    incf    txnum,f
    bsf     PIE1,TXIE
    return


serin:
    btfss   RX_HOLD
    bra     serin_w

    movf    rxnum,w
    xorlw   RB_LOW
    bnz     serin_w

    bsf     TX_XON
    bsf     PIR1,TXIE

    bcf     RX_HOLD

serin_w:
    movf    rxnum,f
    bz      serin_w

serin_rd:
    bcf     INTCON,GIE

    lfsr    FSR0,rxbuf
    movf    rxrd,w
    addwf   FSR0L,f

    ; cyclic increment read pointer
    incf    rxrd,f
    movlw   RB_SIZE
    xorwf   rxrd,w
    btfsc   STATUS,Z
    clrf    rxrd

    movf    INDF0,w
    decf    rxnum,f

    bsf     INTCON,GIE
    return


sertokout:
    movwf   cnt
    decf    cnt,f
    bra     smf

sermsgout:
    movwf   cnt
    movlw   low messages
    movwf   TBLPTRL
    movlw   high messages
    movwf   TBLPTRH
    movlw   upper messages
    movwf   TBLPTRU

smf:
    tblrd   *
    movf    TABLAT,f
    bz      sm_notfound

    movf    cnt,f
    bz      sm_found

    decf    cnt,f
smc:
    tblrd   *+
    movf    TABLAT,f
    bnz     smc
    bra     smf

sm_notfound:
    tblrd   *+

serstrout:
sm_found:
    tblrd   *+
    movf    TABLAT,w
    btfsc   STATUS,Z
    return

    call    serout
    bra     sm_found


serhexout:
    addwf   hex_crc,f
    movwf   htmp
    swapf   htmp,w
    call    pnib
    movf    htmp,w

pnib:
    andlw   0x0f
    addlw   -.10
    btfsc   STATUS,C
    addlw   'A'-'9'-1
    addlw   '9'+1
    goto    serout


isr:
    movff   STATUS,isr_status
    movwf   isr_w
    movff   BSR,isr_bsr
    movff   FSR0L,isr_fsr0+0
    movff   FSR0H,isr_fsr0+1

    btfss   PIR1,TXIF
    bra     isr_tx_end

    ; transmit char
    btfsc   TX_XON
    bra     isr_tx_xon
    btfsc   TX_XOFF
    bra     isr_tx_xoff

    btfsc   TX_HOLD
    bra     isr_tx_hold

    movf    txnum,f
    bnz     isr_tx

isr_tx_hold:
    bcf     PIE1,TXIE
    bra     isr_tx_end

isr_tx:
    lfsr    FSR0,txbuf
    movf    txrd,w
    addwf   FSR0L,f
    movff   INDF0,TXREG

    ; cyclic increment read pointer
    incf    txrd,f
    movlw   TB_SIZE
    xorwf   txrd,w
    btfsc   STATUS,Z
    clrf    txrd

    decf    txnum,f
    bra     isr_tx_end

isr_tx_xon:
    movlw   C_XON
    movwf   TXREG
    bcf     TX_XON
    bra     isr_tx_end

isr_tx_xoff:
    movlw   C_XOFF
    movwf   TXREG
    bcf     TX_XOFF
    bra     isr_tx_end

isr_tx_end:
    btfss   PIR1,RCIF
    bra     isr_rx_end

    ; receive char
    movlw   RB_SIZE
    cpfslt  rxnum
    bra     isr_rx_full

    movlw   RB_HIGH
    cpfseq  rxnum
    bra     isr_rx_nohigh

    ; recbuf high level reached -> stop transmit
    btfsc   RX_HOLD
    bra     isr_rx_nohigh

    bsf     TX_XOFF
    bsf     PIR1,TXIE

    bsf     RX_HOLD

isr_rx_nohigh:
    lfsr    FSR0,rxbuf
    movf    rxwr,w
    addwf   FSR0L,f
    movf    RCREG,w
    movwf   INDF0
    xorlw   C_XON
    bz      isr_rx_xon
    xorlw   C_XON ^ C_XOFF
    bz      isr_rx_xoff

    incf    rxnum,f

    ; cyclic increment write pointer
    incf    rxwr,f
    movlw   RB_SIZE
    xorwf   rxwr,w
    btfsc   STATUS,Z
    clrf    rxwr

    bra     isr_rx_end

isr_rx_xon:
    bcf     TX_HOLD
    bsf     PIE1,TXIE
    bra     isr_rx_end

isr_rx_xoff:
    bsf     TX_HOLD
    bra     isr_rx_end

isr_rx_full:
    movf    RCREG,w
    bra     isr_rx_end

isr_rx_end:

isr_ret:
    movff   isr_bsr,BSR
    movff   isr_fsr0+0,FSR0L
    movff   isr_fsr0+1,FSR0H
    movf    isr_w,w
    movff   isr_status,STATUS
    retfie



cmdjumps:
    goto    cmd_show
    goto    cmd_prog
    goto    cmd_hexline
    goto    cmd_setaddr
    goto    cmd_setvpp
    goto    cmd_test
    goto    cmd_device
    goto    cmd_method
    goto    cmd_power
    goto    cmd_read
    goto    cmd_check
    goto    cmd_write
    goto    cmd_verify
    goto    cmd_erase
    goto    cmd_list
    goto    cmd_select
    goto    cmd_help
    goto    cmd_offset
    goto    cmd_chksum



packed      code_pack


messages:
    db      "OK\r\n",0
    db      "ERR\r\n",0
    db      "?Syntax\r\n",0
    db      "?Agrument\r\n",0
    db      "?State\r\n",0
    db      "?Not supported\r\n",0
    db      "Device: ",0
    db      "Method: ",0
    db      "Vpp: ",0
    db      "Power: ",0
    db      "Mode: ",0
    db      "Testmode: ",0
    db      "write",0
    db      "verify",0
    db      "Module required: ",0
    db      "Module inserted: ",0
    db      "none selected",0
    db      "Model\tDevice\tModule\tVpp\tMethod\r\n",0
    db      "?Device not found\r\n",0
    db      "?Invalid module\r\n",0
    db      "Verify error at ",0
    db      "Address offset: ",0

    db      0
    db      "*invalid message*",0




    end

;    movlw   0x0d
;    call    serout
;    movlw   0x0a
;    call    serout
;    movlw   'W'
;    call    serout
;
;waitw:
;    btfsc   BTN1
;    bra     waitw
;
;    bcf     VCC
;
;
;    movlw   low chrgen
;    movwf   TBLPTRL
;    movlw   high chrgen
;    movwf   TBLPTRH
;    movlw   upper chrgen
;    movwf   TBLPTRU
;
;    movlw   0
;    movwf   cntl
;    movlw   0x10
;    movwf   cnth
;
;ckl:
;    tblrd   *+
;    movf    TABLAT,w
;    call    epr_write
;
;    bsf     ADRCLK
;    bcf     ADRCLK
;
;    movlw   '.'
;    call    serout
;
;    decf    cntl,f
;    bc      ckl
;    decf    cnth,f
;    bc      ckl
;
;    bsf     VCC


;epr_read:
;    movlw   0xFF
;    movwf   TRISB
;    bcf     EN
;    movf    PORTB,w
;    bsf     EN
;    return
;
;epr_write:
;    clrf    TRISB
;    movwf   LATB
;    bcf     GLOW
;    bsf     VPPEN
;    bcf     EN
;    movlw   .30
;    call    delay1ms
;    bsf     EN
;    bcf     VPPEN
;    bsf     GLOW
;    return

