#include    "hardware.inc"
#include    "eprtables.inc"

    global  seltable
    global  devtable
    global  chrgen

            udata_acs
tmp     res     1

            code

seltable:
    addlw   -1
    addwf   WREG,w
    addwf   WREG,w

    movwf   tmp
    movlw   high toktables
    movwf   PCLATH
    movlw   upper toktables
    movwf   PCLATU
    movlw   low toktables
    addwf   tmp,f
    movlw   0
    addwfc  PCLATH,f
    addwfc  PCLATU,f
    movf    tmp,w
    movwf   PCL

toktables:
    goto    cmd_table
    goto    dev_table
    goto    vpp_table
    goto    opt_table
    goto    met_table
    goto    mod_table

cmd_table:
    ltblptr cmd_tokens
    return

dev_table:
    ltblptr dev_tokens
    return

vpp_table:
    ltblptr vpp_tokens
    return

opt_table:
    ltblptr opt_tokens
    return

met_table:
    ltblptr met_tokens
    return

mod_table:
    ltblptr mod_tokens
    return

tables      code_pack

cmd_tokens:
    db      "SHOW",0
    db      "PROG",0
    db      ":",0
    db      "ADDR",0
    db      "VPP",0
    db      "TEST",0
    db      "DEVICE",0
    db      "METHOD",0
    db      "POWER",0
    db      "READ",0
    db      "CHECK",0
    db      "WRITE",0
    db      "VERIFY",0
    db      "ERASE",0
    db      "LIST",0
    db      "SELECT",0
    db      "HELP",0
    db      "OFFSET",0
    db      "CHKSUM",0
    db      0

dev_tokens:
    db      "2532",0
    db      "2564",0
    db      "2716",0
    db      "2732",0
    db      "2764",0
    db      "27128",0
    db      "27256",0
    db      "27512",0
    db      "2864",0
    db      "28256",0
    db      0

vpp_tokens:
    db      "12V",0
    db      "21V",0
    db      "25V",0
    db      0

opt_tokens:
    db      "ON",0
    db      "OFF",0
    db      0

met_tokens:
    db      "STANDARD",0
    db      "FAST",0
    db      "QUICK",0
    db      "EEPROM",0
    db      "EEFAST",0
    db      0

mod_tokens:
    db      "<no module>",0
    db      "2716/2532",0
    db      "2732",0
    db      "2764/27128/27256",0
    db      "27512/2864/28256",0
    db      "2564",0
    db      0
    db      "<unknown module>",0

devtable:
    db      "2532",0   , TOK_DEV_2532  , TOK_MOD_2716  , TOK_VPP_25V , TOK_MET_STANDARD
    db      "2564",0   , TOK_DEV_2564  , TOK_MOD_2564  , TOK_VPP_25V , TOK_MET_STANDARD
    db      "2716",0   , TOK_DEV_2716  , TOK_MOD_2716  , TOK_VPP_25V , TOK_MET_STANDARD
    db      "2716A",0  , TOK_DEV_2716  , TOK_MOD_2716  , TOK_VPP_21V , TOK_MET_STANDARD
    db      "2716B",0  , TOK_DEV_2716  , TOK_MOD_2716  , TOK_VPP_12V , TOK_MET_FAST
    db      "2732",0   , TOK_DEV_2732  , TOK_MOD_2732  , TOK_VPP_25V , TOK_MET_STANDARD
    db      "2732A",0  , TOK_DEV_2732  , TOK_MOD_2732  , TOK_VPP_21V , TOK_MET_STANDARD
    db      "2732B",0  , TOK_DEV_2732  , TOK_MOD_2732  , TOK_VPP_12V , TOK_MET_FAST
    db      "2764",0   , TOK_DEV_2764  , TOK_MOD_2764  , TOK_VPP_21V , TOK_MET_STANDARD
    db      "2764A",0  , TOK_DEV_2764  , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_FAST
    db      "27C64",0  , TOK_DEV_2764  , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_FAST
    db      "27128",0  , TOK_DEV_27128 , TOK_MOD_2764  , TOK_VPP_21V , TOK_MET_STANDARD
    db      "27128A",0 , TOK_DEV_27128 , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_FAST
    db      "27C128",0 , TOK_DEV_27128 , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_QUICK
    db      "27256",0  , TOK_DEV_27256 , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_FAST
    db      "27256A",0 , TOK_DEV_27256 , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_QUICK
    db      "27C256",0 , TOK_DEV_27256 , TOK_MOD_2764  , TOK_VPP_12V , TOK_MET_QUICK
    db      "27512",0  , TOK_DEV_27512 , TOK_MOD_27512 , TOK_VPP_12V , TOK_MET_FAST
    db      "27512A",0 , TOK_DEV_27512 , TOK_MOD_27512 , TOK_VPP_12V , TOK_MET_QUICK
    db      "27C512",0 , TOK_DEV_27512 , TOK_MOD_27512 , TOK_VPP_12V , TOK_MET_QUICK
    db      "28C64",0  , TOK_DEV_2864  , TOK_MOD_27512 , TOK_VPP_12V , TOK_MET_EEPROM
    db      "28C256",0 , TOK_DEV_28256 , TOK_MOD_27512 , TOK_VPP_12V , TOK_MET_EEPROM
    db      0

chrgen:
;    db	0x3C, 0x66, 0x6E, 0x6E, 0x60, 0x62, 0x3C, 0x00, 0x18, 0x3C, 0x66, 0x7E
;    db	0x66, 0x66, 0x66, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x7C, 0x00
;    db	0x3C, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3C, 0x00, 0x78, 0x6C, 0x66, 0x66
;    db	0x66, 0x6C, 0x78, 0x00, 0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7E, 0x00
;    db	0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00, 0x3C, 0x66, 0x60, 0x6E
;    db	0x66, 0x66, 0x3C, 0x00, 0x66, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00
;    db	0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x1E, 0x0C, 0x0C, 0x0C
;    db	0x0C, 0x6C, 0x38, 0x00, 0x66, 0x6C, 0x78, 0x70, 0x78, 0x6C, 0x66, 0x00
;    db	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x00, 0x63, 0x77, 0x7F, 0x6B
;    db	0x63, 0x63, 0x63, 0x00, 0x66, 0x76, 0x7E, 0x7E, 0x6E, 0x66, 0x66, 0x00
;    db	0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 0x7C, 0x66, 0x66, 0x7C
;    db	0x60, 0x60, 0x60, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x0E, 0x00
;    db	0x7C, 0x66, 0x66, 0x7C, 0x78, 0x6C, 0x66, 0x00, 0x3C, 0x66, 0x60, 0x3C
;    db	0x06, 0x66, 0x3C, 0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00
;    db	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 0x66, 0x66, 0x66, 0x66
;    db	0x66, 0x3C, 0x18, 0x00, 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00
;    db	0x66, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3C
;    db	0x18, 0x18, 0x18, 0x00, 0x7E, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x7E, 0x00
;    db	0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x0C, 0x12, 0x30, 0x7C
;    db	0x30, 0x62, 0xFC, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00
;    db	0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x00, 0x10, 0x30, 0x7F
;    db	0x7F, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00, 0x66, 0x66, 0x66, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0xFF, 0x66, 0xFF, 0x66, 0x66, 0x00
;    db	0x18, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x18, 0x00, 0x62, 0x66, 0x0C, 0x18
;    db	0x30, 0x66, 0x46, 0x00, 0x3C, 0x66, 0x3C, 0x38, 0x67, 0x66, 0x3F, 0x00
;    db	0x06, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x30
;    db	0x30, 0x18, 0x0C, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00
;    db	0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E
;    db	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30
;    db	0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0x18, 0x18, 0x00, 0x00, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00
;    db	0x3C, 0x66, 0x6E, 0x76, 0x66, 0x66, 0x3C, 0x00, 0x18, 0x18, 0x38, 0x18
;    db	0x18, 0x18, 0x7E, 0x00, 0x3C, 0x66, 0x06, 0x0C, 0x30, 0x60, 0x7E, 0x00
;    db	0x3C, 0x66, 0x06, 0x1C, 0x06, 0x66, 0x3C, 0x00, 0x06, 0x0E, 0x1E, 0x66
;    db	0x7F, 0x06, 0x06, 0x00, 0x7E, 0x60, 0x7C, 0x06, 0x06, 0x66, 0x3C, 0x00
;    db	0x3C, 0x66, 0x60, 0x7C, 0x66, 0x66, 0x3C, 0x00, 0x7E, 0x66, 0x0C, 0x18
;    db	0x18, 0x18, 0x18, 0x00, 0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00
;    db	0x3C, 0x66, 0x66, 0x3E, 0x06, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x18, 0x00
;    db	0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30
;    db	0x0E, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x7E, 0x00
;    db	0x7E, 0x00, 0x00, 0x00, 0x70, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x70, 0x00
;    db	0x3C, 0x66, 0x06, 0x0C, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0xFF
;    db	0xFF, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x7F, 0x1C, 0x3E, 0x00
;    db	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0xFF
;    db	0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0xFF, 0xFF, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30
;    db	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0xE0
;    db	0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x0F, 0x07, 0x00, 0x00, 0x00
;    db	0x18, 0x18, 0x38, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0
;    db	0xC0, 0xC0, 0xFF, 0xFF, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03
;    db	0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 0xFF, 0xFF, 0xC0, 0xC0
;    db	0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03
;    db	0x00, 0x3C, 0x7E, 0x7E, 0x7E, 0x7E, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0xFF, 0xFF, 0x00, 0x36, 0x7F, 0x7F, 0x7F, 0x3E, 0x1C, 0x08, 0x00
;    db	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x07
;    db	0x0F, 0x1C, 0x18, 0x18, 0xC3, 0xE7, 0x7E, 0x3C, 0x3C, 0x7E, 0xE7, 0xC3
;    db	0x00, 0x3C, 0x7E, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x18, 0x18, 0x66, 0x66
;    db	0x18, 0x18, 0x3C, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06
;    db	0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x18, 0x18, 0x18, 0xFF
;    db	0xFF, 0x18, 0x18, 0x18, 0xC0, 0xC0, 0x30, 0x30, 0xC0, 0xC0, 0x30, 0x30
;    db	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x03, 0x3E
;    db	0x76, 0x36, 0x36, 0x00, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0xFF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0
;    db	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03
;    db	0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0x33, 0x33
;    db	0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80, 0x03, 0x03, 0x03, 0x03
;    db	0x03, 0x03, 0x03, 0x03, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18
;    db	0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x18, 0x18, 0x18, 0x1F
;    db	0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0x18, 0x18, 0x18
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x1F
;    db	0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8
;    db	0xF8, 0x18, 0x18, 0x18, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0
;    db	0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x07, 0x07, 0x07, 0x07
;    db	0x07, 0x07, 0x07, 0x07, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF
;    db	0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F
;    db	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x00
;    db	0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0xC3, 0x99, 0x91, 0x91, 0x9F, 0x99, 0xC3, 0xFF
;    db	0xE7, 0xC3, 0x99, 0x81, 0x99, 0x99, 0x99, 0xFF, 0x83, 0x99, 0x99, 0x83
;    db	0x99, 0x99, 0x83, 0xFF, 0xC3, 0x99, 0x9F, 0x9F, 0x9F, 0x99, 0xC3, 0xFF
;    db	0x87, 0x93, 0x99, 0x99, 0x99, 0x93, 0x87, 0xFF, 0x81, 0x9F, 0x9F, 0x87
;    db	0x9F, 0x9F, 0x81, 0xFF, 0x81, 0x9F, 0x9F, 0x87, 0x9F, 0x9F, 0x9F, 0xFF
;    db	0xC3, 0x99, 0x9F, 0x91, 0x99, 0x99, 0xC3, 0xFF, 0x99, 0x99, 0x99, 0x81
;    db	0x99, 0x99, 0x99, 0xFF, 0xC3, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xC3, 0xFF
;    db	0xE1, 0xF3, 0xF3, 0xF3, 0xF3, 0x93, 0xC7, 0xFF, 0x99, 0x93, 0x87, 0x8F
;    db	0x87, 0x93, 0x99, 0xFF, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x81, 0xFF
;    db	0x9C, 0x88, 0x80, 0x94, 0x9C, 0x9C, 0x9C, 0xFF, 0x99, 0x89, 0x81, 0x81
;    db	0x91, 0x99, 0x99, 0xFF, 0xC3, 0x99, 0x99, 0x99, 0x99, 0x99, 0xC3, 0xFF
;    db	0x83, 0x99, 0x99, 0x83, 0x9F, 0x9F, 0x9F, 0xFF, 0xC3, 0x99, 0x99, 0x99
;    db	0x99, 0xC3, 0xF1, 0xFF, 0x83, 0x99, 0x99, 0x83, 0x87, 0x93, 0x99, 0xFF
;    db	0xC3, 0x99, 0x9F, 0xC3, 0xF9, 0x99, 0xC3, 0xFF, 0x81, 0xE7, 0xE7, 0xE7
;    db	0xE7, 0xE7, 0xE7, 0xFF, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xC3, 0xFF
;    db	0x99, 0x99, 0x99, 0x99, 0x99, 0xC3, 0xE7, 0xFF, 0x9C, 0x9C, 0x9C, 0x94
;    db	0x80, 0x88, 0x9C, 0xFF, 0x99, 0x99, 0xC3, 0xE7, 0xC3, 0x99, 0x99, 0xFF
;    db	0x99, 0x99, 0x99, 0xC3, 0xE7, 0xE7, 0xE7, 0xFF, 0x81, 0xF9, 0xF3, 0xE7
;    db	0xCF, 0x9F, 0x81, 0xFF, 0xC3, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xC3, 0xFF
;    db	0xF3, 0xED, 0xCF, 0x83, 0xCF, 0x9D, 0x03, 0xFF, 0xC3, 0xF3, 0xF3, 0xF3
;    db	0xF3, 0xF3, 0xC3, 0xFF, 0xFF, 0xE7, 0xC3, 0x81, 0xE7, 0xE7, 0xE7, 0xE7
;    db	0xFF, 0xEF, 0xCF, 0x80, 0x80, 0xCF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0xFF, 0xE7, 0xFF
;    db	0x99, 0x99, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x99, 0x00, 0x99
;    db	0x00, 0x99, 0x99, 0xFF, 0xE7, 0xC1, 0x9F, 0xC3, 0xF9, 0x83, 0xE7, 0xFF
;    db	0x9D, 0x99, 0xF3, 0xE7, 0xCF, 0x99, 0xB9, 0xFF, 0xC3, 0x99, 0xC3, 0xC7
;    db	0x98, 0x99, 0xC0, 0xFF, 0xF9, 0xF3, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xF3, 0xE7, 0xCF, 0xCF, 0xCF, 0xE7, 0xF3, 0xFF, 0xCF, 0xE7, 0xF3, 0xF3
;    db	0xF3, 0xE7, 0xCF, 0xFF, 0xFF, 0x99, 0xC3, 0x00, 0xC3, 0x99, 0xFF, 0xFF
;    db	0xFF, 0xE7, 0xE7, 0x81, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xE7, 0xE7, 0xCF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xFF, 0xFF, 0xFC, 0xF9, 0xF3
;    db	0xE7, 0xCF, 0x9F, 0xFF, 0xC3, 0x99, 0x91, 0x89, 0x99, 0x99, 0xC3, 0xFF
;    db	0xE7, 0xE7, 0xC7, 0xE7, 0xE7, 0xE7, 0x81, 0xFF, 0xC3, 0x99, 0xF9, 0xF3
;    db	0xCF, 0x9F, 0x81, 0xFF, 0xC3, 0x99, 0xF9, 0xE3, 0xF9, 0x99, 0xC3, 0xFF
;    db	0xF9, 0xF1, 0xE1, 0x99, 0x80, 0xF9, 0xF9, 0xFF, 0x81, 0x9F, 0x83, 0xF9
;    db	0xF9, 0x99, 0xC3, 0xFF, 0xC3, 0x99, 0x9F, 0x83, 0x99, 0x99, 0xC3, 0xFF
;    db	0x81, 0x99, 0xF3, 0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0xC3, 0x99, 0x99, 0xC3
;    db	0x99, 0x99, 0xC3, 0xFF, 0xC3, 0x99, 0x99, 0xC1, 0xF9, 0x99, 0xC3, 0xFF
;    db	0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF
;    db	0xFF, 0xE7, 0xE7, 0xCF, 0xF1, 0xE7, 0xCF, 0x9F, 0xCF, 0xE7, 0xF1, 0xFF
;    db	0xFF, 0xFF, 0x81, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0x8F, 0xE7, 0xF3, 0xF9
;    db	0xF3, 0xE7, 0x8F, 0xFF, 0xC3, 0x99, 0xF9, 0xF3, 0xE7, 0xFF, 0xE7, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF7, 0xE3, 0xC1, 0x80
;    db	0x80, 0xE3, 0xC1, 0xFF, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7
;    db	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0xCF, 0xCF, 0xCF
;    db	0xCF, 0xCF, 0xCF, 0xCF, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3
;    db	0xFF, 0xFF, 0xFF, 0x1F, 0x0F, 0xC7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE3, 0xF0
;    db	0xF8, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xC7, 0x0F, 0x1F, 0xFF, 0xFF, 0xFF
;    db	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x3F, 0x1F, 0x8F, 0xC7
;    db	0xE3, 0xF1, 0xF8, 0xFC, 0xFC, 0xF8, 0xF1, 0xE3, 0xC7, 0x8F, 0x1F, 0x3F
;    db	0x00, 0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0xFC, 0xFC
;    db	0xFC, 0xFC, 0xFC, 0xFC, 0xFF, 0xC3, 0x81, 0x81, 0x81, 0x81, 0xC3, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xC9, 0x80, 0x80, 0x80
;    db	0xC1, 0xE3, 0xF7, 0xFF, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F
;    db	0xFF, 0xFF, 0xFF, 0xF8, 0xF0, 0xE3, 0xE7, 0xE7, 0x3C, 0x18, 0x81, 0xC3
;    db	0xC3, 0x81, 0x18, 0x3C, 0xFF, 0xC3, 0x81, 0x99, 0x99, 0x81, 0xC3, 0xFF
;    db	0xE7, 0xE7, 0x99, 0x99, 0xE7, 0xE7, 0xC3, 0xFF, 0xF9, 0xF9, 0xF9, 0xF9
;    db	0xF9, 0xF9, 0xF9, 0xF9, 0xF7, 0xE3, 0xC1, 0x80, 0xC1, 0xE3, 0xF7, 0xFF
;    db	0xE7, 0xE7, 0xE7, 0x00, 0x00, 0xE7, 0xE7, 0xE7, 0x3F, 0x3F, 0xCF, 0xCF
;    db	0x3F, 0x3F, 0xCF, 0xCF, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7
;    db	0xFF, 0xFF, 0xFC, 0xC1, 0x89, 0xC9, 0xC9, 0xFF, 0x00, 0x80, 0xC0, 0xE0
;    db	0xF0, 0xF8, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0x3F, 0x3F, 0x3F
;    db	0x3F, 0x3F, 0x3F, 0x3F, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC
;    db	0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0x33, 0x33, 0xCC, 0xCC, 0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F
;    db	0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xE7, 0xE7, 0xE7, 0xE0
;    db	0xE0, 0xE7, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0xE7, 0xE7, 0xE7, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07
;    db	0x07, 0xE7, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00
;    db	0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x00
;    db	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xE7, 0xE7, 0xE7
;    db	0xE7, 0xE7, 0xE7, 0x07, 0x07, 0xE7, 0xE7, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F
;    db	0x3F, 0x3F, 0x3F, 0x3F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F
;    db	0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0xFC, 0xFC, 0xFC
;    db	0xFC, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F
;    db	0xF0, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xE7, 0x07
;    db	0x07, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0, 0x3C, 0x66, 0x6E, 0x6E
;    db	0x60, 0x62, 0x3C, 0x00, 0x00, 0x00, 0x3C, 0x06, 0x3E, 0x66, 0x3E, 0x00
;    db	0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x00, 0x3C, 0x60
;    db	0x60, 0x60, 0x3C, 0x00, 0x00, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x00
;    db	0x00, 0x00, 0x3C, 0x66, 0x7E, 0x60, 0x3C, 0x00, 0x00, 0x0E, 0x18, 0x3E
;    db	0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x7C
;    db	0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x00, 0x00, 0x18, 0x00, 0x38
;    db	0x18, 0x18, 0x3C, 0x00, 0x00, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x3C
;    db	0x00, 0x60, 0x60, 0x6C, 0x78, 0x6C, 0x66, 0x00, 0x00, 0x38, 0x18, 0x18
;    db	0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x66, 0x7F, 0x7F, 0x6B, 0x63, 0x00
;    db	0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x3C, 0x66
;    db	0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60
;    db	0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x00, 0x00, 0x7C, 0x66
;    db	0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x00
;    db	0x00, 0x18, 0x7E, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x66, 0x66
;    db	0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00
;    db	0x00, 0x00, 0x63, 0x6B, 0x7F, 0x3E, 0x36, 0x00, 0x00, 0x00, 0x66, 0x3C
;    db	0x18, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x0C, 0x78
;    db	0x00, 0x00, 0x7E, 0x0C, 0x18, 0x30, 0x7E, 0x00, 0x3C, 0x30, 0x30, 0x30
;    db	0x30, 0x30, 0x3C, 0x00, 0x0C, 0x12, 0x30, 0x7C, 0x30, 0x62, 0xFC, 0x00
;    db	0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 0x00, 0x18, 0x3C, 0x7E
;    db	0x18, 0x18, 0x18, 0x18, 0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18
;    db	0x00, 0x00, 0x18, 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0x66, 0x66, 0xFF, 0x66, 0xFF, 0x66, 0x66, 0x00, 0x18, 0x3E, 0x60, 0x3C
;    db	0x06, 0x7C, 0x18, 0x00, 0x62, 0x66, 0x0C, 0x18, 0x30, 0x66, 0x46, 0x00
;    db	0x3C, 0x66, 0x3C, 0x38, 0x67, 0x66, 0x3F, 0x00, 0x06, 0x0C, 0x18, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00
;    db	0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x00, 0x66, 0x3C, 0xFF
;    db	0x3C, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x7E
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00
;    db	0x00, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, 0x3C, 0x66, 0x6E, 0x76
;    db	0x66, 0x66, 0x3C, 0x00, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7E, 0x00
;    db	0x3C, 0x66, 0x06, 0x0C, 0x30, 0x60, 0x7E, 0x00, 0x3C, 0x66, 0x06, 0x1C
;    db	0x06, 0x66, 0x3C, 0x00, 0x06, 0x0E, 0x1E, 0x66, 0x7F, 0x06, 0x06, 0x00
;    db	0x7E, 0x60, 0x7C, 0x06, 0x06, 0x66, 0x3C, 0x00, 0x3C, 0x66, 0x60, 0x7C
;    db	0x66, 0x66, 0x3C, 0x00, 0x7E, 0x66, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x00
;    db	0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00, 0x3C, 0x66, 0x66, 0x3E
;    db	0x06, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00
;    db	0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, 0x0E, 0x18, 0x30, 0x60
;    db	0x30, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00, 0x00
;    db	0x70, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x70, 0x00, 0x3C, 0x66, 0x06, 0x0C
;    db	0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00
;    db	0x18, 0x3C, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00, 0x7C, 0x66, 0x66, 0x7C
;    db	0x66, 0x66, 0x7C, 0x00, 0x3C, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3C, 0x00
;    db	0x78, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0x78, 0x00, 0x7E, 0x60, 0x60, 0x78
;    db	0x60, 0x60, 0x7E, 0x00, 0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00
;    db	0x3C, 0x66, 0x60, 0x6E, 0x66, 0x66, 0x3C, 0x00, 0x66, 0x66, 0x66, 0x7E
;    db	0x66, 0x66, 0x66, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00
;    db	0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x6C, 0x38, 0x00, 0x66, 0x6C, 0x78, 0x70
;    db	0x78, 0x6C, 0x66, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x00
;    db	0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x63, 0x00, 0x66, 0x76, 0x7E, 0x7E
;    db	0x6E, 0x66, 0x66, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00
;    db	0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0x00, 0x3C, 0x66, 0x66, 0x66
;    db	0x66, 0x3C, 0x0E, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x78, 0x6C, 0x66, 0x00
;    db	0x3C, 0x66, 0x60, 0x3C, 0x06, 0x66, 0x3C, 0x00, 0x7E, 0x18, 0x18, 0x18
;    db	0x18, 0x18, 0x18, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00
;    db	0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00, 0x63, 0x63, 0x63, 0x6B
;    db	0x7F, 0x77, 0x63, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x66, 0x00
;    db	0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x00, 0x7E, 0x06, 0x0C, 0x18
;    db	0x30, 0x60, 0x7E, 0x00, 0x18, 0x18, 0x18, 0xFF, 0xFF, 0x18, 0x18, 0x18
;    db	0xC0, 0xC0, 0x30, 0x30, 0xC0, 0xC0, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18
;    db	0x18, 0x18, 0x18, 0x18, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC
;    db	0x33, 0x99, 0xCC, 0x66, 0x33, 0x99, 0xCC, 0x66, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF
;    db	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xCC, 0xCC, 0x33, 0x33
;    db	0xCC, 0xCC, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03
;    db	0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0x33, 0x33, 0xCC, 0x99, 0x33, 0x66
;    db	0xCC, 0x99, 0x33, 0x66, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03
;    db	0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0x00, 0xF8, 0xF8, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x18, 0x18, 0x18
;    db	0x18, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF
;    db	0xFF, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xF8, 0x18, 0x18, 0x18
;    db	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0
;    db	0xE0, 0xE0, 0xE0, 0xE0, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07
;    db	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00
;    db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF
;    db	0x01, 0x03, 0x06, 0x6C, 0x78, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00
;    db	0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00
;    db	0x18, 0x18, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F
;    db	0xC3, 0x99, 0x91, 0x91, 0x9F, 0x99, 0xC3, 0xFF, 0xFF, 0xFF, 0xC3, 0xF9
;    db	0xC1, 0x99, 0xC1, 0xFF, 0xFF, 0x9F, 0x9F, 0x83, 0x99, 0x99, 0x83, 0xFF
;    db	0xFF, 0xFF, 0xC3, 0x9F, 0x9F, 0x9F, 0xC3, 0xFF, 0xFF, 0xF9, 0xF9, 0xC1
;    db	0x99, 0x99, 0xC1, 0xFF, 0xFF, 0xFF, 0xC3, 0x99, 0x81, 0x9F, 0xC3, 0xFF
;    db	0xFF, 0xF1, 0xE7, 0xC1, 0xE7, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xC1, 0x99
;    db	0x99, 0xC1, 0xF9, 0x83, 0xFF, 0x9F, 0x9F, 0x83, 0x99, 0x99, 0x99, 0xFF
;    db	0xFF, 0xE7, 0xFF, 0xC7, 0xE7, 0xE7, 0xC3, 0xFF, 0xFF, 0xF9, 0xFF, 0xF9
;    db	0xF9, 0xF9, 0xF9, 0xC3, 0xFF, 0x9F, 0x9F, 0x93, 0x87, 0x93, 0x99, 0xFF
;    db	0xFF, 0xC7, 0xE7, 0xE7, 0xE7, 0xE7, 0xC3, 0xFF, 0xFF, 0xFF, 0x99, 0x80
;    db	0x80, 0x94, 0x9C, 0xFF, 0xFF, 0xFF, 0x83, 0x99, 0x99, 0x99, 0x99, 0xFF
;    db	0xFF, 0xFF, 0xC3, 0x99, 0x99, 0x99, 0xC3, 0xFF, 0xFF, 0xFF, 0x83, 0x99
;    db	0x99, 0x83, 0x9F, 0x9F, 0xFF, 0xFF, 0xC1, 0x99, 0x99, 0xC1, 0xF9, 0xF9
;    db	0xFF, 0xFF, 0x83, 0x99, 0x9F, 0x9F, 0x9F, 0xFF, 0xFF, 0xFF, 0xC1, 0x9F
;    db	0xC3, 0xF9, 0x83, 0xFF, 0xFF, 0xE7, 0x81, 0xE7, 0xE7, 0xE7, 0xF1, 0xFF
;    db	0xFF, 0xFF, 0x99, 0x99, 0x99, 0x99, 0xC1, 0xFF, 0xFF, 0xFF, 0x99, 0x99
;    db	0x99, 0xC3, 0xE7, 0xFF, 0xFF, 0xFF, 0x9C, 0x94, 0x80, 0xC1, 0xC9, 0xFF
;    db	0xFF, 0xFF, 0x99, 0xC3, 0xE7, 0xC3, 0x99, 0xFF, 0xFF, 0xFF, 0x99, 0x99
;    db	0x99, 0xC1, 0xF3, 0x87, 0xFF, 0xFF, 0x81, 0xF3, 0xE7, 0xCF, 0x81, 0xFF
;    db	0xC3, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xC3, 0xFF, 0xF3, 0xED, 0xCF, 0x83
;    db	0xCF, 0x9D, 0x03, 0xFF, 0xC3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xC3, 0xFF
;    db	0xFF, 0xE7, 0xC3, 0x81, 0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0xEF, 0xCF, 0x80
;    db	0x80, 0xCF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0xFF, 0xE7, 0xFF, 0x99, 0x99, 0x99, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x99, 0x00, 0x99, 0x00, 0x99, 0x99, 0xFF
;    db	0xE7, 0xC1, 0x9F, 0xC3, 0xF9, 0x83, 0xE7, 0xFF, 0x9D, 0x99, 0xF3, 0xE7
;    db	0xCF, 0x99, 0xB9, 0xFF, 0xC3, 0x99, 0xC3, 0xC7, 0x98, 0x99, 0xC0, 0xFF
;    db	0xF9, 0xF3, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xE7, 0xCF, 0xCF
;    db	0xCF, 0xE7, 0xF3, 0xFF, 0xCF, 0xE7, 0xF3, 0xF3, 0xF3, 0xE7, 0xCF, 0xFF
;    db	0xFF, 0x99, 0xC3, 0x00, 0xC3, 0x99, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0x81
;    db	0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xCF
;    db	0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xE7, 0xE7, 0xFF, 0xFF, 0xFC, 0xF9, 0xF3, 0xE7, 0xCF, 0x9F, 0xFF
;    db	0xC3, 0x99, 0x91, 0x89, 0x99, 0x99, 0xC3, 0xFF, 0xE7, 0xE7, 0xC7, 0xE7
;    db	0xE7, 0xE7, 0x81, 0xFF, 0xC3, 0x99, 0xF9, 0xF3, 0xCF, 0x9F, 0x81, 0xFF
;    db	0xC3, 0x99, 0xF9, 0xE3, 0xF9, 0x99, 0xC3, 0xFF, 0xF9, 0xF1, 0xE1, 0x99
;    db	0x80, 0xF9, 0xF9, 0xFF, 0x81, 0x9F, 0x83, 0xF9, 0xF9, 0x99, 0xC3, 0xFF
;    db	0xC3, 0x99, 0x9F, 0x83, 0x99, 0x99, 0xC3, 0xFF, 0x81, 0x99, 0xF3, 0xE7
;    db	0xE7, 0xE7, 0xE7, 0xFF, 0xC3, 0x99, 0x99, 0xC3, 0x99, 0x99, 0xC3, 0xFF
;    db	0xC3, 0x99, 0x99, 0xC1, 0xF9, 0x99, 0xC3, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF
;    db	0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xE7, 0xE7, 0xCF
;    db	0xF1, 0xE7, 0xCF, 0x9F, 0xCF, 0xE7, 0xF1, 0xFF, 0xFF, 0xFF, 0x81, 0xFF
;    db	0x81, 0xFF, 0xFF, 0xFF, 0x8F, 0xE7, 0xF3, 0xF9, 0xF3, 0xE7, 0x8F, 0xFF
;    db	0xC3, 0x99, 0xF9, 0xF3, 0xE7, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0x00
;    db	0x00, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0x99, 0x81, 0x99, 0x99, 0x99, 0xFF
;    db	0x83, 0x99, 0x99, 0x83, 0x99, 0x99, 0x83, 0xFF, 0xC3, 0x99, 0x9F, 0x9F
;    db	0x9F, 0x99, 0xC3, 0xFF, 0x87, 0x93, 0x99, 0x99, 0x99, 0x93, 0x87, 0xFF
;    db	0x81, 0x9F, 0x9F, 0x87, 0x9F, 0x9F, 0x81, 0xFF, 0x81, 0x9F, 0x9F, 0x87
;    db	0x9F, 0x9F, 0x9F, 0xFF, 0xC3, 0x99, 0x9F, 0x91, 0x99, 0x99, 0xC3, 0xFF
;    db	0x99, 0x99, 0x99, 0x81, 0x99, 0x99, 0x99, 0xFF, 0xC3, 0xE7, 0xE7, 0xE7
;    db	0xE7, 0xE7, 0xC3, 0xFF, 0xE1, 0xF3, 0xF3, 0xF3, 0xF3, 0x93, 0xC7, 0xFF
;    db	0x99, 0x93, 0x87, 0x8F, 0x87, 0x93, 0x99, 0xFF, 0x9F, 0x9F, 0x9F, 0x9F
;    db	0x9F, 0x9F, 0x81, 0xFF, 0x9C, 0x88, 0x80, 0x94, 0x9C, 0x9C, 0x9C, 0xFF
;    db	0x99, 0x89, 0x81, 0x81, 0x91, 0x99, 0x99, 0xFF, 0xC3, 0x99, 0x99, 0x99
;    db	0x99, 0x99, 0xC3, 0xFF, 0x83, 0x99, 0x99, 0x83, 0x9F, 0x9F, 0x9F, 0xFF
;    db	0xC3, 0x99, 0x99, 0x99, 0x99, 0xC3, 0xF1, 0xFF, 0x83, 0x99, 0x99, 0x83
;    db	0x87, 0x93, 0x99, 0xFF, 0xC3, 0x99, 0x9F, 0xC3, 0xF9, 0x99, 0xC3, 0xFF
;    db	0x81, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0x99, 0x99, 0x99, 0x99
;    db	0x99, 0x99, 0xC3, 0xFF, 0x99, 0x99, 0x99, 0x99, 0x99, 0xC3, 0xE7, 0xFF
;    db	0x9C, 0x9C, 0x9C, 0x94, 0x80, 0x88, 0x9C, 0xFF, 0x99, 0x99, 0xC3, 0xE7
;    db	0xC3, 0x99, 0x99, 0xFF, 0x99, 0x99, 0x99, 0xC3, 0xE7, 0xE7, 0xE7, 0xFF
;    db	0x81, 0xF9, 0xF3, 0xE7, 0xCF, 0x9F, 0x81, 0xFF, 0xE7, 0xE7, 0xE7, 0x00
;    db	0x00, 0xE7, 0xE7, 0xE7, 0x3F, 0x3F, 0xCF, 0xCF, 0x3F, 0x3F, 0xCF, 0xCF
;    db	0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xCC, 0xCC, 0x33, 0x33
;    db	0xCC, 0xCC, 0x33, 0x33, 0xCC, 0x66, 0x33, 0x99, 0xCC, 0x66, 0x33, 0x99
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00
;    db	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F
;    db	0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0xFC, 0xFC, 0xFC, 0xFC
;    db	0xFC, 0xFC, 0xFC, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x33, 0x33, 0xCC, 0xCC
;    db	0x33, 0x66, 0xCC, 0x99, 0x33, 0x66, 0xCC, 0x99, 0xFC, 0xFC, 0xFC, 0xFC
;    db	0xFC, 0xFC, 0xFC, 0xFC, 0xE7, 0xE7, 0xE7, 0xE0, 0xE0, 0xE7, 0xE7, 0xE7
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0, 0xE7, 0xE7, 0xE7, 0xE0
;    db	0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x07, 0xE7, 0xE7, 0xE7
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xE0
;    db	0xE0, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x00, 0x00, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x07
;    db	0x07, 0xE7, 0xE7, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F
;    db	0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0xF8, 0xF8, 0xF8, 0xF8
;    db	0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;    db	0xFF, 0x00, 0x00, 0x00, 0xFE, 0xFC, 0xF9, 0x93, 0x87, 0x8F, 0x9F, 0xFF
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0
;    db	0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xE7, 0xE7, 0x07, 0x07, 0xFF, 0xFF, 0xFF
;    db	0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F
;    db	0xF0, 0xF0, 0xF0, 0xF0

    end



