#include <P18F4520.INC>
#define SYSCLK  .4000000

#define DBG   0

;module identificator bits
#define MID0_TRIS   TRISC,0
#define MID0        PORTC,0
#define MID1_TRIS   TRISC,1
#define MID1        PORTC,1
#define MID2_TRIS   TRISC,2
#define MID2        PORTC,2
#define MID3_TRIS   TRISC,3
#define MID3        PORTC,3

#define BTN1_TRIS   TRISE,3
#define BTN1        PORTE,3

#define LEDR_TRIS   TRISE,0
#define LEDY_TRIS   TRISE,1
#define LEDG_TRIS   TRISE,2
#define LEDR        LATE,0
#define LEDY        LATE,1
#define LEDG        LATE,2

#define ADRRST_TRIS     TRISA,1
#define ADRRST          LATA,1
#define ADRCLK_TRIS     TRISA,0
#define ADRCLK          LATA,0

#define VCCEN_TRIS      TRISD,2
#define VCCEN           LATD,2
#define VPPEN_TRIS      TRISD,3
#define VPPEN           LATD,3
#define VPPVCC_TRIS     TRISD,4
#define VPPVCC          LATD,4
#define VPPSEL1_TRIS    TRISD,0
#define VPPSEL1         LATD,0
#define VPPSEL2_TRIS    TRISD,1
#define VPPSEL2         LATD,1

#define OE_TRIS         TRISA,6
#define OE              LATA,6
#define CE_TRIS         TRISA,7
#define CE              LATA,7

#define A15_TRIS        TRISA,5
#define A15             LATA,5
#define A14_TRIS        TRISA,4
#define A14             LATA,4
#define A13_TRIS        TRISA,3
#define A13             LATA,3
#define A12_TRIS        TRISA,2
#define A12             LATA,2

; 2532 lines
#define E25_A11         CE
#define E25_A12         A13
#define E25_PGM         OE
#define E25_CS1         A12
#define E25_CS2         A14


; 2764-27128 PGM line
#define EPGM            A14

; 2864 RDY line
#define RDY_TRIS        A15_TRIS
#define RDY             A15

; 28xx EEPROM addr and WR lines
#define EE_A14          A15
#define EE_A13          A13
#define EE_A12          A12
#define EE_WR           A14


#define EDATA_TRIS      TRISB
#define EDATA_IN        PORTB
#define EDATA_OUT       LATB
