#include <stdio.h>
#include <avr/io.h>

#include <util/delay.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <avr/pgmspace.h>
#define P1LEDON     PORTD |= (1<<0)  //PD0
#define P1LEDOFF    PORTD &= ~(1<<0)
#define P1LEDTOGGLE PORTD ^= (1<<0)
#define P2LEDON     PORTD |= (1<<1)  //PD1
#define P2LEDOFF    PORTD &= ~(1<<1)
#define P2LEDTOGGLE PORTD ^= (1<<1)


ISR (INT0_vect) {
//   GICR &= ~(1<<INT0);
P2LEDOFF;
P1LEDON;

}
 
ISR (INT1_vect) {
//   GICR &= ~(1<<INT1);
P1LEDOFF;
P2LEDON;
}



int main(){

  DDRD = 0x83;
  PORTD = 0xef;
  _delay_ms(100);

  P1LEDOFF;
  P2LEDOFF;

  // az INT0 kulso interrupt beallitasa
  GICR |= (1<<INT0);        // INT0 engedelyezese (PD2-es lab)
  MCUCR |= (1<<ISC00);     // a lab lefuto elre adjon megszaktst


  // az INT1 kulso interrupt beallitasa
  GICR |= (1<<INT1);    // INT1 engedelyezese (PD3-es lab)
  MCUCR |= (1<<ISC10);     // a lab lefuto elre adjon megszaktst



  sei();  // GLOBAL INTERRUPT ENABLE

  while(1)
  {
  }
}

