/*
 * types.h
 *
 * Created: 10/28/2011 7:01:10 PM
 *  Author: Phil Levchenko
 *	 Email: phil at jumperone dot com
 *    Site: www.JumperOne.com
 * License: Licensed under Creative Commons Attribution-ShareAlike License 3.0
 *          http://creativecommons.org/licenses/by-sa/3.0/
 *
 *    This firmware comes WITHOUT ANY WARRANTIES and may contain MISTAKES,
 *    so use it AT YOUR OWN RISK!!!
 *
 */ 


#ifndef __TYPES_H_
#define __TYPES_H_


typedef unsigned char  u08;
typedef unsigned int   u16;
typedef unsigned long  u32;

typedef signed char s08;
typedef signed int  s16;
typedef signed long s32;


typedef struct{
	u08 low;
	u08 high;
} u16bytes;

typedef union{
	u16 value;
	u16bytes bytes;
} u16convert;

typedef struct{
	u08 byte1;
	u08 byte2;
	u08 byte3;
	u08 byte4;
} u32bytes;

typedef struct{
	u16 low;
	u16 high;
} u32words;

typedef union{
	u32 value;
	u32bytes bytes;
	u32words words;
} u32convert;


#define NULL 0

#define ON  1
#define OFF 0

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#endif /* __TYPES_H_ */
 