	LIST P=16F877
	ERRORLEVEL 1
	#INCLUDE	<P16F877.INC>

	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _WRT_ENABLE_ON & _LVP_ON & _DEBUG_OFF & _CPD_OFF

BASE	EQU	H'70'			;RAM BAZIS CIM
LOOPSZ	EQU	BASE+D'1'		;ISMETLESSZAM
STAT2	EQU	BASE+D'6'		;STATUS TUKOR CIM
MULI	EQU	BASE+D'7'		;SZORZO
MULC	EQU	BASE+D'9'		;SZORZANDO
PRO	EQU	BASE+D'11'		;EREDMENY
CAR2	EQU	H'0'			;CARRY TUKOR BIT

GYSZOG 	EQU	D'126'			;(8BIT, min)

	ORG	H'00'			;RESET VEKTOR
	NOP
	GOTO 	START
	
;---------------MEGSZAKITAS LEKEZELES-------------------------------------------
	ORG	H'04'			;INTERUPT VEKTOR

INT:	
	BTFSC	INTCON,	INTF		;RB0/INT
	GOTO	MEGSZ

	BTFSC	PIR1,	CCP1IF		;COMPARE MODUL
	GOTO	GYUJT
	

;	GOTO	START			;HA EGYIK SEM AKKOR RESET
;-------------------------------------------------------------------------------

;---------------MOTOR ALLO HELYZETBEN & INDITAS ELOTT---------------------------
START:
	BANKSEL	T1CON
	MOVLW	B'00110000'	;TMR1 INICIALIZALAS (T1CON)
	MOVWF	T1CON
			
	CLRF	TMR1H		;TMR1 KEZDO ERTEK
	CLRF	TMR1L

	BSF	STAT2,	CAR2	;TMR1 ALL

	CLRF	CCP1CON		;COMPARE TORLES


HOTST	
	CLRF	PIR1		;TMR1 TULCSORDULAS FLAG TORLES
	BANKSEL PIE1
	CLRF	PIE1	

	BSF	PIE1,	TMR1IE	;TMR1 TULCSORDULAS MEGSZAKITAS ENGEDELY
	
	MOVLW	B'11010000'	;RB0/INT MEGSZAKITAS ENGEDELYEZES,FLAG TORLES
	MOVWF	INTCON

	SLEEP			;VARAKOZAS A MEGSZAKITO IMPULZUSRA
;	GOTO	LOAD
;-------------------------------------------------------------------------------	

;--------------------------------------
LOAD:

	GOTO	LOAD

;--------------------------------------

;---------------MOTOR INDULASKOR ELSO MEGSZAKITASRA INDITJA A SZAMLALOT---------
CLDST	
	BANKSEL	T1CON
	BSF	T1CON,	TMR1ON	;TMR1 ALLOBOL INDITAS
	
	BCF	INTCON,	INTF	;MEGSZAKITASI OK MEGSZUNTETES
	BSF	INTCON,	GIE	;MEGSZAKITAS ENGEDELYEZVE

	RETFIE
;-------------------------------------------------------------------------------


;---------------FOTENGELY FOROG, MEGSZAKITAS------------------------------------
MEGSZ	
	BANKSEL T1CON
	BTFSS	T1CON,	TMR1ON	;HA TMR1 ALL AKKOR AZ INDITASI RUTIN JON
	GOTO	CLDST
	
	BCF	T1CON,	TMR1ON	;TMR1 STOP
		
	MOVF	TMR1H,	0	;FORDULATI IDO MENTES H
	
	BANKSEL	EEADR	
	MOVWF	EEADR		;FORDULATI IDOVEL EEPROM CIM MEGHATAROZAS	

	BANKSEL	TMR1L
	MOVF	TMR1L,	0	;FORDULATI IDO MENTES L
	MOVWF	MULC

	BANKSEL EECON1
	BSF	EECON1,	RD	;EEPROM OLVASAS INDIT
				
	BANKSEL	TMR1H
	CLRF	TMR1H		;TMR1 0-ZAS
	CLRF	TMR1L

	BANKSEL	PIE1
	BSF	PIE1,	TMR1IE
	BANKSEL T1CON
	BSF	T1CON,	TMR1ON	;TMR1 START

	BANKSEL	EECON1
EE1	
	BTFSC	EECON1,	RD	;OLVASAS VEGE VARAS
	GOTO	EE1
	
	BANKSEL	EEDATA
	MOVF	EEDATA,	0	;FELSO ERTEK TAROL
	MOVWF	MULI
	
	DECF	EEADR		;EPROM CIM, ALSO ERTEKHEZ

	BANKSEL EECON1
	BSF	EECON1,	RD	;OLVASAS INDIT

EE2	
	BTFSC	EECON1,	RD	;OLVASAS VEGE VARAS
	GOTO	EE2
	
	BANKSEL EEDATA
	MOVF	EEDATA		;FELSO ERTEK TAROL
	
	BANKSEL	CCPR1H
	MOVWF	CCPR1H		;COMPARE H BEALLIT
	MOVLW	B'11111111'
	MOVWF	CCPR1L		;COMPARE L BEALLIT

	SUBWF	MULI,	1	;ATMENETI ERTEK SZAMITAS

	BTFSS	STATUS,	C	;HA CARRY 0 AKKOR...
	BCF	STAT2,	CAR2	;CARRY MENTES
	
	BTFSC	STATUS,	C	;HA CARRY 1 AKKOR...
	BSF	STAT2,	CAR2	;CARRY MENTES
	
	BTFSC	STATUS,	C	;POZITIVRA ALAKITAS
	COMF	MULI,	1		
	BTFSC	STATUS,	C
	INCF	MULI,	1	
	
	MOVWF	MULI
	
	CALL	MUL
	MOVF	PRO+1
	
	BTFSC	STAT2,	CAR2
	SUBWF	CCPR1L,	1
	BTFSC	STAT2,	CAR2
	DECF	CCPR1H,	1
	BTFSS	STAT2,	CAR2
	ADDWF	CCPR1L,	1
	BTFSS	STAT2,	CAR2
	INCF	CCPR1L,	1
	
	MOVLW	B'00001010'	;COMPARE1 MODUL INDITAS
	MOVWF	CCP1CON

	BCF	INTCON,	INTF	;MEGSZAKITAS ENGEDELYEZVE

	RETFIE
	

;-------------------------------------------------------------------------------

;---------------GYUJTAS---------------------------------------------------------
GYUJT	
	BANKSEL PORTC
	BSF	PORTC,	2	;GYUJTAS IMPULZUS INDIT

	BCF	STATUS,	C	;CARRY TORLES
	BCF	PIR1,	CCP1IF	;COMPARE MODUL

	MOVLW	GYSZOG	;
	ADDWF	CCPR1L,	1
	
	BTFSC	STATUS,	C	;ATVITEL
	INCF	CCPR1H, 1
	
	MOVLW	B'00001001'	;COMPARE1 MODUL INDITAS, GYUJTASI IMPULZUS VEGE IDOZITESHEZ
	MOVWF	CCP1CON

GYU1	
	BTFSS	PIR1,	CCP1IF	;IMPULZUS VEGE VARAS
	GOTO	GYU1

	CLRF	CCP1CON		;COMPARE1 MODUL KIKAPCSOL

	BSF	INTCON,	GIE	;MEGSZAKITAS ENGEDELYEZVE

	RETFIE

;-------------------------------------------------------------------------------

;---------------8BITES SZORZAS 16OS EREDMENNYEL-----------------------------
MUL:
	CLRF	PRO
	CLRF	PRO+1
	MOVLW	16
	MOVWF	LOOPSZ
LOOP1:	
	RRF	MULI+1
	RRF	MULI
	BTFSS	STATUS,	C
	GOTO	SKIP
	MOVF	MULC+1
	ADDWF	PRO+1
	MOVF	MULC
	ADDWF	PRO
	BTFSC	STATUS,	C
	INCF	PRO+1
SKIP:	
	BCF	STATUS,	C
	RLF	MULC
	RLF	MULC+1
	DECFSZ	LOOPSZ
	GOTO	LOOP1

	RETURN

;-------------EEPROM FELTOLTESE ADATTAL-----------------------------------------
	ORG	H'2100'
	DE	15,25,35,100,105,126,54,30,0

	END
