#include <htc.h>
#include "lcd.h"

/**
 * TODO:
 *   Start timer when car goes through gantry for the first time (i.e. lapcounter = 0)
 *
 * BUGS:
 *   Doesnt always record fastest lap even though the time shown briefly is faster than the current best
 *   Also, occasionally slower lap time are taken as being the fastest even when they are slower than the current best
 *
 * @author uk_dave
 * @version 1.0, Sunday 12th March 2006
 */

__CONFIG(0x3fd2);

#define Track1Sensor       RA0
#define Track2Sensor       RA1

#define CURRENT_TIME       1
#define BEST_TIME          2
unsigned char displayMode = BEST_TIME;

unsigned char Track1Triggered = 0;          // Whether track 1 has been triggered (used for debounce)
unsigned char Track1Counter = 0;            // Number of laps for track 1
unsigned int  Track1BestLapTime = 65535;    //
unsigned int  Track1LastLapTime = 0;        //
unsigned int  Track1TMR0intr = 0;           // Value of TMR0 for track 1

unsigned char Track2Triggered = 0;          // Whether track 2 has been triggered (used for debounce)
unsigned char Track2Counter = 0;            // Number of laps for track 2
unsigned int  Track2BestLapTime = 65535;    //
unsigned int  Track2LastLapTime = 0;        //
unsigned int  Track2TMR0intr = 0;           // Value of TMR0 for track 2

unsigned char debounceCounter = 0;          // counter used in the TMR0 interrupt for debouncing
bit redraw = 0;                             // Flag to determine whether the LCD screen needs updating
unsigned char dump = 0;                     // PORTB is dumped here in the ISR


void init(void)
{
	IOCA = 0b00000000;      // Disable interrupt-on-change for Port A
	IOCB = 0b01010000;      // Enable interrupt-on-change for RB4 and RB6
	INTCON = 0b00101000;    // Enable TMR0 interrupts and IOC interrupts ************* (GIE will be enabled later!!) **************
        OPTION_REG = 0b10000111;    // Assign prescaler to TMR0 and set prescaler to 1:256 which will cause an interrupt every 13.1072 milliseconds

	TRISA = 0b00000000;     // Set Port A all output
	TRISB = 0b01010000;     // Set Port B all output except for RB4 and RB6 (track sensors)
	TRISC = 0b00000000;     // Set Port C all output

	ANSEL = 0b00000000;     // Disable ADC so we can use pins as regular IO
	ANSELH = 0b00000000;    // Disable ADC so we can use pins as regular IO
	CM1CON0 = 0b00000000;   // Disable comparator 1
	CM2CON0 = 0b00000000;   // Disable comparator 2
	SSPCON = 0b00010000;    // Disable UART

	PORTA = 0b00000000;     // Clear Port A
	PORTB = 0b00000000;     // Clear Port B
	PORTC = 0b00000000;     // Clear Port C
}

void printTime(unsigned int t)
{
	unsigned long time = t * 13L;
	unsigned char time_ms = (time % 1000);
	unsigned char time_sec = ((time/1000) % 60);
	unsigned char time_min = ((time/60000) % 60);
	LCDputChar(((time_min / 10) % 10) + 48);
	LCDputChar((time_min % 10) + 48);
	LCDputChar(':');
	LCDputChar(((time_sec / 10) % 10) + 48);
	LCDputChar((time_sec % 10) + 48);
	LCDputChar('.');
	LCDputChar(((time_ms / 100) % 10) + 48);
	LCDputChar(((time_ms % 10) % 10) + 48);
}

void main()
{
	unsigned char i = 0;
	unsigned char j = 0;
	unsigned char k = 0;

	init();

	LCDinit();

	LCDputLine(0, "   Scalextric   ", 16);
	LCDputLine(1, "  Lap  Counter  ", 16);
	for (i=0; i<50; i++) { for (j=0; j<255; j++) { for (k=0; k<255; k++) { } } }
	LCDclear();
	redraw=1;
	Track1TMR0intr=0;
	Track2TMR0intr=0;
	GIE=1;

	while(1)
	{
		if (redraw == 1)
		{
			redraw = 1;

			LCDsetCursor(0, 0);
			LCDputChar('T');
			LCDputChar('1');
			LCDputChar(':');
			LCDputChar(' ');
			LCDputChar(((Track1Counter / 10) % 10) + 48);
			LCDputChar((Track1Counter % 10) + 48);
			LCDputChar(' ');
			LCDputChar(' ');
			if (Track1Triggered==1)
				printTime(Track1LastLapTime);
			else
			{
				if (displayMode == CURRENT_TIME)
					printTime(Track1TMR0intr);
				else
					printTime(Track1BestLapTime);
			}

			LCDsetCursor(1, 0);
			LCDputChar('T');
			LCDputChar('2');
			LCDputChar(':');
			LCDputChar(' ');
			LCDputChar(((Track2Counter / 10) % 10) + 48);
			LCDputChar((Track2Counter % 10) + 48);
			LCDputChar(' ');
			LCDputChar(' ');
			if (Track2Triggered==1)
				printTime(Track2LastLapTime);
			else
			{
				if (displayMode == CURRENT_TIME)
					printTime(Track2TMR0intr);
				else
					printTime(Track2BestLapTime);
			}
		}
	}
}


static void interrupt isr(void)
{
	dump = PORTB;

	if (RABIF == 1)
	{
		if ((dump & 0b00010000)==0b00010000 && Track1Triggered==0)
		{
			debounceCounter = 0;
			Track1Triggered = 1;
			Track1Counter++;
			Track1LastLapTime = Track1TMR0intr;
			if (Track1LastLapTime < Track1BestLapTime)
				Track1BestLapTime = Track1LastLapTime;
			Track1TMR0intr = 0;
			redraw = 1;
			RB7=1;
		}
		if ((dump & 0b01000000)==0b01000000 && Track2Triggered==0)
		{
			debounceCounter = 0;
			Track2Triggered = 1;
			Track2Counter++;
			Track2LastLapTime = Track2TMR0intr;
			if (Track2LastLapTime < Track2BestLapTime)
				Track2BestLapTime = Track2LastLapTime;
			Track2TMR0intr = 0;
			redraw = 1;
			RB7=1;
		}
		RABIF = 0;
	}

	if (T0IF == 1)
	{
		if (debounceCounter==100)
		{
			Track1Triggered = 0;
			Track2Triggered = 0;
			debounceCounter = 0;
			RB7=0;
		}
		else
			debounceCounter++;
		Track1TMR0intr++;
		Track2TMR0intr++;
		T0IF = 0;
	}
}
