#include "lcd.h"

#include <htc.h>

#define LCD_RS          RA0             // register select (1=data, 0=instruction)
#define LCD_RW          RA1             // read/write select (1=read, 0=write)
#define LCD_ENABLE      RA2             // Start signal for read/write

#define LCD_DATA        PORTC

#define LCD_DELAY       250
int lcdDelay=0;

void LCDinit(void)
{
	LCDdelayLong();
	LCDputCmd(0b00111000);          // configure display for 8-bit interface and 2 lines
	LCDdelay();
	LCDputCmd(0b00000001);          // clear the screen
	LCDdelay();
	LCDputCmd(0b00001100);          // turn display on and disable cursor blink
	LCDdelay();
}


void LCDputCmd(unsigned char cmd)
{
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_ENABLE = 1;
	LCDdelay();
	LCD_DATA = cmd;
	LCDdelay();
	LCD_ENABLE = 0;
	LCDdelay();
}

void LCDputChar(unsigned char ch)
{
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_ENABLE = 1;
	LCDdelay();
	LCD_DATA = ch;
	LCDdelay();
	LCD_ENABLE = 0;
	LCDdelay();
}

void LCDclear(void)
{
	LCDputCmd(0b00000001);
	for (lcdDelay=0; lcdDelay<LCD_DELAY; lcdDelay++) { }
}

void LCDsetCursor(unsigned char row, unsigned char col)
{
	if (row==1)
		col += 0x40;
	LCDputCmd((0b1000 << 4) + col);
	for (lcdDelay=0; lcdDelay<LCD_DELAY; lcdDelay++) { }
}

void LCDputLine(unsigned char line, const char *str, unsigned char len)
{
	LCDsetCursor(line,0);
	while(*str)
		LCDputChar(*str++);
}

void LCDdelay(void)
{
	for (lcdDelay=0; lcdDelay<LCD_DELAY; lcdDelay++) { }
}

void LCDdelayLong(void)
{
	for (lcdDelay=0; lcdDelay<10000; lcdDelay++) { }
}
