;********************************************
; PFC-50   POCKET FREQUENCY COUNTER
;********************************************
;
;WATCHDOG DISABLED
;
;**********************************************************
     LIST P=16F84A
     #include <p16F84A.inc>
     __CONFIG _XT_OSC & _WDT_OFF & _PWRTE_ON & _CP_ALL
;**********************************************************




RS        EQU  2H
RW        EQU  1H
E         EQU  0H
O         EQU  7H
;
COUNT1	EQU	2CH
COUNT2	EQU	2DH
IN_REG	EQU	2EH 
ADDCNT	EQU	2FH
GATE      EQU  0CH
CNT1      EQU  0DH
CNT2      EQU  0EH
CNT3      EQU  0FH
CALC1	EQU	10H
CALC2	EQU	11H
CALC3	EQU	12H
SUM1      EQU  13H
SUM2      EQU  14H
SUM3      EQU  15H
RTCC2	EQU	16H
TEMP1     EQU  17H
TEMP2     EQU  18H
COUNT3    EQU  19H
COUNT4    EQU  1AH

;-----------------------------------------------
;-----------------------------------------------
;-----------------------------------------------
     ORG       0
     GOTO      START
			
;
INT_DEL:
     MOVLW     0X05      ;DELAY 5.000 MS (4 MHZ CLOCK)
	MOVWF	COUNT1
D1	MOVLW	0XA5
	MOVWF	COUNT2
D2   DECFSZ    COUNT2,F
     GOTO      D2
     DECFSZ    COUNT1,F
     GOTO      D1
	RETLW	0X00
;
MIRROR:
     CLRF      TEMP2
	MOVWF	TEMP1
	BTFSC	TEMP1,0
     BSF       TEMP2,7
	BTFSC	TEMP1,1
     BSF       TEMP2,6
	BTFSC	TEMP1,2
     BSF       TEMP2,5
	BTFSC	TEMP1,3
     BSF       TEMP2,4
	BTFSC	TEMP1,4
     BSF       TEMP2,3
	BTFSC	TEMP1,5
     BSF       TEMP2,2
	BTFSC	TEMP1,6
     BSF       TEMP2,1
	BTFSC	TEMP1,7
     BSF       TEMP2,0
     MOVF      TEMP2,W
     RETURN
     ;
LCD_OUT:
     CALL      MIRROR
     MOVWF     PORTB         ;LOAD DATA INTO PORTB
     BSF       STATUS,RP0
     MOVLW     B'00000000'    ;DEFINE PORTB AS OUTPUT
     MOVWF     TRISB
     BCF       STATUS,RP0
     BSF       PORTA,RS ;RS = DATA
     BCF       PORTA,RW ;R/W = WRITE
     BSF       PORTA,E  ;TOGGLE ENABLE
     BCF       PORTA,E
     ;
     BSF       STATUS,RP0
     MOVLW     B'11111111'    ;DEFINE PORTB AS INPUT
     MOVWF     TRISB
     BCF       STATUS,RP0
     ;
     BCF       PORTA,RS ;RS = INSTRUCTION
     BSF       PORTA,RW ;R/W = READ
     BSF       PORTA,E  ;ENABLE HIGH
     MOVF      PORTB,W  ;GET ADDRESS COUNTER
     CALL      MIRROR
	MOVWF	ADDCNT
     BSF       ADDCNT,7
     BCF       PORTA,E  ;ENABLE LOW
OUT1 BSF       PORTA,E  ;ENABLE HIGH
     BTFSS     PORTB,0  ;TEST BUSY FLAG
     GOTO      OUT2
     BCF       PORTA,E  ;ENABLE LOW
     GOTO      OUT1
OUT2 BCF       PORTA,E  ;ENABLE LOW
     GOTO      SHIFT
;
INST:
     CALL      MIRROR
     MOVWF     PORTB         ;LOAD INSTRUCTION INTO PORTB
     BSF       STATUS,RP0
     MOVLW     B'00000000'    ;DEFINE PORTB AS OUTPUT
     MOVWF     TRISB
     BCF       STATUS,RP0
     BCF       PORTA,RS ;RS = INSTRUCTION
     BCF       PORTA,RW ;R/W = WRITE
     BSF       PORTA,E  ;TOGGLE ENABLE
     BCF       PORTA,E
     BSF       STATUS,RP0
     MOVLW     B'11111111'    ;DEFINE PORTB AS INPUT
     MOVWF     TRISB
     BCF       STATUS,RP0
     BSF       PORTA,RW ;R/W = READ
INST1:
     BSF       PORTA,E  ;ENABLE HIGH
     BTFSS     PORTB,0  ;TEST BUSY FLAG
     GOTO      INST2
     BCF       PORTA,E  ;ENABLE LOW
     GOTO      INST1
INST2:
     BCF       PORTA,E  ;ENABLE LOW
	RETLW	0X00
;
;----------------------------------- 
; LCD 16X1

SHIFT:
     BTFSS     ADDCNT,0       ;SHIFT TO OPPOSITE SIDE OF DISPLAY?
	RETLW	0X00
	BTFSS	ADDCNT,1
	RETLW	0X00
	BTFSS	ADDCNT,2
	RETLW	0X00
		
	MOVLW	0XC0
     MOVF      ADDCNT,W
	MOVLW	0XC0
     GOTO      INST
;------------------------------------
SUB  BCF       STATUS,O  ;CLEAR OVERFLOW BIT
     MOVF      CALC1,W        ;SUBTRACT CALC1 FROM CNT1 
	SUBWF	CNT1	,F
	BTFSC	STATUS,C
     GOTO      SB1
	MOVLW	0X01		;BORROW FROM CNT2 IF OVERFLOW
	SUBWF	CNT2	,F
	BTFSC	STATUS,C
     GOTO      SB1
	SUBWF	CNT3	,F		;BORROW FROM CNT3 IF CNT2 OVERFLOW
	BTFSS	STATUS,C
     BSF       STATUS,O  ;SET OVERFLOW BIT IF RESULT IS NEGATIVE
SB1  MOVF      CALC2,W        ;SUBTRACT CALC2 FROM CNT2
	SUBWF	CNT2	,F
	BTFSC	STATUS,C
     GOTO      SB2
	MOVLW	0X01		;BORROW FROM CNT3 IF CNT2 OVERFLOW
	SUBWF	CNT3	,F
	BTFSS	STATUS,C
     BSF       STATUS,O  ;SET OVERFLOW BIT IF RESULT IS NEGATIVE
SB2  MOVF      CALC3,W        ;SUBTRACT CALC3 FROM CNT3
	SUBWF	CNT3	,F
	BTFSS	STATUS,C
     BSF       STATUS,O  ;SET OVERFLOW BIT IF RESULT IS NEGATIVE
	RETLW	0X00
;----------------------------------- 
ADD  MOVF      CALC1,W        ;ADD CALC1 TO CNT1
	ADDWF	CNT1	,F
	BTFSS	STATUS,C
     GOTO      AD1
	INCFSZ	CNT2	,F		;ADD TO CNT2 IF CNT1 OVERFLOW
     GOTO      AD1
     INCF      CNT3 ,F        ;ADD TO CNT3 IF CNT2 OVERFLOW
AD1  MOVF      CALC2,W        ;ADD CALC2 TO CNT2
	ADDWF	CNT2	,F
	BTFSC	STATUS,C
     INCF      CNT3 ,F        ;ADD TO CNT3 IF CNT2 OVERFLOW
     MOVF      CALC3,W        ;ADD CALC3 TO CNT3
	ADDWF	CNT3	,F
	RETLW	0X00
;----------------------------------- 
CNVT	MOVLW	0X07		;7 DIGITS IN DISPLAY
	MOVWF	COUNT1
	MOVLW	0X19		;SET FSR FOR MSB IN DISPLAY
	MOVWF	FSR
	MOVLW	0X2F		;ONE LESS THAT ASCII "0"
CNVT0:
     MOVWF     INDF
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      CNVT0
	MOVLW	0X0F		;LOAD "1,000,000" IN CALC1-3
	MOVWF	CALC3
	MOVLW	0X42
	MOVWF	CALC2
	MOVLW	0X40
	MOVWF	CALC1
CNVT1:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      19   ,F        ;INCREMENT 1,000,000'S REGISTER
	MOVLW	0X3A
	XORWF	19,W
	BTFSC	STATUS,Z
     GOTO      OVERFLOW
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT1
     CALL      ADD       ;ADD BACK LAST NUMBER
	MOVLW	0X01		;LOAD "100,000" IN CALC1-3
	MOVWF	CALC3
	MOVLW	0X86
	MOVWF	CALC2
	MOVLW	0XA0
	MOVWF	CALC1
CNVT2:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      1A   ,F        ;INCREMENT 100,000'S REGISTER
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT2
     CALL      ADD       ;ADD BACK LAST NUMBER
     CLRF      CALC3          ;LOAD "10,000" IN CALC1-3
	MOVLW	0X27
	MOVWF	CALC2
	MOVLW	0X10
	MOVWF	CALC1
CNVT3:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      1B   ,F        ;INCREMENT 10,000'S REGISTER
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT3
     CALL      ADD       ;ADD BACK LAST NUMBER
	MOVLW	0X03		;LOAD "1,000" IN CALC1-3
	MOVWF	CALC2
	MOVLW	0XE8
	MOVWF	CALC1
CNVT4:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      1C   ,F        ;INCREMENT 1,000'S REGISTER
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT4
     CALL      ADD       ;ADD BACK LAST NUMBER
     CLRF      CALC2          ;LOAD "100" IN CALC1-3
	MOVLW	0X64
	MOVWF	CALC1
CNVT5:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      1D   ,F        ;INCREMENT 100'S REGISTER
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT5
     CALL      ADD       ;ADD BACK NUMBER
	MOVLW	0X0A		;LOAD "10" IN CALC1-3
	MOVWF	CALC1
CNVT6:
     CALL      SUB       ;SUBTRACT NUMBER FROM COUNT
     INCF      1E   ,F        ;INCREMENT 10'S REGISTER
	BTFSS	STATUS,O	;CHECK IF OVERFLOW
     GOTO      CNVT6
     CALL      ADD       ;ADD BACK LAST NUMBER
     MOVF      CNT1,W         ;PUT REMAINDFER IN 1'S REGISTER
	ADDWF	1F	,F
     INCF      1F   ,F
	RETLW	0X00
;----------------------------------- 
COUNT:
     BSF       STATUS,RP0
     MOVLW     B'00110111'    ;TMR0 = EXT, 1/256
     MOVWF     OPTION_REG
     MOVLW     B'00010000'    ;DEFINE PORTA AS OUTPUT 
     MOVWF     TRISA
     BCF       STATUS,RP0
     BCF       PORTA,3
     BCF       PORTA,2
     CLRF      CNT3
     CLRF      TMR0
     CLRF      RTCC2
     BSF       PORTA,2  ;TOGGLE TMR0 PIN
     BCF       PORTA,2
     MOVF      GATE,W         ;GET GATE TIME
	MOVWF	COUNT1
     BSF       PORTA,3  ;START COUNT
FR4	MOVLW	0XFA
	MOVWF	COUNT2
     GOTO      FR6
FR5	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
FR6  MOVF      TMR0,W         ;TEST FOR TMR0 ROLLOVER (12)
	SUBWF	RTCC2	,F
	BTFSS	STATUS,Z
     GOTO      FR7
	NOP
     GOTO      FR8
FR7	BTFSC	STATUS,C
     INCF      CNT3 ,F
FR8	MOVWF	RTCC2
	NOP
	NOP
	NOP
	DECFSZ	COUNT2	,F
     GOTO      FR5
	DECFSZ	COUNT1	,F
     GOTO      FR4
     BCF       PORTA,3  ;STOP COUNT
     MOVF      TMR0,W         ;GET TMR0 COUNT
	MOVWF	CNT2
     SUBWF     RTCC2     ,F        ;TEST FOR TMR0 ROLLOVER
	BTFSS	STATUS,C
     GOTO      FR9
	BTFSS	STATUS,Z
     INCF      CNT3 ,F
FR9  CLRF      CNT1      ;SET TO GET PRESCALER COUNT
FR10 DECF      CNT1 ,F
     BSF       PORTA,2  ;TOGGLE TMR0 PIN
     BCF       PORTA,2
     MOVF      TMR0,W         ;TEST IF TMR0 HAS CHANGED
	XORWF	CNT2,W
	BTFSC	STATUS,Z
     GOTO      FR10
	RETLW	0X00
;
;*********************************************************
;                  START MAIN PROGRAM
;*********************************************************
;
START:

     CLRF      PORTA         ;INSTRUCTION, WRITE, ENABLE LOW
     CLRF      PORTB
     ;
     BSF       STATUS,RP0
	MOVLW	B'00010000'
     MOVWF     TRISA
	MOVLW	B'00000000'
     MOVWF     TRISB
     BCF       STATUS,RP0

     CALL      INT_DEL
     CALL      INT_DEL
     CALL      INT_DEL
     ;
     MOVLW     0X38     ;INITIALIZE DISPLAY
     CALL      MIRROR
     MOVWF     PORTB
     ;
     BSF       PORTA,E  ;TOGGLE ENABLE
     CALL      INT_DEL
     BCF       PORTA,E
     BSF       PORTA,E  ;TOGGLE ENABLE
     CALL      INT_DEL
     BCF       PORTA,E
     BSF       PORTA,E  ;TOGGLE ENABLE
     CALL      INT_DEL
     BCF       PORTA,E
     ;
     MOVLW     0X38      ;FUNCTION
     CALL      INST
	MOVLW	B'00001100'	;DISPLAY ON, CURSOR OFF
     CALL      INST
	MOVLW	B'00000001'	;CLEAR DISPLAY
     CALL      INST
	MOVLW	B'00000110'	;ENTRY MODE
     CALL      INST
     ;
;***********************************
;  NEW LINES HERE FOR INTRO 
     MOVLW     0X50          ;P
     CALL      LCD_OUT
     MOVLW     0X46          ;F
     CALL      LCD_OUT
     MOVLW     0X43          ;C
     CALL      LCD_OUT
     MOVLW     0X2D          ;-
     CALL      LCD_OUT
     MOVLW     0X35          ;5
     CALL      LCD_OUT
     MOVLW     0X30          ;0
     CALL      LCD_OUT
     ;
	MOVLW	0X06  		;CHANGE THE 6 TO A SMALLER NO. TO SPEED UP THE INTRO
	MOVWF	COUNT3		
WAIT1:
     MOVLW     0XC8
	MOVWF	COUNT4
WAIT2:
     CALL      INT_DEL
	DECFSZ	COUNT4	,F
     GOTO      WAIT2
	DECFSZ	COUNT3	,F
     GOTO      WAIT1
;************************************
	MOVLW	B'00000001'	;CLEAR DISPLAY
     CALL      INST
     ;
MHZ	MOVLW	0X14		;0.1 SEC GATE
	MOVWF	GATE
     CALL      COUNT
     CALL      CNVT      ;CONVERT BINARY TO BCD
	MOVLW	0X30		;TEST IF "0"
	XORWF	19,W
	BTFSS	STATUS,Z
     GOTO      MHZ1
	MOVLW	0X30		;TEST IF "0"
	XORWF	1A,W
	BTFSC	STATUS,Z
     GOTO      KHZ1
MHZ1	MOVLW	0X82		;SET DISPLAY ADDRESS
     CALL      INST
	MOVLW	0X02		;OUTPUT FIRST 2 CHARACTERS
	MOVWF	COUNT1
	MOVLW	0X19		;MSD OF FREQ
	MOVWF	FSR
MHZ2	MOVLW	0X30		;TEST IF "0"
     XORWF     INDF,W
	BTFSS	STATUS,Z
     GOTO      MHZ3
	MOVLW	0X20		;CHANGE PRECEEDING "0'S" TO "SPACE"
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      MHZ2
     GOTO      MHZ4
MHZ3 MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      MHZ3
MHZ4	MOVLW	0X2E		;"."
     CALL      LCD_OUT
	MOVLW	0X05		;OUTPUT LAST 5 CHARACTERS
	MOVWF	COUNT1	
MHZ5 MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      MHZ5
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X4D		;"M"
     CALL      LCD_OUT
	MOVLW	0X48		;"H"
     CALL      LCD_OUT
	MOVLW	0X7A		;"Z"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
     GOTO      MHZ
;----------------------------------- 
KHZ	MOVLW	0X14		;0.1 SEC GATE
	MOVWF	GATE
     CALL      COUNT
     CALL      CNVT      ;CONVERT BINARY TO BCD
	MOVLW	0X30		;TEST IF 0
	XORWF	19,W
	BTFSS	STATUS,Z
     GOTO      MHZ1
	MOVLW	0X32		;TEST IF < 2
	SUBWF	1A,W
	BTFSC	STATUS,C
     GOTO      MHZ1
	MOVLW	0X30		;TEST IF "0"
	XORWF	1A,W
	BTFSS	STATUS,Z
     GOTO      KHZ1
	MOVLW	0X30		;TEST IF "0"
	XORWF	1B,W
	BTFSC	STATUS,Z
     GOTO      XKHZ
KHZ1	MOVLW	0X82		;SET DISPLAY ADDRESS
     CALL      INST
	MOVLW	0X05		;OUTPUT FIRST 5 CHARACTERS
	MOVWF	COUNT1
	MOVLW	0X19		;MSD OF FREQ
	MOVWF	FSR
KHZ2	MOVLW	0X30		;TEST IF "0"
     XORWF     INDF,W
	BTFSS	STATUS,Z
     GOTO      KHZ3
	MOVLW	0X20		;CHANGE PRECEEDING "0'S" TO "SPACE"
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      KHZ2
     GOTO      KHZ4
KHZ3 MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      KHZ3
KHZ4	MOVLW	0X2E		;"."
     CALL      LCD_OUT
     MOVF      INDF,W          ;OUTPUT LAST 2 CHARACTERS
     CALL      LCD_OUT
     INCF      FSR  ,F
     MOVF      INDF,W
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X4B		;"K"
     CALL      LCD_OUT
	MOVLW	0X48		;"H"
     CALL      LCD_OUT
	MOVLW	0X7A		;"Z"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
     GOTO      KHZ
;----------------------------------- 
XKHZ	MOVLW	0XC8		;1 SEC GATE
	MOVWF	GATE
     CALL      COUNT
     CALL      CNVT      ;CONVERT BINARY TO BCD
	MOVLW	0X30		;TEST IF 0
	XORWF	19,W
	BTFSS	STATUS,Z
     GOTO      KHZ
	MOVLW	0X32		;TEST IF < 2
	SUBWF	1A,W
	BTFSC	STATUS,C
     GOTO      KHZ
	MOVLW	0X30		;TEST IF 0
	XORWF	1A,W
	BTFSS	STATUS,Z
     GOTO      XKHZ1
	MOVLW	0X30		;TEST IF 0
	XORWF	1B,W
	BTFSC	STATUS,Z
     GOTO      HZ0
XKHZ1:
     MOVLW     0X82      ;SET DISPLAY ADDRESS
     CALL      INST
	MOVLW	0X04		;OUTPUT FIRST 4 CHARACTERS
	MOVWF	COUNT1
	MOVLW	0X19		;MSD OF FREQ
	MOVWF	FSR
XKHZ2:
     MOVLW     0X30      ;TEST IF "0"
     XORWF     INDF,W
	BTFSS	STATUS,Z
     GOTO      XKHZ3
	MOVLW	0X20		;CHANGE PRECEEDING "0'S" TO "SPACE"
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      XKHZ2
     GOTO      XKHZ4
XKHZ3:
     MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      XKHZ3
XKHZ4:
     MOVLW     0X2E      ;"."
     CALL      LCD_OUT
     MOVF      INDF,W          ;OUTPUT LAST 3 CHARACTERS
     CALL      LCD_OUT
     INCF      FSR  ,F
     MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
     MOVF      INDF,W
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X4B		;"K"
     CALL      LCD_OUT
	MOVLW	0X48		;"H"
     CALL      LCD_OUT
	MOVLW	0X7A		;"Z"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
     GOTO      XKHZ
;----------------------------------- 
HZ	MOVLW	0XC8		;1 SEC GATE
	MOVWF	GATE
     CALL      COUNT
     CALL      CNVT      ;CONVERT BINARY TO BCD
	MOVLW	0X30		;TEST IF "0"
	XORWF	19,W
	BTFSS	STATUS,Z
     GOTO      XKHZ1
	MOVLW	0X30		;TEST IF "0"
	XORWF	1A,W
	BTFSS	STATUS,Z
     GOTO      XKHZ1
	MOVLW	0X32		;TEST IF < 2
	SUBWF	1B,W
	BTFSC	STATUS,C
     GOTO      XKHZ1
HZ0	MOVLW	0X82		;SET DISPLAY ADDRESS
     CALL      INST
	MOVLW	0X07		;OUTPUT FIRST 7 CHARACTERS
	MOVWF	COUNT1
	MOVLW	0X19		;MSD OF FREQ
	MOVWF	FSR
HZ1	MOVLW	0X30		;TEST IF "0"
     XORWF     INDF,W
	BTFSS	STATUS,Z
     GOTO      HZ2
	MOVLW	0X20		;CHANGE PRECEEDING "0'S" TO "SPACE"
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      HZ1
     GOTO      HZ3
HZ2  MOVF      INDF,W
     CALL      LCD_OUT
     INCF      FSR  ,F
	DECFSZ	COUNT1	,F
     GOTO      HZ2
HZ3	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X48		;"H"
     CALL      LCD_OUT
	MOVLW	0X7A		;"Z"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
	MOVLW	0X20		;"SPACE"
     CALL      LCD_OUT
     GOTO      HZ
;----------------------------------- 
OVERFLOW:
     MOVLW     0X01      ;CLEAR DISPLAY
     CALL      INST
	MOVLW	0X84		;DISPLAY ADDRESS
     CALL      INST
	MOVLW	0X4F		;"O"
     CALL      LCD_OUT
	MOVLW	0X76		;"V"
     CALL      LCD_OUT
	MOVLW	0X65		;"E"
     CALL      LCD_OUT
	MOVLW	0X72		;"R"
     CALL      LCD_OUT
	MOVLW	0X66		;"F"
     CALL      LCD_OUT
	MOVLW	0X6C		;"L"
     CALL      LCD_OUT
	MOVLW	0X6F		;"O"
     CALL      LCD_OUT
	MOVLW	0X77		;"W"
     CALL      LCD_OUT
	MOVLW	0X02		;CURSOR AT HOME
     CALL      INST
     GOTO      MHZ
;----------------------------------- 
	END
