#ifndef _DS18S20_H_
#define _DS18S20_H_

#include "oneWire.h"

#define DS18S20_FAMILY_CODE			0x10

#define DS18S20_CONVERT_T			0x44
#define DS18S20_WRITE_SCRATCHPAD		0x4E
#define DS18S20_READ_SCRATCHPAD		0xBE
#define DS18S20_COPY_SCRATCHPAD		0x48
#define DS18S20_RECALL_EE			0xB8
#define DS18S20_READ_POWER_SUPPLY	0xB4	

typedef struct _DS18S20_device_struct {
	unsigned int temperature;
	unsigned char thigh;
	unsigned char tlow;
	unsigned char reserved1;
	unsigned char reserved2;
	unsigned char count_remain;
	unsigned char count_per;
	unsigned char crc;
} DS18S20_device_struct;

typedef union _DS18S20_device {
	DS18S20_device_struct value;
	unsigned char byte[8];
	unsigned int integer[4];
	unsigned long longint[2];
} DS18S20_device;

typedef enum _DS18S20_POWERING {
	DS18S20_PARASITIC = 0,
	DS18S20_EXTERNAL_SUPPPLY = 1,
	DS18S20_NO_POWER
} DS18S20_POWERING;

extern void ds18s20_init(OW_device ow_device);
extern unsigned char ds18s20_get_temperature(OW_device ow_device, float *temperature);
extern void ds18s20_set_powering(DS18S20_POWERING new_ds18s20_powering);
extern DS18S20_POWERING ds18s20_detect_powering(OW_device ow_device);

#endif
