unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    portnyitas: TLabel;
    portsetup: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    modem: TLabel;
    ProgressBar1: TProgressBar;
    Label6: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  RxBufferSize = 256;
  TxBufferSize = 256;

var
  Form1: TForm1;
  ComFile: THandle;
  DeviceName: array[0..80] of Char;
  DCB: TDCB;
  Config: string;
  CommTimeouts: TCommTimeouts;
  fCTS, fDSR, fRING, fRLSD : integer;
  dwModemStatus : DWORD;
  
implementation

{$R *.dfm}

function OpenCOMPort: Boolean; {Az adott port megnyitsa}

begin
   { Els lpsben megnyitjuk a portot olvassra
   s rsra. Ha a port megnyits nem sikerl, akkor
   a funci hamis (false) rtkkel tr vissza.
   }
  StrPCopy(DeviceName, 'COM1:');

  ComFile := CreateFile(DeviceName,
    GENERIC_READ or GENERIC_WRITE,
    0,
    nil,
    OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL,
    0);

  if ComFile = INVALID_HANDLE_VALUE then
    Result := False
  else
    Result := True;
end;


function SetupCOMPort: Boolean; {A port tulajdonsgainak belltsa}
begin
   {Belltjuk az adott com portot Rx s Tx buffert a kommunikci sebessgt,
   paritst s az olvassi-rsi idket. Amennyiben nem sikerl hamis rtkkel
   trnk vissza.
   }
  Result := True;

  if not SetupComm(ComFile, RxBufferSize, TxBufferSize) then Result := False;

  FillMemory(@dcb, sizeof(DCB), 0); {Lekrdezs eltt
                                     nullval tltjk fel a DCB struktrt}

  if not GetCommState(ComFile, DCB) then
    Result := False;

  Config :='baud=9600 parity=n data=8 stop=1';

  if not BuildCommDCB(@Config[1], DCB) then
    Result := False;

  if not SetCommState(ComFile, DCB) then
    Result := False;

  with CommTimeouts do
  begin
    ReadIntervalTimeout         := 0;
    ReadTotalTimeoutMultiplier  := 0;
    ReadTotalTimeoutConstant    := 500;
    WriteTotalTimeoutMultiplier := 0;
    WriteTotalTimeoutConstant   := 500;
  end;

  if not SetCommTimeouts(ComFile, CommTimeouts) then
    Result := False;
end;

// EZ A UNKCI CSAK EGY KIS EXTRA
function GetModemsignal : boolean; {Modem szignljainak lekrdezse}
begin
 result:=true; 
 If not GetCommModemStatus(Comfile,dwModemstatus) then begin
                                                        messagebox(0,'A modem llapot lekrdezse nem sikerlt!','Led kapcsol',MB_ICONERROR);
                                                        result:=false;
                                                        end;
   fCTS:= MS_CTS_ON and dwModemStatus;
   fDSR:= MS_DSR_ON and dwModemStatus;
   fRING:=MS_RING_ON and dwModemStatus;
   fRLSD:=MS_RLSD_ON and dwModemStatus;

  If fCTS<>0 then form1.label1.caption:= form1.label1.caption+' bekapcsolva'
             else form1.label1.caption:= form1.label1.caption+' kikapcsolva';

  If fDSR<>0 then form1.label2.caption:= form1.label2.caption+' bekapcsolva'
             else form1.label2.caption:= form1.label2.caption+' kikapcsolva';

  If fRING<>0 then form1.label3.caption:= form1.label3.caption+' bekapcsolva'
              else form1.label3.caption:= form1.label3.caption+' kikapcsolva';

  If fRLSD<>0 then form1.label4.caption:= form1.label4.caption+' bekapcsolva'
              else form1.label4.caption:= form1.label4.caption+' kikapcsolva';

  form1.label5.caption:= form1.label5.caption+inttohex(dwModemStatus,8);

end;

procedure SendText(s: string); {Szveg kldse a portra}
var
  BytesWritten: DWORD;
begin
   { j sor jelet tesznk a szveg vgre}
  s := s + #13 + #10;
  WriteFile(ComFile, s[1], Length(s), BytesWritten, nil);
end;

procedure Sendbyte(b: byte); {Egy bjt kldse a portra}
var
  egybyte: DWORD;
begin
  WriteFile(ComFile, b,1, egybyte, nil);
end;

function ReadText: string; {Olvass a portrl}
var
  d: array[1..80] of Char;
  s: string;
  BytesRead, i: DWORD;
begin
  Result := '';
  if not ReadFile(ComFile,d,SizeOf(d),BytesRead,nil) then
  begin
    { Hiba kezels }
  end;
  s := '';
  for i := 1 to BytesRead do s := s + d[I];
  Result := s;
end;


procedure CloseCOMPort; { A port bezrsa}
begin
  CloseHandle(ComFile);
end;





procedure TForm1.Button2Click(Sender: TObject);
var
counter : integer;

begin
form1.progressbar1.position:=0;
form1.portnyitas.caption:='Com port megnyitsa:';
form1.portsetup.caption:='Port belltsa:';
form1.label1.caption:='CTS:  ';
form1.label2.caption:='DSR:  ';
form1.label3.caption:='RING: ';
form1.label4.caption:='RLSD: ';
form1.label5.caption:='Modem status: ';

{ Els lpsben megnyitjuk a portot}
If not(opencomport) then begin
                         messagebox(0,'A comport megnyitsa nem sikerlt!','Led kapcsol',MB_ICONERROR);
                         CloseComport;
                         exit;   { A port bezrsa s kilpnk}
                         end;
Form1.portnyitas.Caption:= Form1.portnyitas.Caption+' sikerlt - '+Devicename;

{Kvetkez lpsben belltjuk a megfelel paramtereket}
If not(SetupCOMPort) then begin
                          messagebox(0,'A comport belltsa nem sikerlt!','Led kapcsol',MB_ICONERROR);
                          CloseComport;
                          exit;   { A port bezrsa s kilpnk}
                          end;

Form1.portsetup.Caption:= Form1.portsetup.Caption+' sikerlt - '+config;

for counter:=0 to 500 do begin
                         sendbyte(ord('A')); { Az a bett kldjk el}
                         form1.progressbar1.position:=counter;   { A progressbaron
                                                                jelezzk, hogy hol tartunk}
                         sleep(1); { Vrunk egy millisecundumot}
                         end;
GetModemsignal;
CloseComport; { A port bezrsa}
messagebox(0,'Az adatok elkldve s a port bezrva!','Led kapcsol',MB_ICONINFORMATION);
form1.progressbar1.position:=0;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
Application.Terminate;
end;

end.
