;
;	   ESR  
;                C/ESR meter
;		 
;		1.0
;	 	22/12/2006
;
;	      FLC
;	 , ., 

;	    PIC16F873A
;***************************************************************************************
;* *             *   
;***************************************************************************************

; 1    *  MCLR/Vpp         *  
; 2    *  RA0/AN0          *    (=330)
; 3    *  RA1/AN1          *    (=33)
; 4    *  RA2/AN2/Vref-    *  . Set coeff./Set "0"
; 5    *  RA3/AN3/Vref+    *
; 6    *  RA4/T0CKI        *  .+/Test
; 7    *  RA5/AN4/SS       *  .-
; 8    *  Vss              * GND
; 9    *  OSC1/CLKIN       *  20 
; 10   *  OSC2/CLKOUT      *  20 
; 11   *  RC0/T1OSO/T1CKI  *  , I=10mA
; 12   *  RC1/T1OSI/CCP2   *  
; 13   *  RC2/CCP1         *     
; 14   *  RC3/SCK/SCL      * ."-"  

; 15   *  RC4/SDI/SDA      * ."+"  
; 16   *  RC5/SDO          * ."-"  
; 17   *  RC6/TX/CK        *     
; 18   *  RC7/RX/DT        *
; 19   *  Vss              * +5V
; 20   *  Vdd              * GND
; 21   *  RB0/INT          * LCD_D4
; 22   *  RB1              * LCD_D5
; 23   *  RB2              * LCD_D6
; 24   *  RB3/PGM          * LCD_D7
; 25   *  RB4              * LCD_R/S
; 26   *  RB5              * LCD_E
; 27   *  RB6/PGC          *
; 28   *  RB7/PGD          *

;****************************************************************************************

Port_A_Config	equ 0xFF
; Port A bit equates
Kn_Set  		equ	2
Kn_Plus  		equ 4
Kn_Minus  		equ 5

Port_B_Config	equ b'11000000'

Port_C_Config	equ b'11000100'

; Port C bit equates
Cap_Charge  	equ 0
Cap_Discharge	equ 1
Comp_Up			equ 2
In_N_Gnd		equ 3
In_P_Cx			equ 4
In_N_Cx			equ 5
Comp_Low		equ 6

ESR_ready		equ	b'00110011' ;. , "+"  "-"   
ESR_start		equ b'00110000'	;. , "+"  "-"   
Cap_ready		equ b'00011011'	;. , "-"   , "+"  
Cap_start		equ	b'00011000'	;. , "-"   , "+"  
Cap_start2		equ	b'00110000'	;. , "-"   Cx, "+"  

Max_Count		equ	.70	;  (1 ,   256)  TMR0  
						;  - 0.2 , 65536*0.2=13107.2  -  
						;  I=10mA 15 / 65536/15=4369  -  
						;  =150000, 150000/4369=34
						;        
;****************************************************************************************

	ifdef __16F870
	 list      p=PIC16F870
     #include  P16F870.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F872
	 list      p=PIC16F872
     #include  P16F872.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F873
	 list      p=PIC16F873
     #include  P16F873.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F876
	 list      p=PIC16F876
     #include  P16F876.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F873A
	 list      p=PIC16F873a
     #include  P16F873a.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F876A
	 list      p=PIC16F876a
     #include  P16F876a.inc ;	; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	endif

	ifdef __16F882
	 list      p=PIC16F882
     #include  P16F882.inc ;	; 20.000 MHz
	__CONFIG _CONFIG1, _CP_OFF & _BOR_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _BOR40V
	endif

	ifdef __16F883
	 list      p=PIC16F883
     #include  P16F883.inc ;	; 20.000 MHz
	__CONFIG _CONFIG1, _CP_OFF & _BOR_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _BOR40V
	endif

	ifdef __16F886
	 list      p=PIC16F886
     #include  P16F886.inc ;	; 20.000 MHz
	__CONFIG _CONFIG1, _CP_OFF & _BOR_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _CPD_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _BOR40V
	endif

	errorlevel -302
	ifndef	PORTA
		error	"Incompatible processor selected"
	endif

;	#define	_BAT	PORTA,1		; 0- low bat

	#define	_RS	    PORTB,4
	#define	_E	    PORTB,5

	CBLOCK 0x70
	;	 
	W_TEMP		;   
	STATUS_TEMP
	PCLATH_TEMP
	endc

	CBLOCK 0x35 ;0x20-0x34 for FLOATING POINT LIBRARY

	Dly0  ;Stores 3 bytes of data for the delay count
	Dly1  ;Dly0 is the least significant byte
	Dly2  ;while Dly3 is the most significant byte

;	Temp
	Temp1
	Temp2
	Temp3
	Temp4

	Count1
	Count2

	T0
	T1

	;	 
	T2	;  
	T3
	T4
	T5	;  

	AX	;  
	A0
	A1
	A2	;  

	A3
	A4
	A5

	BCD0	;  
	BCD1
	BCD2
	BCD3
	BCD4	;  
	
	U330_L	;   , =330,  
	U330_H	;   , =330,  
	U33_L	;   , =33,  
	U33_H	;   , =33,  
	
	TMR1_Count	;  TMR1
	TMR0_Count	;  TMR0
	Flags
	EE_ADR ;     EEPROM
	EE_DATA
	NZ	;      
	NC	; 
	Const_ADR ;   EEPROM

	ENDC
	
;=========================
;       
;=========================

Dly24 MACRO DLY
;Take the delay value argument from the macro, precalculate
;the required 3 RAM values and load the The RAM values Dly2,Dly1 
;and Dly0.
	banksel Dly0
	movlw   DLY & H'FF'
	movwf   Dly0
	movlw   DLY >>D'08' & H'FF'
	movwf   Dly1
	movlw   DLY >>D'16' & H'FF'
	movwf   Dly2
;Bytes are shifted and anded by the assembler to make user 
;calculations easier.
	endm
	
;==========================
	
	ORG		0x2100   	;  EEPROM
;					; 	 EEPROM

;   :
USR_1		DE	0x00, 0x00, 0x03, 0xE8	; 1 -  1 
USR_10		DE	0x00, 0x00, 0x03, 0xE8	; 1 -  10 
USR_Cx		DE	0x00, 0x00, 0x03, 0xE8	; 1 -  

;K_ESR_1		DE	0x7F, 0x00, 0x00, 0x00 ; 1 -  1 
;K_ESR_10	DE	0x7F, 0x00, 0x00, 0x00 ; 1 -  10 
;K_Cx		DE	0x7F, 0x00, 0x00, 0x00 ; 1 -  

;numbers in FLOATING POINT LIBRARY format
U0_ESR_1	DE	0x85, 0x16, 0x00, 0x00 ; 75=85160000 - "0"   1 
U0_ESR_10	DE	0x81, 0x60, 0x00, 0x00 ;  7=81600000 - "0"   10 

;   :
M_ESR_1		DE	0x75, 0x40, 0x30, 0x0C ; 1/682=7540300C
M_ESR_10	DE	0x78, 0x74, 0x89, 0x8D ; 1/67=7874898D
M_Cx		DE	0x74, 0x2E, 0xC3, 0x3E ; 1/(15*100)=742EC33E
sub_Cx		DE	0x80, 0x40, 0x00, 0x00 ; 3=80400000 -    TMR1

;==========================
		org 	0x700 ;  256  1-   
Table	addwf	PCL,F
omega	dt	b'00000000'	; 
		dt	b'00001110'
		dt	b'00010001'
		dt	b'00010001'
		dt	b'00010001'
		dt	b'00001010'
		dt	b'00011011'
		dt	b'00000000'
		
mu		dt	b'00000000'
		dt	b'00000000'
		dt	b'00010010'
		dt	b'00010010'
		dt	b'00010010'
		dt	b'00011110'
		dt	b'00010001'
		dt	b'00010000'
_Const	dt	"Coeff. for",0
_ESR	dt	"ESR",0
_Cx		dt	" Cx ",0
_Time_out	dt	"Cx ---",0
_1_ohm	dt	" 1 ",1,0
_10_ohm	dt	" 10 ",1,0
_tst_1	dt	"1",1,"=",0
_tst_10	dt	" 10",1,"=",0
_write_U0	dt	"U0 ---> EEPROM  ",0
_ready	dt	"It is ready!",0

TableEnd
	if (high(TableEnd) != high(Table))
		error	"Table PCL block error"
	endif

;*******************************************************************************
;                              
;******************************************************************************* 	
		org 	0x0000
		nop					;for MPLAB-ICD2
		goto		init

;------------------ Interrupt ------------------
		org		0x0004

		movwf   W_TEMP		;save W
		swapf   STATUS,W	;swap STATUS, W
		clrf	STATUS
		movwf   STATUS_TEMP	;save status
		movf	PCLATH,W
		movwf	PCLATH_TEMP	;save PCLATH
		clrf	PCLATH
		
		decfsz	TMR0_Count,f
		goto	restore_context
		bsf		Flags,0		;Time Out!
		goto	stop_TMR1
		
restore_context
		bcf     INTCON,T0IF	;clear interrupt flag
		
		movf	PCLATH_TEMP,W
		movwf	PCLATH
		swapf	STATUS_TEMP,W	;fetch status, reswap nibbles
		movwf   STATUS			;restore status
		swapf   W_TEMP,F    ;swap nibbles in preparation
		swapf   W_TEMP,W    ;for the swap restoration of w
		retfie				;return from interrupt

;-----------------------------------------------

init
	ifdef	ANSEL
		banksel		ANSEL
		movlw		0x0B
		movwf		ANSEL
		clrf		ANSELH
	endif
		banksel		INTCON
		clrf		Flags
		clrf		INTCON
		clrf		PCLATH
		clrf		PORTA
		clrf		PORTB
		movlw		ESR_ready ;. , "+"  "-"   
		movwf		PORTC

		banksel		TRISA
		movlw		Port_A_Config
		movwf		TRISA
		; 
		movlw		b'10000100'; , Vdd, Vss, AN0, AN1, AN3
		movwf		ADCON1

		movlw		Port_B_Config
		movwf		TRISB
		movlw		Port_C_Config
		movwf		TRISC

		banksel		ADCON0
		movlw		b'10000001' ;Fosc/32,  0,   .
		movwf		ADCON0

;	 LCD  4-  		
InitLCD
        call		Delay_5_ms
        call		Delay_5_ms
        call		Delay_5_ms
        call		Delay_5_ms ; 15    
		movlw		.3
		movwf		Count1
		movwf		PORTB
SetLoop
        call		Send	;  LCD 3    0x30
		call		Delay_5_ms
		decfsz		Count1,f
		goto		SetLoop

		movlw		0x02	; 4-x 
		movwf		PORTB
		call		Send
		movlw		0x28	; 4- , 2 , 57
		call		CmdLCD
		movlw		0x0C	;  
		call		CmdLCD
		movlw		0x06
		call		CmdLCD

		call		Load_ZG	 ;     

		call		Delay_5_ms

		movlw		b'10000000' ; AC in DDRAM=0
		call		CmdLCD

		call		Delay_5_ms
        call		ClrDSP	;  

;--------------------------------------------------
		btfsc		PORTA, Kn_Set ;
		goto		Main
;------------    ------------
		goto		c_1		

Const_Loop
		btfss		PORTA, Kn_Plus
		call		IncB
		btfss		PORTA, Kn_Minus
		call		DecB
		btfsc		PORTA, Kn_Set
		goto		Const_Loop

		btfsc		Flags,5		;  
		call		Save_Const	; ,  		
c_3
		incf		NC,F
		movf		NC,W
		sublw		3	; 
		btfsc		STATUS,Z
c_1		clrf		NC
		bcf			Flags,5		;   
        call		ClrDSP		;  
   		movlw		LOW _Const
		call		Read_String
		movlw 		HIGH Tab1
		movwf 		PCLATH
        movf		NC,W
        addwf		PCL,F ; 
Tab1
        goto		const_1_ohm		;+0
        goto		const_10_ohm	;+1
        goto		const_Cx		;+2
Tab1End
	if (high(Tab1End) != high(Tab1))
		error	"Tab1 PLC block error"
	endif

c_2		call		ShowX
        goto		Const_Loop

const_1_ohm
		movlw		LOW USR_1
		movwf		Const_ADR
		call		EEPROM_To_B
		movlw		LOW _1_ohm
		call		Read_String
		goto		c_2
const_10_ohm
		movlw		LOW USR_10
		movwf		Const_ADR
		call		EEPROM_To_B
		movlw		LOW _10_ohm
		call		Read_String
		goto		c_2
const_Cx		
		movlw		LOW USR_Cx
		movwf		Const_ADR
		call		EEPROM_To_B
		movlw		LOW _Cx
		call		Read_String
		goto		c_2
;-------    ------
Main
;		banksel		ADCON1
;		movlw		b'10000100'; , Vdd, Vss, AN0, AN1, AN3
;		movwf		ADCON1

ESR_measure
		banksel		PORTC
		movlw		ESR_start 	; . , "+"  "-"   
		movwf		PORTC
		
		movlw		0x04		; 3.6 (18 )   . - !!!
		call		Delay_go

		bcf			PORTC, In_P_Cx ;   
		nop			;???
		bsf			PORTC, Cap_Charge ;. I.

		;    .  =330
		banksel		ADCON0
		bcf			ADCON0,CHS0	; Channel 0
		call		Delay_20_us
		bsf			ADCON0,GO	; - 
		btfsc		ADCON0,GO
		goto		$-1			;   
		movf		ADRESH,W
		movwf		U330_H
		banksel		ADRESL
		movf		ADRESL,W
		banksel		U330_L
		movwf		U330_L
		
		;    .  =33
		banksel		ADCON0
		bsf			ADCON0,CHS0	; Channel 1
		call		Delay_20_us
		bsf			ADCON0,GO	; - 
		btfsc		ADCON0,GO
		goto		$-1			;   
		movf		ADRESH,W
		movwf		U33_H
		banksel		ADRESL
		movf		ADRESL,W
		banksel		U33_L
		movwf		U33_L

;------------  ESR>10 ,     ------------
		clrf		Flags
		movlw		0x03
		subwf		U33_H,W		;  >=0x300 (768)
		btfss		STATUS,Z
		goto		Cx_0		;   
		bsf			Flags,0		;  Time Out
		goto		Cx_3
;------------    ------------
Cx_0
		movlw		Cap_ready 	;. , "-"   , "+"  
		movwf		PORTC
		call		TMR0_init	; TMR0      
		
		call		Delay_200_us
		btfss		PORTC, Comp_Low	; 1 - Cx 
		goto		$-2				;  200 
		call		Delay_200_us	;   
		call		TMR1_init

		movlw		0x03
		subwf		U330_H,W	;  >=0x300 (768)
		btfss		STATUS,Z	;.. ESR>1 ,     ESR
		goto		Cx_1
		movlw		Cap_start2	;. , "-"   Cx, "+"  
		movwf		PORTC
		movlw		0x04		; 3.6 (18 )     "-"  
		call		Delay_go
		bcf			PORTC,In_N_Cx	; "-"    
		goto		Cx_2
Cx_1
		movlw		Cap_start 	;. , "-"   , "+"  
		movwf		PORTC
Cx_2		
		btfsc		PORTC, Comp_Low ; 0 - Cx    
		goto		$-1
		bsf			T1CON, TMR1ON	;  

tst_charge
		btfss		PORTC,Comp_Up; 0 - Cx    
		goto		stop_TMR1
		btfsc		PIR1, TMR1IF	; TMR1 ?
		call		Inc_count
		goto		tst_charge

stop_TMR1
		clrf		T1CON	; TMR1
		clrf		INTCON	; 
		btfsc		PIR1, TMR1IF	;     
		call		Inc_count		; 
Cx_3	movlw		Cap_ready ;. , "-"   , "+"  
		movwf		PORTC

;--------------------------------------------------------
;   
;		call		CursorHome
		call		ClrDSP
;Timeout		
		btfss		Flags,0
		goto		Disp_Cx
		movlw		LOW _Time_out
		call		Read_String
		goto		Disp_ESR

;--------------------------------------------------------
		clrf		FPFLAGS
		bsf			FPFLAGS, RND ;    
Disp_Cx
		movlw		LOW _Cx
		call		Read_String

		clrf		AEXP
		movf		TMR1_Count,W
		movwf		AARGB0
		movf		TMR1H,W
		movwf		AARGB1
		movf		TMR1L,W
		movwf		AARGB2
		
		btfsc		PORTA, Kn_Plus
		goto		Calc_Cx
		call		BCD 	;   ,   
		movlw		BCD4	;  
		call		Disp_Full
		goto		Disp_ESR
Calc_Cx		
		call		FLO2424 ;Integer to float conversion
		movlw		low sub_Cx
		call		EEPROM_To_B
		call		FPS24	;A=A-3
		movlw		low M_Cx
		call		EEPROM_To_B
		call		FPM24	;A=A*M_Cx
		movlw		low USR_Cx
		call		X_To_B
		call		INT2424	;Output: 24 bit 2's complement integer right
							;justified in AARGB0, AARGB1, AARGB2
		clrf		AEXP
		call		BCD
		bsf			Flags,1 ;   
		movlw		3
		movwf		NZ		;  ,   0
		bsf			Flags,3	;  .   
				
		movlw		BCD3
		call		DispBCD
		movlw		BCD3	;   10 ,
		call		DispBCD	;    	
		
		movlw		BCD2	;  
		call		DispBCD
		movlw		BCD2	; 
		call		DispBCD

		;     ,   
		btfsc		Flags,1
		goto		next_1
		movlw		","		; 
		call		CharLCD
next_1
		movlw		BCD1	; 
		call		DispBCD
		btfsc		Flags,1 ;    ,
		bsf			Flags,2	;    
		movlw		BCD1	; 
		call		DispBCD

		bcf			Flags,1	;  =0  ,   
		movlw		BCD0	; 
		call		DispBCD
		
		btfss		Flags,2 ;    
		goto		next_2  ;
		bcf			Flags,2	;
		call		DispDot	; 
		movlw		BCD0	; 
		call		DispBCD
next_2
		call		DispSP
		movlw		2		; 
		call		CharLCD
		movlw		"F"
		call		CharLCD
;----------------------------
Disp_ESR
		btfss		PORTA, Kn_Plus
		goto		tst_ESR
		
		bcf			Flags,4 ;   10 		
		movlw		0x03
		subwf		U330_H,W	;  >=0x300 (768)
		btfsc		STATUS,Z	;   (10 )
		goto		chk_10
		
;  1 
		call		ClrA
		movf		U330_H,W ; =330,  1 
		movwf		AARGB0
		movf		U330_L,W
		movwf		AARGB1
		call		FLO1624 ;to 24 bit floating point
		movlw		low U0_ESR_1
		call		EEPROM_To_B
		call		FPS24	;A=A-U0 -   
		movlw		low M_ESR_1
		call		EEPROM_To_B
		call		FPM24	;A=A*M_ESR_1
		movlw		low USR_1
		call		X_To_B
		goto		ESR_to_LCD

chk_10
		movlw		0x03
		subwf		U33_H,W	;  >=0x300 (768)
		btfsc		STATUS,Z
		bsf			Flags,4 ; 10 		

; 10 
		call		ClrA
		movf		U33_H,W ; =33,  10 
		movwf		AARGB0
		movf		U33_L,W
		movwf		AARGB1
		call		FLO1624 ;to 24 bit floating point
		movlw		low U0_ESR_10
		call		EEPROM_To_B
		call		FPS24	;A=A-U0 -   
		movlw		low M_ESR_10
		call		EEPROM_To_B
		call		FPM24	;A=A*M_ESR_10
		movlw		low USR_10
		call		X_To_B

ESR_to_LCD
		call		SecLine
		movlw		LOW _ESR
		call		Read_String
		
		btfss		Flags,4 ;>10 ohm?
		goto		next_3
		movlw		">"
		call		CharLCD
		goto		next_4
next_3	call		DispSP

next_4	movlw		0x80
		andwf		AARGB0,W ;  "-"
		btfsc		STATUS,Z
		goto		next_5	; > 0
		call		ClrA	; < 0,   
		goto		next_6
next_5	call		INT2424

next_6	bcf			Flags,3	;  .   
		bsf			Flags,1 ;   
		clrf		AEXP
		call		BCD

		movlw		BCD2
		call		DispBCD
		movlw		BCD2
		call		DispBCD ; 

		bcf			Flags,1	;  =0  ,   
		movlw		BCD1	; 
		call		DispBCD
		call		DispDot
		movlw		BCD1
		call		DispBCD

		movlw		BCD0
		call		DispBCD
		movlw		BCD0
		call		DispBCD
		
		call		DispSP
		movlw		1				; 
		call		CharLCD
end_disp
		banksel		PORTC
		bsf			PORTC, Cap_Discharge ;.  

		call		Delay_05_sec
		
		banksel		PORTC
		bcf			PORTC, Cap_Discharge ;.  
		
		goto	ESR_measure

;  -    
; 2-  (1  10 )
tst_ESR
		call		SecLine
		; 1 
		movlw		LOW _tst_1
		call		Read_String
		call		ClrA
		movf		U330_H,W ; =330,  1 
		movwf		AARGB1
		movf		U330_L,W
		movwf		AARGB2
		call		BCD
		movlw		BCD1
		call		Disp_Full
		; 10 
		movlw		LOW _tst_10
		call		Read_String
		call		ClrA
		movf		U33_H,W ; =33,  10 
		movwf		AARGB1
		movf		U33_L,W
		movwf		AARGB2
		call		BCD
		movlw		BCD1
		call		Disp_Full
		btfsc		PORTA, Kn_Set	;   
		goto		end_disp
		; U0  EEPROM ------------------------
		call		CursorHome
		movlw		LOW _write_U0
		call		Read_String
		;U0  l 
		call		ClrA
		movf		U330_H,W ; =330,  1 
		movwf		AARGB0
		movf		U330_L,W
		movwf		AARGB1
		call		FLO1624 ;to 24 bit floating point
		call		BEQUA
		movlw		LOW U0_ESR_1
		movwf		Const_ADR
		call		Save_Const
		;U0  l0 
		call		ClrA
		movf		U33_H,W ; =33,  10 
		movwf		AARGB0
		movf		U33_L,W
		movwf		AARGB1
		call		FLO1624 ;to 24 bit floating point
		call		BEQUA
		movlw		LOW U0_ESR_10
		movwf		Const_ADR
		call		Save_Const

		call		Delay_3_sec
		call		ClrDSP
		movlw		LOW _ready
		call		Read_String
		call		Delay_1_sec
		goto		end_disp
;------------------------- TMR1 -------------------------
;  TMR1,   = 0.2 
TMR1_init
		clrf		TMR1L
		clrf		TMR1H
		bcf			PIR1, TMR1IF
		movlw		b'00000000'; 1:1 Fosc/4
		movwf		T1CON
		clrf		TMR1_Count
		return
;------------------------- TMR1 -------------------------
;   TMR1
Inc_count
		bcf			PIR1, TMR1IF	;   
		incfsz		TMR1_Count,F
		return
		bsf			Flags,0	;Time out
		goto 		stop_TMR1;       
;------------------------- TMR0 -------------------------
;  TMR0,   = 0.2 
TMR0_init
		movlw	Max_Count
		movwf	TMR0_Count	;    TMR0
		clrf	TMR0	 ;clear timer
		movlw	OPTION_REG ;Work around the OPTION
		movwf   FSR		;address OPTION_REG -> FSR
		movlw	b'00000111' ; set up timer. 1:256 presc 
		movwf	INDF
		
		bcf		INTCON,T0IF	;clear tmr0 int flag
		bsf		INTCON,T0IE ;enable TMR0 int
		bsf		INTCON,GIE	;enable global interrupts
		clrf	TMR0		;start timer
		return
;------------------------- Delay -------------------------
;	 
Delay_3_sec		; 3 
		Dly24	D'937499'   ; 3/(4/20000000)/16=937500-1=937499
		goto	DoDly24

Delay_2_sec		; 2 
		Dly24	D'624999'   ; 2/(4/20000000)/16=625000-1=624999
		goto	DoDly24

Delay_1_sec		; 1 
		Dly24	D'312499'   ; 1/(4/20000000)/16=312500-1=312499
		goto	DoDly24

Delay_05_sec		; 0.5 
		Dly24	D'156249'   ; 0.5/(4/20000000)/16=156250-1=156249
		goto	DoDly24

Delay_5_ms	; 5 
		Dly24	D'1562'   ; 0.005/(4/20000000)/16=1562.5=1562
		goto	DoDly24
		
Delay_200_us	; 200 
		Dly24	D'62'   ; 0.0002/(4/20000000)/16=62.5=62
;		goto	DoDly24

DoDly24		;16 Tcy per loop
		movlw   H'FF'      ;Start with -1 in W
		addwf   Dly0,F     ;LSB decrement
		btfsc   STATUS,C   ;was the carry flag set?
		clrw               ;If so, 0 is put in W
		addwf   Dly1,F     ;Else, we continue.
		btfsc   STATUS,C
		clrw               ;0 in W
		addwf   Dly2,F
		btfsc   STATUS,C
		clrw               ;0 in W
		movf	Dly0,W     ;Inclusive-OR all variables
		iorwf   Dly1,W     ;together to see if we have reached
		iorwf   Dly2,W     ;0 on all of them.
		btfss   STATUS,Z   ;Test if result of Inclusive-OR's is 0
		goto    DoDly24
		return

Delay_20_us
		movlw		0x1F		; 20 
Delay_go
		movwf		Dly0
		decfsz		Dly0,F
		goto		$-1
		nop
		nop
		return

;---------------------- LCD ---------------------
;	        
SecLine
		movlw		0xC0

;	 
CmdLCD
		bcf		_RS
		goto	SendLCD

;	  ASCII  
NumLCD
		andlw		0x0F		; 
		iorlw		0x30		; ASCII
;	 ASCII 
CharLCD
		bsf		_RS
SendLCD
		movwf	Temp4
		swapf	Temp4, W
		xorwf	PORTB,w
		andlw	0x0F
		xorwf	PORTB,f
		nop
		nop
		bsf		_E
		nop
		nop
		nop
		nop
		bcf		_E
		movf	Temp4, W
		xorwf	PORTB,w
		andlw	0x0F
		xorwf	PORTB,f
Send
		nop
		nop
		bsf		_E
		nop
		nop
		nop
		bcf		_E
		goto		Delay_200_us

CursorHome	movlw		0x02		;    
			goto		LongSend

ClrDSP		movlw		0x01		;  

LongSend	call		CmdLCD
			goto		Delay_5_ms

DispDot		movlw		"."
			goto		CharLCD

Disp0		movlw		"0"
			goto		CharLCD

DispSP		movlw		" "
			goto		CharLCD

;-----------------------------------------------------------
;       LCD
Read_String
			movwf		Count1
			decf		Count1,F ;  
			movlw 		HIGH Table
			movwf 		PCLATH
get_next_s
			movf		Count1,W
			call		Table
			andlw		0xFF	;    
			btfsc		STATUS, Z
			return
			call		CharLCD
			incf		Count1,F
 			goto		get_next_s

;---------------------- Load CGRAM LCD ---------------------
; 
Load_ZG
			movlw		b'01000000' ; AC in CGRAM=0
			call		CmdLCD
			movlw 		HIGH Table
			movwf 		PCLATH
			movlw		.16		;2   8 
			movwf		Count1
			movlw		LOW  omega-1
			movwf		Count2	;  

get_s		call		Table	;   
			call		CharLCD
			incf		Count2,F
			movf		Count2,W
			decfsz		Count1,F
			goto		get_s
			return
;----------------------------------------------------------
;    W   BCD0...4
; 
Disp_Full
			movwf		FSR		;     LCD
next_byte
			swapf		INDF,W
			call		NumLCD
			movf		INDF,W
			call		NumLCD
			;,     BCD0
			movlw		BCD0
			subwf		FSR,W
			btfsc		STATUS,Z
			return
			decf		FSR,F
			goto		next_byte
;---------------------- BCD to LCD ---------------------
;	      
DispBCD
		movwf		FSR
NextNibble
		swapf		INDF,F
		movf		INDF,W
		btfss		Flags,1 ;1 -    
		goto		chk_NZ
		andlw		0x0F
		btfsc		STATUS,Z
		return		; 
		bcf			Flags,1 ;      
chk_NZ
		btfss		Flags,3 ; 1-   NZ ,  - 0
		goto		NumLCD
		movf		NZ,F
		btfsc		STATUS,Z	;=0?
		goto		Disp0	;,  0
		decf		NZ,F	;,    
		call		NumLCD
		return
;---------------------- BCD ---------------------
;	      
BCD		movlw		0x20
		movwf		T1
		clrf		BCD0
		clrf		BCD1
		clrf		BCD2
		clrf		BCD3
		clrf		BCD4

BcdLoop	rlf			AARGB2, F
		rlf			AARGB1, F
		rlf			AARGB0, F
		rlf			AEXP, F

		rlf			BCD0, F
		rlf			BCD1, F
		rlf			BCD2, F
		rlf			BCD3, F
		rlf			BCD4, F
		decfsz		T1, F
		goto		Adjust
		return

Adjust	movlw		.5
		movwf		Count2

		movlw		BCD0
		movwf		FSR
		goto		ADloop+1

ADloop	incf		FSR, F
		call		Adjbcd
		decfsz		Count2, F
		goto		ADloop
		goto		BcdLoop

Adjbcd	movlw		0x03
		addwf		INDF, W
		movwf		T0		
		btfsc		T0, 3		
		movwf		INDF
		movlw		0x30
		addwf		INDF, W
		movwf		T0
		btfsc		T0, 7
		movwf		INDF
		return

;-------------------------------------------------------
;	 " "  (4 ) 
; Temp1 =   -    
; Temp2 =   -    

;CEQUA		movlw		CX		; C=A
Copy_From_A
		movwf		Temp1		; Xw=A
		movlw		AEXP
		movwf		Temp2
		goto		Copy

BEQUA
		movlw		AEXP		; B=A
Copy_To_B
		movwf		Temp2		; B=Xw
		movlw		BEXP
		goto		Copy_B

;AEQUF		movlw		FX		; A=F
Copy_To_A
		movwf		Temp2		; A=Xw
		movlw		AEXP

Copy_B	movwf		Temp1
Copy	movlw		4		;  
		movwf		Count1
Copy_Loop
		movf		Temp2, W
		movwf		FSR
		movf		INDF, W
		movwf		Temp3
		movf		Temp1, W
		movwf		FSR
		movf		Temp3, W
		movwf		INDF
		decf		Temp1, F ;    
		decf		Temp2, F ; 
		decfsz		Count1, F
		goto		Copy_Loop
		return

;-------------------------------------------------------
X_To_B	call		EEPROM_To_B	;   X
		call		ASwapB
		call		FLO2424
		call		FPM24
		return

ASwapB	movlw		T5
		call		Copy_From_A
		movlw		BEXP
		call		Copy_To_A
		movlw		T5
		call		Copy_To_B
		return		
;-------------------------------------------------------
;	    
ClrB	movlw		BEXP	;   
		goto		ClrA+1

ClrA	movlw		AEXP	;   
		movwf		FSR
		movlw		.4		; 
		movwf		Count1

ClrLoop
		clrf		INDF	;  
		decf		FSR, F	;  
		decfsz		Count1, F
		goto		ClrLoop
		return
;-------------------------------------------------------
;	   EEPROM   B
EEPROM_To_B
		movwf		EE_ADR		;    EEPROM
		movlw		BEXP
		movwf		FSR
		movlw		4			; 
		movwf		Count1
EE_read_loop
	    call		ReadEEPROM
		banksel		BEXP
		movwf		INDF
		incf		EE_ADR, F
		decf		FSR, F
		decfsz		Count1, F
		goto		EE_read_loop
		return

;	 EEPROM
ReadEEPROM
		movf		EE_ADR,W ;
		banksel		EEADR	 	; Bank 2
		movwf		EEADR		;   EEPROM
		banksel		EECON1		; Bank3
		bcf			EECON1,EEPGD ; EEPROM 
		bsf			EECON1,RD    ; 
		banksel		EEDATA		; Bank2
		movf		EEDATA,W	; W = EEDATA
		return

;-------------------------------------------------------
;	  BARG  EEPROM
;   EEPROM   Const_ADR
Save_Const
		movf		Const_ADR,W
		movwf		EE_ADR
		movlw		BEXP
		movwf		FSR
		movlw		.4			; 
		movwf		Count1
EE_write_loop
		movf		INDF,W
		movwf		EE_DATA
		call		WriteEEPROM
		banksel		BEXP
		incf		EE_ADR, F
		decf		FSR, F
		decfsz		Count1, F
		goto		EE_write_loop
		return

;	 EEPROM
WriteEEPROM
		movf		EE_ADR,W
		banksel		EEADR		;Bank2
		movwf		EEADR
		banksel		EE_DATA		;Bank0
		movf		EE_DATA,W
		banksel		EEADR		;Bank2
		movwf		EEDATA
		banksel		EECON1		;Bank3
		bcf			EECON1,EEPGD
		bsf			EECON1,WREN
		movlw		0x55
		movwf		EECON2
		movlw		0xAA
		movwf		EECON2
		bsf			EECON1,WR
		btfsc		EECON1,WR
		goto		$-1
		bcf			EECON1,WREN
		return
;-------------------------------------------------------
;	  B
IncB
		bsf			Flags,5	;   
        incf		BARGB2, F
		btfsc		STATUS, Z
		incf		BARGB1, F
		goto		ShowX

;	  B
DecB
		bsf			Flags,5	;   
        movf		BARGB2, F
		btfsc		STATUS, Z
		decf		BARGB1, F
		decf		BARGB2, F

ShowX		
        movlw		BEXP
        call		Copy_To_A
		
		call		BCD
		call		SecLine
		movlw		BCD1
		call		DispBCD
		call		DispDot
		movlw		BCD1
		call		DispBCD
		movlw		BCD0
		call		DispBCD
		movlw		BCD0
		call		DispBCD
		
		call		Delay_05_sec
		return

;=======================================================
;     PIC16 24 BIT FLOATING POINT LIBRARY

#define P16_MAP1 0
#define P16_MAP2 1
        include "math16.inc" 
        include "fp24.a16"   
        
        END

