#include <p18f26k22.h>
#include "valtozok.h"

void InterruptHandlerHigh (void);
void InterruptHandlerLow (void);

void init()
{
	ANSELA=0;
	ANSELB=0;
	ANSELC=0;
	CCP1CON=0;
	CCP2CON=0;
	
	PORTA=0;
	PORTB=0;
	PORTC=0;
	LATA=0;
	LATB=0;
	LATC=0;
	TRISA= 0b00000000;
	TRISB= 0b10000001;
	TRISC= 0b10000000;
	INTCON2=0;
	
	TMR5H= 0;
	TMR5L= 0;
	T5CON= 0b00110001;
	T5GCON= 0b00000000;
	IPR5= 0b00000000;
	PIE5= 0b00000010;
	PIR5bits.TMR5IF=0;
	RCONbits.IPEN=1;
	INTCONbits.GIE=1;
	INTCONbits.PEIE=1;
}

void main()
{
	init();
	lcd_init();
	lcd_puts("HELLO");
	while(1)
	{
		if(!SETBUTTON)
//			Status=0;
//		else
			Status=1;
	}
}


#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh (void)
{
  _asm
    goto InterruptHandlerHigh
  _endasm
}

#pragma code InterruptVectorLow = 0x18
void InterruptVectorLow (void)
{
  _asm
    goto InterruptHandlerLow
  _endasm
}

#pragma code
#pragma interrupt InterruptHandlerHigh
void InterruptHandlerHigh (void)
{

}	

#pragma interruptlow InterruptHandlerLow
void InterruptHandlerLow (void)
{
	if(PIR5bits.TMR5IF)
	{
		szamlalo++;	
		if(szamlalo==1)
		{
			RX2LED=1;
			TX2LED=0;
		}
		if(szamlalo==2)
		{
			RX2LED=0;
			TX2LED=1;
		}
		if(szamlalo==3)
		{
			TX2LED=0;
			Status=1;
		}
		if(szamlalo==4)
		{
			Status=0;
			RX1LED=1;
		}
		if(szamlalo==5)
		{
			RX1LED=0;
			TX1LED=1;
		}
		if(szamlalo==8)
		{
			TX2LED=1;
			Status=0;
			szamlalo=0;
		}
		if(szamlalo==7)
		{
			Status=1;
			RX1LED=0;
		}
		if(szamlalo==6)
		{
			RX1LED=1;
			TX1LED=0;
		}
		TMR5H= 100;
		TMR5L= 250;
		PIR5bits.TMR5IF=0;
	}	
}	
