//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// LCD vezrl rutinok																	//
// Ksztette: Varga Mikls																//
// Utols vltoztats: 2013.02.06.														//
// Verziszm: v2.2																		//
// Programlers: 4x20 karakteres LCD kijelz rsa										//
// Fjlnv: lcd.c																		//
// C fordt program: HI-TECH C PRO for the PIC10/12/16 MCU	v9.70						//
//****************************************************************************************
#include <p18f26k22.h>
#include "LCD_Driver.h"

void delay(unsigned int delayno)
{
	while(delayno)
	{
		delayno--;
		Nop();
	}
}
//****************************************************************************************
// Parancs kldse LCD-re
void lcd_cmd(unsigned char adatcmd)
{
	if (adatcmd&0b00010000) bit1 = 1;
	else bit1=0;
	if (adatcmd&0b00100000) bit2 = 1;
	else bit2=0;
	if (adatcmd&0b01000000) bit3 = 1;
	else bit3=0;
	if (adatcmd&0b10000000) bit4 = 1;
	else bit4=0;
	LCD_RS = 0;
	LCD_EN=1;
	Nop();
	LCD_EN=0;
	if (adatcmd&0b00000001) bit1 = 1;
	else bit1=0;
	if (adatcmd&0b00000010) bit2 = 1;
	else bit2=0;
	if (adatcmd&0b00000100) bit3 = 1;
	else bit3=0;
	if (adatcmd&0b00001000) bit4 = 1;
	else bit4=0;
	LCD_RS = 0;
	LCD_EN=1;
	Nop();
	LCD_EN=0;
	busy();			// vrakots a feldolgozsra
	return;
}

//****************************************************************************************
// Adat klds LCD-re
void lcd_putch(unsigned char adatchar)
{

	if (adatchar&0b00010000) bit1 = 1;
	else bit1=0;
	if (adatchar&0b00100000) bit2 = 1;
	else bit2=0;
	if (adatchar&0b01000000) bit3 = 1;
	else bit3=0;
	if (adatchar&0b10000000) bit4 = 1;
	else bit4=0;
	LCD_RS = 1;
	LCD_EN=1;
	Nop();
	LCD_EN=0;
	if (adatchar&0b00000001) bit1 = 1;
	else bit1=0;
	if (adatchar&0b00000010) bit2 = 1;
	else bit2=0;
	if (adatchar&0b00000100) bit3 = 1;
	else bit3=0;
	if (adatchar&0b00001000) bit4 = 1;
	else bit4=0;
	LCD_RS = 1;
	LCD_EN=1;
	Nop();
	LCD_EN=0;
	busy();			// vrakots a feldolgozsra
	return;
}
//****************************************************************************************
// LCD trlse
void lcd_clear(void)
{	
	lcd_cmd(0x01);
	busy();			// vrakots a feldolgozsra
	return;
}
//****************************************************************************************
// Sztring kiiratsa
void lcd_puts(rom char * s)
{
	while(*s)
	{
		lcd_putch(*s++);
	}
	return;
}
//****************************************************************************************
// Karaktersorozat kiirsa eeprombl
//****************************************************************************************
// Kurzor pozicionlsa
// Bemen paramter a sor, s karakter szma a sorban
void lcd_goto(unsigned char line, unsigned char pos)
{
	if( line==1 ) lcd_cmd(0x7F+pos);
	if( line==2 ) lcd_cmd(0xBF+pos);
	if( line==3 ) lcd_cmd(0x93+pos);
	if( line==4 ) lcd_cmd(0xd3+pos);
	return;
}
//****************************************************************************************
// Decimlis szm kiiratsa
// Bemen paramter a szmjegyek szma, s a szm
void lcd_putdec(unsigned char minus, unsigned char szamjegy, unsigned char tizedes, unsigned int szam)
{
//	if(szam>=0x7fff)
//	{
//		szam=0xffff-szam;
//		minus=1;
//	}
//	unsigned int szam100=((szam/100)%10), szam10=((szam/10)%10), szam1=(szam%10);
	if(szamjegy>=4)
	{
		if( (((szam/1000)%10) ==0 )&&tizedes<3)
		{
			if((minus==1)&!(((szam/100)%10)==0))
				lcd_putch('-');
			else
				lcd_putch(' ');
		}
		else 
		{
			lcd_putch(((szam/1000)%10)+0x30);
		}
		if(tizedes==3) lcd_putch(',');
	}
	if(szamjegy>=3)
	{
		if(((((szam/100)%10)==0)&&(((szam/1000)%10)==0))&&tizedes<2)
		{
			if((minus==1)&!(((szam/10)%10)==0))
				lcd_putch('-');
			else
				lcd_putch(' ');
		}
		else 
		{
			lcd_putch(((szam/100)%10)+0x30);
		}
		if(tizedes==2) lcd_putch(',');
	}
	if(szamjegy>=2)
	{
		if(((((szam/10)%10)==0)&&(((szam/100)%10)==0)&&(((szam/1000)%10)==0))&&tizedes<1)
		{
			if((minus==1))
				lcd_putch('-');
			else
				lcd_putch(' ');
		}
		else 
		{
			lcd_putch(((szam/10)%10)+0x30);
		}
		if(tizedes==1) lcd_putch(',');
	}
	lcd_putch((szam%10)+0x30);
//	minus=0;
	return;
}
void lcd_puthex(unsigned char hex)
{
	unsigned char hexh, hexl;
	hexh=(hex>>4)&0x0f;
	hexl=hex&0x0f;
	if(hexh<=9)
	{
		lcd_putch(hexh+0x30);
	}
	else
	{
		lcd_putch(hexh+0x37);
	}
	if(hexl<=9)
	{
		lcd_putch(hexl+0x30);
	}
	else
	{
		lcd_putch(hexl+0x37);
	}
	//lcd_putch(' ');
	return;
}
//****************************************************************************************
// Kldtt adat feldolgozsnak megvrsa
void busy(void)
{	
	unsigned char busyflag;
	busy_tris = 1;
	do
	{
		Nop();
		Nop();
		Nop();
		LCD_RS = 0;
		LCD_RW = 1;
		LCD_EN=1;
		Nop();
		busyflag = bit4;
		Nop();
		LCD_EN=0;
		LCD_RS = 0;
		LCD_RW = 1;
		LCD_EN=1;
		Nop();
		Nop();
		Nop();
		LCD_EN=0;
	}while(busyflag);
	LCD_RW = 0;
	busy_tris = 0;
	return;
}
//****************************************************************************************
// Fkperny

//****************************************************************************************
// inicializls
void lcd_init(void)
{	
//	TX1LED=1;
	LCD_RS=0;
	LCD_RW=0;
	LCD_EN=0;
	delay(65200);
	lcd_cmd(0x20);
	lcd_cmd(0x28);
	lcd_cmd(0x06);
	lcd_cmd(0x0c);
	lcd_clear();
	lcd_cmd(0x40);
	lcd_puts(sajatkarakter);
	lcd_cmd(0x0c);

	return;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
