  //ICR1 = 10,000 gives f = 100Hz
  //ICR1 = 5000 gives f = 200Hz
  //ICR1 = 2500 gives f = 500Hz
  //ICR1 = 1000 gives f = 1kHz
  //ICR1 = 500 gives f = 2kHz
   //ICR1 = 333 gives f = 3kHz
   //ICR1 = 250 gives f = 4kHz
//ICR1 = 100 gives f = 1kHz
//ICR1 = 10 gives f = 10kHz

#include <avr\io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include "lcd.h"

volatile unsigned int  i, counter, bufferUsedSpace, minSampleTime;
volatile int pwm_dysp;
volatile unsigned long  samplesPos;
char int2str[12];

void pwm_plus_F (void);
void pwm_minusz_F (void);
void pwm_plus (void);
void pwm_minusz (void);
//void checkIncreaseButton (void);
void printCapturedData (unsigned long position, unsigned char inputChannel);
void printRuler (void);
void saveSampleToBuffer (void);
void checkInputs (void);
void sendChannelsDataOnLCD (void);
void getNextSampleString (void);


#define BUFFER_SIZE  870  // 290 Sample transitions * 3 bytes for each sample = 870 bytes.
#define POSITIONS_LENGTH 19004860 //BUFFER_SIZE * (MAX_SAMPLE_TIME/3) = (870/3) * 65534 = 19004860
#define ONE_LINE_LENGTH  84
#define MAX_SAMPLE_TIME 65534


int main(void) {

	lcd_init();

	_delay_ms(100);

lcd_contrast(0x10);



	lcd_clear();
	lcd_contrast(0x10);

	

	samplesPos = 0;
	bufferUsedSpace = 0;
	pwm_dysp = 0;
    minSampleTime = MAX_SAMPLE_TIME;




DDRD=0x00;
PORTD=0xFF;
PORTC=0xFF;
DDRB=0xFF;

ICR1=300;

TCCR1A|=(0<<COM1A0)|(1<<COM1A1)|(0<<COM1B0)|(0<<COM1B1)|

(0<<FOC1A)|(0<<FOC1B)|(1<<WGM11)|(0<<WGM10);

TCCR1B|=(0<<ICNC1)|(0<<ICES1)|(1<<WGM13)|(1<<WGM12)|

(1<<CS12)|(0<<CS11)|(0<<CS10);


OCR1A=0;
for (;;) {
		pwm_plus();
        pwm_minusz();
        
        pwm_plus_F();
        pwm_minusz_F();
        

  
}

}

//----------------------------------

void pwm_plus (void)
{
	unsigned int w;
	char str1[10];
	char str2[10];
	
	if(bit_is_clear(PIND,0))
	{
		while(bit_is_clear(PIND,0));
	    if(OCR1A<256)OCR1A+=5;

       
		if(pwm_dysp<50) {pwm_dysp+=1;}
		
		lcd_clear_area(1,61,83);
		itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int2str,"%s.%s", str1, str2);
		w = strlen(int2str);
		lcd_goto_xy(13 - w,1);
		lcd_str(int2str);
        lcd_goto_xy(14,1);
		lcd_str("V");
		
		loop_until_bit_is_set(PIND, 0);
	}	
}



void pwm_minusz (void)
{
	unsigned int w;
    char str1[10];
	char str2[10];

	if(bit_is_clear(PIND,1))
	{
		while(bit_is_clear(PIND,1));
		if(OCR1A>0) OCR1A-=5;
	

		if(pwm_dysp>0) {pwm_dysp-=1;}
		lcd_clear_area(1,61,83);
	    itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int2str,"%s.%s", str1, str2);
		w = strlen(int2str);
		lcd_goto_xy(13 - w,1);
		lcd_str(int2str);
        lcd_goto_xy(14,1);
		lcd_str("V");
      		loop_until_bit_is_set(PIND, 1);	
	}
}

void pwm_minusz_F (void)
{
	unsigned int w;
    char str1[10];
	char str2[10];

	if(bit_is_clear(PIND,3))
	{
		while(bit_is_clear(PIND,3));
		if(ICR1>400) ICR1-=100;
	

		if(pwm_dysp>0) {pwm_dysp-=1;}
		lcd_clear_area(2,61,83);
	    itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int2str,"%s.%s", str1, str2);
		w = strlen(int2str);
		lcd_goto_xy(13 - w,2);
		lcd_str(int2str);
        lcd_goto_xy(14,2);
		lcd_str("V");
      		loop_until_bit_is_set(PIND, 1);	
	}
}



void pwm_plus_F (void)
{
	unsigned int w;
	char str1[10];
	char str2[10];
	
	if(bit_is_clear(PIND,2))
	{
		while(bit_is_clear(PIND,2));
         if(ICR1<0)ICR1+=100;

       
		if(pwm_dysp<50) {pwm_dysp+=1;}
		
		lcd_clear_area(2,61,83);
		itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int2str,"%s.%s", str1, str2);
		w = strlen(int2str);
		lcd_goto_xy(13 - w,2);
		lcd_str(int2str);
        lcd_goto_xy(14,2);
		lcd_str("V");
		
		loop_until_bit_is_set(PIND, 0);
	}	
}
