/*
 * rgb.c
 *
 * Created: 2013.03.04. 18:30:46
 *  Author: Pzsmaa
 */ 

#include <avr/io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include "lcd.h"
void pwm_plus_r (void);
void pwm_minus_r (void);
void pwm_plus_g (void);
void pwm_minus_g (void);
void pwm_plus_b (void);
void pwm_minus_b (void);



volatile int pwm_dysp;
volatile int pwm_dysp2;
volatile int pwm_dysp3;
char int1str[10];
char int2str[10];
char int3str[10];



int main(void)
{
	DDRB= (1<<PINB1) | (1<<PINB2) | (1<<PINB3);
    DDRD=0x00;
    PORTD=0xFF;

	TCCR1A|=(1<<COM1A1)|(0<<COM1A0)|(1<<COM1B1)|(0<<COM1B0)|(1<<COM2A1)|(0<<COM2A0)|(1<<WGM10);
	TCCR1B|=(1<<WGM12)|(1<<CS11);
	TCCR2A|=(1<<COM2A1)|(0<<COM2A0)|(1<<WGM20)|(1<<WGM21);
	TCCR2B|=(1<<CS21);
	
	lcd_init();
	
	_delay_ms(100);
	
	lcd_contrast(0x10);
	
	lcd_clear();


	pwm_dysp = 0;
    pwm_dysp2 = 0;
    pwm_dysp3 = 0;

    while(1)
    {  
	pwm_plus_r();
	pwm_minus_r();
	pwm_plus_g();
	pwm_minus_g();
	pwm_plus_b();
	pwm_minus_b();
		
		}	
};

void pwm_plus_r(void) 
{
	unsigned int w;
	char str1[10];
	char str2[10];
	
	if(bit_is_clear(PIND,0))
	{
		while(bit_is_clear(PIND,0)){
	    if(OCR1A<255)OCR1A+=5;
       
		if(pwm_dysp<50) {pwm_dysp+=1;}
		
		lcd_clear_area(1,61,83);
		itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int1str,"%s.%s", str1, str2);
		w = strlen(int1str);
		lcd_goto_xy(13 - w,1);
		lcd_str(int1str);
        lcd_goto_xy(14,1);
		lcd_str("V");
_delay_ms(20);		
		};
	
   }
};



void pwm_minus_r (void)  
{
	unsigned int w;
	char str1[10];
	char str2[10];
	
	if(bit_is_clear(PIND,1))
	{
		while(bit_is_clear(PIND,1)){
	    if(OCR1A>0)OCR1A-=5;
       
		if(pwm_dysp>0) {pwm_dysp-=1;}
		
		lcd_clear_area(1,61,83);
		itoa(pwm_dysp/10,str1,10);
		itoa(pwm_dysp%10,str2,10);
		sprintf(int1str,"%s.%s", str1, str2);
		w = strlen(int1str);
		lcd_goto_xy(13 - w,1);
		lcd_str(int1str);
        lcd_goto_xy(14,1);
		lcd_str("V");
_delay_ms(20);		
		}};
	
};





void pwm_plus_g(void)
{
unsigned int W;
    char str3[10];
	char str4[10];

	if(bit_is_clear(PIND,2))
	{
		while(bit_is_clear(PIND,2)){
		if(OCR2A<255) OCR2A+=5;
	

		if(pwm_dysp2<50) {pwm_dysp2+=1;}
		lcd_clear_area(2,61,83);
	    itoa(pwm_dysp2/10,str3,10);
		itoa(pwm_dysp2%10,str4,10);
		sprintf(int2str,"%s.%s", str3, str4);
		W = strlen(int2str);
		lcd_goto_xy(13 - W,2);
		lcd_str(int2str);
        lcd_goto_xy(14,2);
		lcd_str("V");
      		
  _delay_ms(20);

	};}

};



void pwm_minus_g(void)
{
unsigned int W;
    char str3[10];
	char str4[10];

	if(bit_is_clear(PIND,3))
	{
		while(bit_is_clear(PIND,3)){
		if(OCR2A>0) OCR2A-=5;
	

		if(pwm_dysp2>0) {pwm_dysp2-=1;}
		lcd_clear_area(2,61,83);
	    itoa(pwm_dysp2/10,str3,10);
		itoa(pwm_dysp2%10,str4,10);
		sprintf(int2str,"%s.%s", str3, str4);
		W = strlen(int2str);
		lcd_goto_xy(13 - W,2);
		lcd_str(int2str);
        lcd_goto_xy(14,2);
		lcd_str("V");
      		
  _delay_ms(20);

	};}
	};


void pwm_plus_b(void)
{
unsigned int A;
    char str5[10];
	char str6[10];

	if(bit_is_clear(PIND,4))
	{
		while(bit_is_clear(PIND,4)){
		if(OCR1B<255) OCR1B+=5;
	

		if(pwm_dysp3<50) {pwm_dysp3+=1;}
		lcd_clear_area(3,61,83);
	    itoa(pwm_dysp3/10,str5,10);
		itoa(pwm_dysp3%10,str6,10);
		sprintf(int3str,"%s.%s", str5, str6);
		A = strlen(int3str);
		lcd_goto_xy(13 - A,3);
		lcd_str(int3str);
        lcd_goto_xy(14,3);
		lcd_str("V");
      		
  _delay_ms(20);

	};}

};


void pwm_minus_b(void)
{
unsigned int A;
    char str5[10];
	char str6[10];

	if(bit_is_clear(PIND,5))
	{
		while(bit_is_clear(PIND,5)){
		if(OCR1B>0) OCR1B-=5;
	

		if(pwm_dysp3>0) {pwm_dysp3-=1;}
		lcd_clear_area(3,61,83);
	    itoa(pwm_dysp3/10,str5,10);
		itoa(pwm_dysp3%10,str6,10);
		sprintf(int3str,"%s.%s", str5, str6);
		A = strlen(int3str);
		lcd_goto_xy(13 - A,3);
		lcd_str(int3str);
        lcd_goto_xy(14,3);
		lcd_str("V");
      		
  _delay_ms(20);

	};}
	};




