/***************************************************************************
* Optical Encoder 1x-es dekdols demo V1.1
*
* Csords Attila *** www.egyeni.hu *** mail: info@egyeni.hu *** 2010.01.24.
* 
* Processzor : ATmega8
* Clock      : bels RC oszcilltor 8 MHz
* A program lefordthat AvrStudio4 s WinAvr pros segtsgvel
*
* Lb kioszts:
*
* LCD : 2x16  -> PORTB 0...6 pin lsd az LCD lb kioszts belltsst az lcd.h fjlban
*
*
* Optical Encoder : Channel A : PORTD 2-es PIN INT0 (input)
*                   Channel Z : PORTD 3-as PIN INT1 (input)
*                   Channel B : PORTD 4-es PIN (input)
*
* A felhz ellenllsok aktvak az encoder bemeneti lbain!
* Nyitott kollektoros kimenete van az encodernek!
*
***************************************************************************/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay_basic.h>
#include "lcd.h"
#include <stdlib.h>

//A maximlis felbonts -1. Mivel a 0-s pozici is lpsnek szmt
#define ENCODER_RESOLUTION 32767   // ez a plafon ezutn tlcsordul negatv tartomnybl szmol vissza
#define NULLAZAS 0

#define ENCODER_PORT PIND
#define ENCODER_CHANNEL_A_PIN 2
#define ENCODER_CHANNEL_B_PIN 4
#define ENCODER_CHANNEL_Z_PIN 3  // nullzo bemenet

// #define F_CPU = 8000000

#define MAGAS 1
#define ALACSONY 0

#define INT0_LE_EL  MCUCR |= (1<<ISC01); MCUCR &= ~(1<<ISC00); //INT0 bemenet a lefut lre generl megszaktst
#define INT0_FEL_EL MCUCR |= (1<<ISC01)|(1<<ISC00) //INT0 bemenet a felfut lre generl megszaktst
#define INT1_LE_EL  MCUCR |= (1<<ISC11); MCUCR &= ~(1<<ISC10); //INT1 bemenet a lefut lre generl megszaktst
#define INT1_FEL_EL MCUCR |= (1<<ISC11)|(1<<ISC10) //INT1 bemenet a felfut lre generl megszaktst

char mini[16];


//Globlis vltozk. Amiket megszaktsbl is szeretnnk elrni
volatile uint8_t  index_jel = ALACSONY;
volatile uint64_t counter;

/*********************************************
* Buffer trl
*
* Funkci:
* a paramterben megadott cmtl kezdve 15
* bytot trl (szkzzel tlt fel)
**********************************************/
void buffer_clear(char* buffer){
	 for(;*buffer;*(buffer++)=' ');
	  //pointeres memria kezels. Ha nagyon nem rthet ez a sor, semmi baj.
	  //de azrt rdemes utnna nzni a C nyelv pointereinek, ha valaki komolyan akar foglalkozni C-vel
}


//F kd
int main() {

    uint64_t counter_tmp;
    char buf[16];
	buf[15] ='\0'; //lezr 0 a vgre
	buffer_clear(&buf[0]);

    DDRB = (1<<DDB0)|(1<<DDB1)|(1<<DDB2)|(1<<DDB3)|(1<<DDB4)|(1<<DDB5)|(1<<DDB6); // B port 0,1,2,3,4,5,6 -os PIN input
	DDRD = (0<<DDD2)|(0<<DDD3)|(0<<DDD4)|(1<<DDB6)|(1<<DDB7); // D port 2,3,4 -es PIN input, 6, 7 kimenet
	PORTD = (1<<DDD2)|(1<<DDD3)|(1<<DDD4); //felhz ellenllsok 

	GIMSK |= (1<<INT1)|(1<<INT0); //Megszakts maszk regiszter belltsa INT1 s INT0 aktv
	
	lcd_init(LCD_DISP_ON);
    lcd_clrscr();
   

    INT0_FEL_EL; //INT0 megszakts felfut l rzkeny lesz
	INT1_FEL_EL; //INT1 megszakts felfut l rzkeny lesz
	
	sei();
	
	while(1)
	{
	  lcd_clrscr();          //LCD trls
      lcd_gotoxy(0,0);		//kurzor mozgats 
      lcd_puts("Pozicio");	//kirats
      lcd_gotoxy(11,0);       //kurzor mozgats
	  counter_tmp = counter; //mivel megszaktsbl a counter vltozt folyamatosan lltgatjuk gy inkbb a kiirats eltt lemsoljuk az rtkt, mivel j eslyel meg fog vltozni kiirs kzben is
      itoa(counter_tmp,buf,10); //int -> sztring konverzi
	  lcd_puts(buf);            //sztring kiraks LCD-re
	  lcd_gotoxy(0,1);       //kurzor mozgats
	  lcd_puts("Cel");


	  lcd_gotoxy(14,1);       //kurzor mozgats
	  lcd_puts("mm");
	  _delay_loop_2(0x3fff);    //vrunk j sokat
	  buffer_clear(&buf[0]);    //trljk a sztring buffert
	}
}

ISR(INT0_vect) //Channel A megszakts
{
 _delay_loop_1(0x0f);    //vrunk egy keveset
 if(ENCODER_PORT & (1<<ENCODER_CHANNEL_A_PIN))  //magas szinten van a Channel A? hardveres prell mentests helyett
 {
  if(ENCODER_PORT & (1<<ENCODER_CHANNEL_B_PIN))  //magas szinten van a Channel B?
  {
   if(index_jel) //azrt van itt az index jel vltoz figyelse, hogy biztos ne cssszon el a szmlls
   {
    index_jel = ALACSONY;
    counter = NULLAZAS;    //EREDETI:ENCODER_RESOLUTION;    itt nullzuk a szamllot
   } 
   else
    counter--; //visszafell mozgott a trcsa, cskken a lps szm
  }
  else //alacsony szinten van a Channel B
  {
   if(index_jel) //azrt van itt az index jel vltoz figyelse, hogy biztos ne cssszon el a szmlls
   {
    index_jel = ALACSONY;
    counter = 0;
   } 
   else  
    counter++; //elrefell mozgott a trcsa, cskken a lps szm
  }
 }
}

ISR(INT1_vect) //Channel Z megszakts
{
 index_jel = MAGAS; //csak a vltozt lltjuk t
}
