#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include <util/delay.h>
#include <stdlib.h>

#include "usbdrv/usbdrv.h"
#include "usbdrv/oddebug.h"

#define USB_IS_DATA_READY 0
#define USB_SEND_DATA 1
#define PAYLOAD_SIZE 65536

static uint16_t bytesSent = 0;
static uchar replyByte = 0;

uint8_t highLow = 0;

USB_PUBLIC uchar usbFunctionSetup(uchar data[8])
{
	usbRequest_t *rq = (void *)data;

	switch(rq->bRequest)
	{
		case USB_IS_DATA_READY:
							usbMsgPtr = &replyByte;
							return 1;
		case USB_SEND_DATA:	
							if (bytesSent == PAYLOAD_SIZE) bytesSent = 0;
							replyByte = 0;
							return USB_NO_MSG;
	}

    return 0;
}

USB_PUBLIC uchar usbFunctionRead(uchar *data, uchar len)
{
	uint8_t byteCnt;

	for(byteCnt = 0; (byteCnt < len) && (bytesSent < PAYLOAD_SIZE); byteCnt++)
	{
		highLow ^= 1;
		data[byteCnt] = (highLow) ? bytesSent >> 8 : (bytesSent - 1) & 0xFF;
		bytesSent++;
	}

	return byteCnt;
}

int main(void)
{
	DDRA = (1<<PINA1);
	PORTA = (1<<PINA0);

	DDRD = ~USBMASK;
	usbDeviceDisconnect();
	_delay_ms(512);
	usbDeviceConnect();
	usbInit();

	sei();
	        
	for(;;)
	{
	    usbPoll();
		if(!(PINA & (1<<PINA0))) replyByte = 1;
	}

	return 0;
}
