﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using LibUsbDotNet;
using LibUsbDotNet.Main;

namespace usbtest
{
    public partial class Form1 : Form
    {
    	private const int USB_VID = 0x03EB;
        private const int USB_PID = 0x01DB;
        private const byte REQ_IN = (byte)UsbRequestType.TypeVendor | (byte)UsbRequestRecipient.RecipDevice | (byte)UsbEndpointDirection.EndpointIn;
        private const byte USB_IS_DATA_READY = 0;
        private const byte USB_SEND_DATA = 1;
        private const int PAYLOAD_SIZE = 65536;
        private const short CHUNK_SIZE = 128;
        
        private UsbDevice MyUsbDevice;
        private int[] dataBuffer;     
        
        public Form1()
        {
            InitializeComponent();
      		dataBuffer = new int[PAYLOAD_SIZE];
      		
            UsbDeviceFinder MyUsbFinder;
            MyUsbFinder = new UsbDeviceFinder(USB_VID, USB_PID);
            MyUsbDevice = UsbDevice.OpenUsbDevice(MyUsbFinder);
            if (!IsConnected) throw new Exception("Failed to access USB device");
        }

        private bool IsConnected
        {
            get
            {
                if (MyUsbDevice == null)
                    return false;

                if (MyUsbDevice.IsOpen == false || MyUsbDevice.UsbRegistryInfo.IsAlive == false)
                {
                    ForceClose();
                    return false;
                }

                return true;
            }
        }

        public void ForceClose()
        {
            try
            {
                MyUsbDevice.Close();
            }
            catch
            {
            }
            finally
            {
                MyUsbDevice = null;
            }
        }
       
        private void transferData()
        {
        	byte[] buffer = new byte[CHUNK_SIZE];
            int lengthTransferred;
            
            isReadyTmr.Enabled = false;
            transferLbl.Visible = true;
            dataPvw.Text = "";
            dataPvw.Refresh();
            transferLbl.Refresh();
            
        	UsbSetupPacket packet = new UsbSetupPacket(REQ_IN, USB_SEND_DATA, 0, 0, CHUNK_SIZE);
            for(int chunkCnt = 0; chunkCnt < PAYLOAD_SIZE / CHUNK_SIZE; chunkCnt++)
            {
            	MyUsbDevice.ControlTransfer(ref packet, buffer, buffer.Length, out lengthTransferred);
            	for(int byteCnt = 0; byteCnt < CHUNK_SIZE; byteCnt++)
        			dataBuffer[chunkCnt * CHUNK_SIZE + byteCnt] = buffer[byteCnt];
            }
            
            transferLbl.Visible = false;
            transferLbl.Refresh();
            isReadyTmr.Enabled = true;

            StringBuilder strBldr = new StringBuilder();
            for(int cnt = 0; cnt < PAYLOAD_SIZE / 2 + 2; cnt += 2)
            	strBldr.AppendFormat("{0}\r\n", (dataBuffer[cnt] << 8) + dataBuffer[cnt + 1], cnt);
            dataPvw.Text = strBldr.ToString();
        }
        
        private void startTransferBtn_Click(object sender, EventArgs e)
        {
        	byte[] buffer = new byte[1];
            int lengthTransferred;
            
            UsbSetupPacket packet = new UsbSetupPacket(REQ_IN, USB_IS_DATA_READY, 0, 0, 1);
            MyUsbDevice.ControlTransfer(ref packet, buffer, buffer.Length, out lengthTransferred);
            if(lengthTransferred < 1 || buffer[0] != 1)
            {
            	MessageBox.Show("Device not ready.");
            	return;
            }
            else transferData();
        }
        
        void IsReadyTmrTick(object sender, EventArgs e)
        {
        	byte[] buffer = new byte[1];
            int lengthTransferred;
            
            UsbSetupPacket packet = new UsbSetupPacket(REQ_IN, USB_IS_DATA_READY, 0, 0, 1);
            MyUsbDevice.ControlTransfer(ref packet, buffer, buffer.Length, out lengthTransferred);
            if(buffer[0] == 1) transferData();
        }
    }
}
