Attribute VB_Name = "modLiveSpec"
'///////////////////////////////////////////////////////////////////////////
' modLiveSpec.bas - Copyright (c) 2002-2004 JOBnik! [Arthur Aminov, ISRAEL]
' Other source: frmLiveSpec.frm
' BASS "Live" spectrum analyser example
' Originally translated from - livespec.c - Example of Ian Luck
'///////////////////////////////////////////////////////////////////////////
' Filename : LED-MATRIX 5*16
' Revision : 1.0
' Author: Rubashka Vasiliy , Ukraine
'///////////////////////////////////////////////////////////////////////////

Option Explicit
Public Const BI_RGB = 0&
Public Const DIB_RGB_COLORS = 0&    'color table in RGBs

Public Type BITMAPINFOHEADER    '40 bytes
        biSize As Long
        biWidth As Long
        biHeight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type

Public Type RGBQUAD
        rgbBlue As Byte
        rgbGreen As Byte
        rgbRed As Byte
        rgbReserved As Byte
End Type

Public Type BITMAPINFO
        bmiHeader As BITMAPINFOHEADER
        bmiColors(255) As RGBQUAD
End Type

Public Declare Function SetDIBitsToDevice Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal dx As Long, ByVal dy As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal Scan As Long, ByVal NumScans As Long, Bits As Any, BitsInfo As BITMAPINFO, ByVal wUsage As Long) As Long

Public SPECWIDTH As Long    'display width
Public SPECHEIGHT As Long   'height (changing requires palette adjustments too)
Public specpos As Integer   'spectrum mode (and marker pos for 2nd mode)
Public specbuf() As Byte    'a pointer

Public chan As Long         'recording channel
Public Level As Long
Public Left1 As Long
Public Right1 As Long
Public LR As Integer
Public RL As Integer
Public st As Integer
Public Spektr1 As Integer
Public Spektr2 As Integer
Public Spektr3 As Integer
Public Spektr4 As Integer
Public Spektr5 As Integer
Public Spektr6 As Integer
Public Spektr7 As Integer
Public Spektr8 As Integer
Public Spektr9 As Integer
Public Spektr10 As Integer
Public Spektr11 As Integer
Public Spektr12 As Integer
Public Spektr13 As Integer
Public Spektr14 As Integer
Public Spektr15 As Integer
Public Spektr16 As Integer
Public bh As BITMAPINFO     'bitmap header

Public Function Sqrt(ByVal num As Double) As Double
    Sqrt = num ^ 0.5
End Function

'update the spectrum display - the interesting bit :)
Public Sub UpdateSpectrum()
    Static quietcount As Integer
    Dim X As Long, Y As Long, Y1 As Long
    Dim fft(1024) As Single     'get the FFT data
    Call BASS_ChannelGetData(chan, fft(0), BASS_DATA_FFT2048)

        ReDim specbuf(SPECWIDTH * (SPECHEIGHT + 1)) As Byte  'clear display
        RL = 0
        For X = 0 To (SPECWIDTH / 2) - 1
            Y = Sqrt(fft(X + 1)) * 3 * SPECHEIGHT - 4 'scale it (sqrt to make low values more visible)
RL = RL + Y
st = st + 1
If st = 10 Then
Spektr1 = RL / 10
RL = 0
End If
If st = 20 Then
Spektr2 = RL / 10
RL = 0
End If
If st = 30 Then
Spektr3 = RL / 10
RL = 0
End If
If st = 40 Then
Spektr4 = RL / 10
RL = 0
End If
If st = 50 Then
Spektr5 = RL / 10
RL = 0
End If
If st = 60 Then
Spektr6 = RL / 10
RL = 0
End If
If st = 70 Then
Spektr7 = RL / 10
RL = 0
End If
If st = 80 Then
Spektr8 = RL / 10
RL = 0
End If
If st = 90 Then
Spektr9 = RL / 10
RL = 0
End If
If st = 100 Then
Spektr10 = RL / 10
RL = 0
End If
If st = 110 Then
Spektr11 = RL / 10
RL = 0
End If
If st = 120 Then
Spektr12 = RL / 10
RL = 0
End If
If st = 130 Then
Spektr13 = RL / 10
RL = 0
End If
If st = 140 Then
Spektr14 = RL / 10
RL = 0
End If
If st = 150 Then
Spektr15 = RL / 10
RL = 0
End If
If st = 160 Then
Spektr16 = RL / 10
RL = 0
st = 0
End If

            If (Y > SPECHEIGHT) Then Y = SPECHEIGHT 'cap it
            If (X) Then  'interpolate from previous to make the display smoother
                Y1 = (Y + Y1) / 2
                Y1 = Y1 - 1
                While (Y1 >= 0)
                    specbuf(Y1 * SPECWIDTH + X * 2 - 1) = Y1 + 1
                    Y1 = Y1 - 1
                Wend
            End If
            Y1 = Y
            Y = Y - 1
            While (Y >= 0)
                specbuf(Y * SPECWIDTH + X * 2) = Y + 1 'draw level
                Y = Y - 1
                
            Wend
        Next X
   

    'display the update
    'to display in a PictureBox, simply change the .hDC to Picture1.hDC :)
    Call SetDIBitsToDevice(frmLiveSpec.hdc, 17, 0, SPECWIDTH, SPECHEIGHT, 0, 20, 0, SPECHEIGHT, specbuf(0), bh, 0)
    If ((Y1 < 3) And (Y < 3)) Then 'check if it's quiet
        quietcount = quietcount + 1
        If (quietcount > 40 And (quietcount And 16)) Then 'it's been quiet for over a second
           Dim sNoise As String
            sNoise = "make some noise!"
            With frmLiveSpec
                .ForeColor = &HFFFFFF
                .CurrentX = (SPECWIDTH - .TextWidth(sNoise)) / 2
                .CurrentY = (SPECHEIGHT - .TextHeight(sNoise)) / 2
                frmLiveSpec.Print sNoise
            End With
        End If
    Else
        quietcount = 0 'not quiet
    End If
End Sub

'Recording callback - not doing anything with the data
Public Function DuffRecording(ByVal handle As Long, ByVal buffer As Long, ByVal length As Long, ByVal user As Long) As Integer
    DuffRecording = BASSTRUE 'continue recording
End Function

