		list	b=4
;******************************************************************************
;                         DIGITAL FREQUENCY COUNTER
;                           
;                           Author : Vicsys
;                           
;                           Version: 1.0
;
;                           Http://freki.atw.hu
;
;                           
;
;      lines 337 to 453 are an example of where to add personal introductory   
;      lines and should be omitted or changed to your own                   
;******************************************************************************
;
		errorlevel	-302
;
	ifdef	__16F84A	
		list p=16f84a
		include <p16f84a.inc>
		__CONFIG _CP_OFF & _WDT_OFF & _XT_OSC & _PWRTE_ON
rambeg	EQU	0x0C
	endif
	ifdef	__16F84	
		list p=16f84
		include <p16f84.inc>
		__CONFIG _CP_OFF & _WDT_OFF & _XT_OSC & _PWRTE_ON
rambeg	EQU	0x0C
	endif
;
	ifdef	__16F628A	
		list p=16f628a
		include <p16f628a.inc>
		__CONFIG _CP_OFF & _WDT_OFF & _XT_OSC & _PWRTE_ON & _LVP_OFF
rambeg	EQU	0x20
	endif
	ifdef	__16F628	
		list p=16f628
		include <p16f628.inc>
		__CONFIG _CP_OFF & _WDT_OFF & _XT_OSC & _PWRTE_ON & _LVP_OFF
rambeg	EQU	0x20
	endif
;
;
MSB	equ	7h
LSB	equ	0h
;
cnt	equ	2h  
rs	equ	2h
rw	equ	1h
e	equ	0h
o	equ	7h
;
		cblock	rambeg
gate
cnt1
cnt2
cnt3
calc1
calc2
calc3
sum1
sum2
sum3
TMR02

count1
count2
count3
count4
in_reg
addcnt
disptype
BCD:8
status2
		endc



	org	0
  ifdef	CMCON
	movlw	7
	movwf	CMCON
  endif
	goto	start
			
	org	4
	retfie

;
int_del
	movlw	0x05			;delay 5.000 ms (4 MHz clock)
	movwf	count1
d1	movlw	0xA5
	movwf	count2
d2	decfsz	count2	,f
	goto	d2
	decfsz	count1	,f
	goto	d1
	retlw	0x00
;
lcd_out
	movwf	PORTB			;load data into PORTB
	bsf		STATUS,RP0  	; select Register-Page 1**************************
	movlw	b'00000000'		;define PORTB as output
	movwf	TRISB
	bcf		STATUS,RP0 		; select Register-Page 0 ************************
	bsf		PORTA,rs		;rs = data
	bcf		PORTA,rw		;r/w = write
	bsf		PORTA,e		;toggle enable
	bcf		PORTA,e
	bsf		STATUS,RP0  	; select Register-Page 1**************************
	movlw	b'11111111'		;define PORTB as input
	movwf	TRISB
	bcf		STATUS,RP0 	 	; select Register-Page 0 ************************
	bcf		PORTA,rs		;rs = instruction
	bsf		PORTA,rw		;r/w = read
	bsf		PORTA,e		;enable high
	movf	PORTB,w		;get address counter
	movwf	addcnt
	bsf		addcnt,7
	bcf		PORTA,e		;enable low
out1
	bsf		PORTA,e		;enable high
	btfss	PORTB,7		;test busy flag
	goto	out2
	bcf		PORTA,e		;enable low
	goto	out1
out2
	bcf		PORTA,e		;enable low

	btfsc	disptype,7
	return

shift						;shift to opposite side of display?
	movf	addcnt,w
	xorlw	0x08
	btfss	STATUS,Z
	return

	xorlw	0x48
	movwf	addcnt
	iorlw	0x80

inst
	movwf	PORTB			;load instruction into PORTB
	bsf		STATUS,RP0 		; select Register-Page 1**************************
	movlw	b'00000000'		;define PORTB as output
	movwf	TRISB
	bcf		STATUS,RP0 	 	; select Register-Page 0 ************************
	bcf		PORTA,rs		;rs = instruction
	bcf		PORTA,rw		;r/w = write
	bsf		PORTA,e		;toggle enable
	bcf		PORTA,e
	bsf		STATUS,RP0 		; select Register-Page 1**************************
	movlw	b'11111111'		;define PORTB as input
	movwf	TRISB
	bcf		STATUS,RP0 		; select Register-Page 0 ************************
	bsf		PORTA,rw		;r/w = read
inst1
	bsf		PORTA,e		;enable high
	btfss	PORTB,7		;test busy flag
	goto	inst2
	bcf		PORTA,e		;enable low
	goto	inst1
inst2
	bcf		PORTA,e		;enable low
	retlw	0x00
;


sub
	bcf		status2,o		;clear overflow bit
	movf	calc1,w			;subtract calc1 from cnt1 
	subwf	cnt1,f
	btfsc	STATUS,C
	goto	sb1
	movlw	0x01			;borrow from cnt2 if overflow
	subwf	cnt2,f
	btfsc	STATUS,C
	goto	sb1
	subwf	cnt3,f			;borrow from cnt3 if cnt2 overflow
	btfss	STATUS,C
	bsf		status2,o		;set overflow bit if result is negative
sb1	movf	calc2,w			;subtract calc2 from cnt2
	subwf	cnt2,f
	btfsc	STATUS,C
	goto	sb2
	movlw	0x01			;borrow from cnt3 if cnt2 overflow
	subwf	cnt3,f
	btfss	STATUS,C
	bsf		status2,o		;set overflow bit if result is negative
sb2	movf	calc3,w			;subtract calc3 from cnt3
	subwf	cnt3,f
	btfss	STATUS,C
	bsf		status2,o		;set overflow bit if result is negative
	retlw	0x00


add
	movf	calc1,w			;add calc1 to cnt1
	addwf	cnt1,f
	btfss	STATUS,C
	goto	ad1
	incfsz	cnt2,f			;add to cnt2 if cnt1 overflow
	goto	ad1
	incf	cnt3,f			;add to cnt3 if cnt2 overflow
ad1	movf	calc2,w			;add calc2 to cnt2
	addwf	cnt2,f
	btfsc	STATUS,C
	incf	cnt3,f			;add to cnt3 if cnt2 overflow
	movf	calc3,w			;add calc3 to cnt3
	addwf	cnt3,f
	retlw	0x00
;
cnvt
; Az eredmny 32 szerezse
	MOVLW	.5
	MOVWF	FSR
cnvl
	BCF		STATUS,C
	RLF		cnt1,f
	RLF		cnt2,f
	RLF		cnt3,f
	DECFSZ	FSR,F
	GOTO	cnvl
;

	movlw	0x07			;7 digits in display
	movwf	count1
	movlw	BCD				;set FSR for MSB in display
	movwf	FSR
	movlw	0x2F			;one less that ASCII "0"
cnvt0
	movwf	INDF
	incf	FSR,f
	decfsz	count1,f
	goto	cnvt0
	movlw	BCD				;set FSR for MSB in display
	movwf	FSR
	movlw	0x0F			;load "1,000,000" in calc1-3
	movwf	calc3
	movlw	0x42
	movwf	calc2
	movlw	0x40
	movwf	calc1
cnvt1
	call	sub				;subtract number from count
	incf	INDF,f			;increment 1,000,000's register
	movlw	0x3A
	xorwf	INDF,w
	btfsc	STATUS,Z
	goto	overflow
	btfss	status2,o		;check if overflow
	goto	cnvt1
	call	add				;add back last number
	movlw	0x01			;load "100,000" in calc1-3
	movwf	calc3
	movlw	0x86
	movwf	calc2
	movlw	0xA0
	movwf	calc1
	incf	FSR,f
cnvt2
	call	sub				;subtract number from count
	incf	INDF,f			;increment 100,000's register
	btfss	status2,o		;check if overflow
	goto	cnvt2
	call	add				;add back last number
	clrf	calc3			;load "10,000" in calc1-3
	movlw	0x27
	movwf	calc2
	movlw	0x10
	movwf	calc1
	incf	FSR,f
cnvt3
	call	sub				;subtract number from count
	incf	INDF,f			;increment 10,000's register
	btfss	status2,o		;check if overflow
	goto	cnvt3
	call	add				;add back last number
	movlw	0x03			;load "1,000" in calc1-3
	movwf	calc2
	movlw	0xE8
	movwf	calc1
	incf	FSR,f
cnvt4
	call	sub				;subtract number from count
	incf	INDF,f			;increment 1,000's register
	btfss	status2,o		;check if overflow
	goto	cnvt4
	call	add				;add back last number
	clrf	calc2			;load "100" in calc1-3
	movlw	0x64
	movwf	calc1
	incf	FSR,f
cnvt5
	call	sub				;subtract number from count
	incf	INDF,f			;increment 100's register
	btfss	status2,o		;check if overflow
	goto	cnvt5
	call	add				;add back number
	movlw	0x0A			;load "10" in calc1-3
	movwf	calc1
	incf	FSR,f
cnvt6
	call	sub				;subtract number from count
	incf	INDF,f			;increment 10's register
	btfss	status2,o		;check if overflow
	goto	cnvt6
	call	add				;add back last number
	movf	cnt1,w			;put remaINDFer in 1's register
	addwf	INDF,f
	retlw	0x00
;
count
	bsf   	STATUS,RP0 		; select Register-Page 1 ********************
	movlw	b'00110111'		;TMR0 = ext, 1/256
	movwf	OPTION_REG		;************************ITT************
	movlw	b'00010000'		;define PORTA as output 
	movwf	TRISA
	bcf 	STATUS,RP0  	 	; select Register-Page 0 ********************
	bcf		PORTA,3
	bcf		PORTA,2
	clrf	cnt3
	clrf	TMR0
	clrf	TMR02
	bsf		PORTA,2			;toggle TMR0 pin
	bcf		PORTA,2
	movf	gate,w			;get gate time
	movwf	count1
	bsf		PORTA,3			;start count
fr4
	movlw	0xFA
	movwf	count2
	goto	fr6
fr5
	nop
	nop
	nop
	nop
	nop
	nop
fr6
	movf	TMR0,w			;test for TMR0 rollover (12)
	subwf	TMR02,f
	btfss	STATUS,Z
	goto	fr7
	nop
	goto	fr8
fr7
	btfsc	STATUS,C
	incf	cnt3,f
fr8
	movwf	TMR02
	nop
	nop
	nop
	decfsz	count2,f
	goto	fr5
	decfsz	count1,f
	goto	fr4
	bcf		PORTA,3			;stop count
	movf	TMR0,w			;get TMR0 count
	movwf	cnt2
	subwf	TMR02,f			;test for TMR0 rollover
	btfss	STATUS,C
	goto	fr9
	btfss	STATUS,Z
	incf	cnt3,f
fr9
	clrf	cnt1			;set to get prescaler count
fr10
	decf	cnt1,f
	bsf		PORTA,2			;toggle TMR0 pin
	bcf		PORTA,2
	movf	TMR0,w			;test if TMR0 has changed
	xorwf	cnt2,w
	btfsc	STATUS,Z
	goto	fr10
	retlw	0x00
;
;******************************************************************************
;                                   START
;******************************************************************************
;
start
	movf	PORTB,w
	movwf	disptype

	clrf	PORTA			;instruction, write, enable low
	bsf   	STATUS,RP0   	; select Register-Page 1 ****************************
	movlw	b'00010000'
	movwf	TRISA
	bcf   	STATUS,RP0   	; select Register-Page 0 ****************************
	clrf	PORTB
	bsf   	STATUS,RP0   	; select Register-Page 1
	movlw	b'00000000'
	movwf	TRISB
	bcf   	STATUS,RP0 	  	; select Register-Page 0 ****************************
	call	int_del
	call	int_del
	call	int_del
	movlw	0x38			;initialize display 
	movwf	PORTB
	bsf		PORTA,e		;toggle enable
	call	int_del
	bcf		PORTA,e
	bsf		PORTA,e		;toggle enable
	call	int_del
	bcf		PORTA,e
	bsf		PORTA,e		;toggle enable
	call	int_del
	bcf		PORTA,e
	bcf		PORTB,4		;function
	call	inst
	movlw	b'00001100'		;display on, cursor off
	call	inst
	movlw	b'00000001'		;clear display
	call	inst
	movlw	b'00000110'		;entry mode
	call	inst
							;  new lines here for intro 
    movlw   0x20			;space
	call	lcd_out
    movlw   0x20			;space
	call	lcd_out
    movlw   0x56			;V
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
    movlw   0x63			;c
	call	lcd_out
    movlw   0x73			;s
	call	lcd_out
    movlw   0x79			;y
	call	lcd_out
    movlw   0x73			;s
	call	lcd_out
    movlw   0x20			;space
	call	lcd_out
    movlw   0x76			;v
	call	lcd_out
    movlw   0x2e			;.
	call	lcd_out
    movlw   0x31			;1
	call	lcd_out
    movlw   0x2e			;.
	call	lcd_out
    movlw   0x30			;0
	call	lcd_out
    movlw   0x20			;space
	call	lcd_out
	movlw	0x06  			;change the 6 to a smaller No. to speed up the intro
	movwf	count3		
wait1
	movlw	0xc8
	movwf	count4
wait2
	call	int_del
	decfsz	count4	,f
	goto	wait2
	decfsz	count3	,f
	goto	wait1

	movlw	b'00000001'		;clear display
	call	inst
	movlw	b'00000110'		;entry mode
	call	inst
    movlw   0x20			;space
	call	lcd_out
    movlw   0x20			;space
	call	lcd_out
    movlw   0x49			;I
	call	lcd_out
    movlw   0x6e			;n
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
    movlw   0x74			;t
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
    movlw   0x61			;a
	call	lcd_out
    movlw   0x6c			;l
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
	movlw   0x7a			;z
	call	lcd_out 
    movlw   0x69			;i
	call	lcd_out
    movlw   0x6e			;n
	call	lcd_out
    movlw   0x67			;g
	call	lcd_out
    movlw   0x2e			;.
	call	lcd_out
 	movlw	0x06
	movwf	count3
wait3
	movlw	0xc8
	movwf	count4
wait4
	call	int_del
	decfsz	count4	,f
	goto	wait4
	decfsz	count3	,f
	goto	wait3

	movlw	b'00000001'		;clear display
	call	inst
	movlw	b'00000110'		;entry mode
	call	inst
    movlw   0x49			;I
	call	lcd_out
    movlw   0x6e			;n
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
    movlw   0x74			;t
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
    movlw   0x61			;a
	call	lcd_out
    movlw   0x6c			;l
	call	lcd_out
    movlw   0x69			;i
	call	lcd_out
	movlw   0x7a			;z
	call	lcd_out 
    movlw   0x69			;i
	call	lcd_out
    movlw   0x6e			;n
	call	lcd_out
    movlw   0x67			;g
	call	lcd_out
    movlw   0x2e			;.
	call	lcd_out
    movlw   0x20			;space
	call	lcd_out
	movlw	0x06
	movwf	count3
wait5
	movlw	0xc8
	movwf	count4
wait6
	call	int_del
	decfsz	count4	,f
	goto	wait6
	decfsz	count3	,f
	goto	wait5
	movlw	b'00000001'		;clear display
	call	inst
	movlw	b'00000110'		;entry mode
	call	inst
	goto	xkhz

;
;mhz
;	movlw	0x14			;0.1 sec gate
;	movwf	gate
;	call	count
;	call	cnvt			;convert binary to BCD
;	movlw	0x30			;test if "0"
;	xorwf	BCD,w
;	btfss	STATUS,Z
;	goto	mhz1
;	movlw	0x30			;test if "0"
;	xorwf	BCD+1,w
;	btfsc	STATUS,Z
;	goto	khz1
;mhz1
;	movlw	0x82			;set display address
;	call	inst
;	movlw	0x02			;output first 2 characters
;	movwf	count1
;	movlw	0x19			;MSD of freq
;	movwf	FSR
;mhz2
;	movlw	0x30			;test if "0"
;	xorwf	INDF,w
;	btfss	STATUS,Z
;	goto	mhz3
;	movlw	0x20			;change preceeding "0's" to "space"
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	mhz2
;	goto	mhz4
;mhz3
;	movf	INDF,w
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	mhz3
;mhz4
;	movlw	0x2E			;"."
;	call	lcd_out
;	movlw	0x05			;output last 5 characters
;	movwf	count1	
;mhz5
;	movf	INDF,w
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	mhz5
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x4D			;"M"
;	call	lcd_out
;	movlw	0x48			;"H"
;	call	lcd_out
;	movlw	0x7A			;"z"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	goto	mhz
;;
;khz
;	movlw	0x14			;0.1 sec gate
;	movwf	gate
;	call	count
;	call	cnvt			;convert binary to BCD
;	movlw	0x30			;test if 0
;	xorwf	BCD,w
;	btfss	STATUS,Z
;	goto	mhz1
;	movlw	0x32			;test if &lt; 2
;	subwf	BCD+1,w
;	btfsc	STATUS,C
;	goto	mhz1
;	movlw	0x30			;test if "0"
;	xorwf	BCD+1,w
;	btfss	STATUS,Z
;	goto	khz1
;	movlw	0x30			;test if "0"
;	xorwf	BCD+2,w
;	btfsc	STATUS,Z
;	goto	xkhz
;khz1
;	movlw	0x82			;set display address
;	call	inst
;	movlw	0x05			;output first 5 characters
;	movwf	count1
;	movlw	BCD				;MSD of freq
;	movwf	FSR
;khz2
;	movlw	0x30			;test if "0"
;	xorwf	INDF,w
;	btfss	STATUS,Z
;	goto	khz3
;	movlw	0x20			;change preceeding "0's" to "space"
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	khz2
;	goto	khz4
;khz3
;	movf	INDF,w
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	khz3
;khz4
;	movlw	0x2E			;"."
;	call	lcd_out
;	movf	INDF,w			;output last 2 characters
;	call	lcd_out
;	incf	FSR	,f
;	movf	INDF,w
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x4B			;"K"
;	call	lcd_out
;	movlw	0x48			;"H"
;	call	lcd_out
;	movlw	0x7A			;"z"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	goto	khz
;;
xkhz
	movlw	0xC8			;1 sec gate
	movwf	gate
	call	count
	call	cnvt			;convert binary to BCD
;	movlw	0x30			;test if 0
;	xorwf	BCD,w
;	btfss	STATUS,Z
;	goto	khz
;	movlw	0x32			;test if &lt; 2
;	subwf	BCD+1,w
;	btfsc	STATUS,C
;	goto	khz
;	movlw	0x30			;test if 0
;	xorwf	BCD+1,w
;	btfss	STATUS,Z
;	goto	xkhz1
;	movlw	0x30			;test if 0
;	xorwf	BCD+2,w
;	btfsc	STATUS,Z
;	goto	hz0
xkhz1
	movlw	0x82			;set display address
	call	inst
	movlw	0x03			;output first 3 characters
	movwf	count1
	movlw	BCD				;MSD of freq
	movwf	FSR
xkhz2
	movlw	0x30			;test if "0"
	xorwf	INDF,w
	btfss	STATUS,Z
	goto	xkhz3
	movlw	0x20			;change preceeding "0's" to "space"
	call	lcd_out
	incf	FSR	,f
	decfsz	count1,f
	goto	xkhz2
	goto	xkhz4
xkhz3
	movf	INDF,w
	call	lcd_out
	incf	FSR	,f
	decfsz	count1,f
	goto	xkhz3
xkhz4
	movlw	0x2E			;"."
	call	lcd_out
	movf	INDF,w			;output last 3 characters
	call	lcd_out
	incf	FSR	,f
	movf	INDF,w
	call	lcd_out
	incf	FSR	,f
	movf	INDF,w
	call	lcd_out
	movlw	0x20			;"space"
	call	lcd_out
	movlw	0x4B			;"B"
	call	lcd_out
	movlw	0x48			;"a"
	call	lcd_out
	movlw	"r"				;"r"
	call	lcd_out
	movlw	0x20			;"space"
	call	lcd_out
	movlw	0x20			;"space"
	call	lcd_out
	goto	xkhz
;
;hz
;	movlw	0xC8			;1 sec gate
;	movwf	gate
;	call	count
;	call	cnvt			;convert binary to BCD
;	movlw	0x30			;test if "0"
;	xorwf	BCD,w
;	btfss	STATUS,Z
;	goto	xkhz1
;	movlw	0x30			;test if "0"
;	xorwf	BCD+1,w
;	btfss	STATUS,Z
;	goto	xkhz1
;	movlw	0x32			;test if &lt; 2
;	subwf	BCD+2,w
;	btfsc	STATUS,C
;	goto	xkhz1
;hz0
;	movlw	0x82			;set display address
;	call	inst
;	movlw	0x07			;output first 7 characters
;	movwf	count1
;	movlw	0x19			;MSD of freq
;	movwf	FSR
;hz1
;	movlw	0x30			;test if "0"
;	xorwf	INDF,w
;	btfss	STATUS,Z
;	goto	hz2
;	movlw	0x20			;change preceeding "0's" to "space"
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	hz1
;	goto	hz3
;hz2
;	movf	INDF,w
;	call	lcd_out
;	incf	FSR	,f
;	decfsz	count1	,f
;	goto	hz2
;hz3
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x48			;"H"
;	call	lcd_out
;	movlw	0x7A			;"z"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	movlw	0x20			;"space"
;	call	lcd_out
;	goto	hz
;;
overflow
	movlw	0x01			;clear display
	call	inst
	movlw	0x84			;display address
	call	inst
	movlw	0x4F			;"O"
	call	lcd_out
	movlw	0x76			;"v"
	call	lcd_out
	movlw	0x65			;"e"
	call	lcd_out
	movlw	0x72			;"r"
	call	lcd_out
	movlw	0x66			;"f"
	call	lcd_out
	movlw	0x6C			;"l"
	call	lcd_out
	movlw	0x6F			;"o"
	call	lcd_out
	movlw	0x77			;"w"
	call	lcd_out
	movlw	0x02			;cursor at home
	call	inst
;	goto	mhz
	goto	xkhz
;
	end
