using System;
using Microsoft.SPOT;
using System.Threading;
using Microsoft.SPOT.Hardware;

namespace test
{
    public class MemsThread
    {
        static SPI m_spi = new SPI
        (new SPI.Configuration
            (
                Cpu.Pin.GPIO_NONE,
                false,
                0,
                0,
                false,
                true,
                1000,
                SPI.SPI_module.SPI1
            )
        );
        static byte[] m_buffer = new byte[2];

        private Thread m_workerThread;

        //
        // Constructor
        //
        public MemsThread()
        {
            // thread
            m_workerThread = new Thread(this.DoWork);
        }

        //
        // Start
        //
        public void Start()
        {
            m_workerThread.Start();

            // Loop until worker thread activates.
            while (!m_workerThread.IsAlive);
        }

        //
        // WriteRegister
        //
        private void WriteRegister(byte regNum, byte value)
        {
            m_buffer[0] = regNum;
            m_buffer[1] = value;
            m_spi.Write(m_buffer);
        }

        //
        // Working Thread
        //
        private void DoWork()
        {
            //long ms;
            //long ticks;

            while (true)
            {
                //ticks = DateTime.Now.Ticks;
                //for (int i = 0; i < 1000; i++)
                //{
                //    WriteRegister(5, 100);
                //}
                //ticks = DateTime.Now.Ticks - ticks;
                //ms = ticks / TimeSpan.TicksPerMillisecond;
                //Debug.Print("Time: " + ms.ToString() + " ms");
                Thread.Sleep(3000);
            }
        }
    }
}
// 3x foglalas = 454ms
// 2x foglalas = 102ms
// 1x foglalas = 98ms  (~98 us/iras)
