using System;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.IO;
using Microsoft.SPOT.Hardware;

namespace test
{
    public class Control
    {
        private MBSerialSlave m_mbSerSlaveThread;
        private MBSerialMaster m_mbSerMasterThread;
        private MemsThread m_memsThread;

        private static OutputPort m_led2 = null;
        private static OutputPort m_led3 = null;
        private static OutputPort m_led4 = null;

        private Int32 m_delay = 400;

        //
        // Constructor
        //
        public Control()
        {
            //Debug.Print(Resources.GetString(Resources.StringResources.String1));

            DateTime now = new DateTime(2013, 03, 23, 21, 0, 0);
            Utility.SetLocalTime(now);

            Debug.Print
            (
                "SlowClock: " + Cpu.SlowClock.ToString()
                + ", SystemClock: " + Cpu.SystemClock.ToString()
                + ", GlitchFilterTime: " + Cpu.GlitchFilterTime.ToString()
                + ", SystemInfo.OEMString: " + SystemInfo.OEMString
                + ", SystemInfo.Version: " + SystemInfo.Version.ToString()
            );

            Cpu.Pin msk, miso, mosi;
            Microsoft.SPOT.Hardware.STM32F4.STM32F4HardwareProvider.HwProvider.GetSpiPins
            (
                SPI.SPI_module.SPI1, out msk, out miso, out mosi
            );
            //msk(clk): A5, miso: A6, mosi: A7
            Debug.Print
            (
                "msk: " + msk.ToString() + ", miso: " + miso.ToString() + ", mosi: " + mosi.ToString()
            );

            //
            // query serial ports
            //
            // 1: RX: A10, TX: A9
            // 2: RX: A3,  TX: A2     free (master)
            // 3: RX: D9,  TX: D8     free (slave)
            // 4: RX: C11, TX: C10
            // 5: RX: D2,  TX: C12
            // 6: RX: C7,  TX: C6
            Cpu.Pin com_rx, com_tx, com_cts, com_rts;
            for (int i = 0; i < 6; i++)
            {
                String comPort;
                switch (i)
                {
                    case 0:  comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM1; break;
                    case 1:  comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM2; break;
                    case 2:  comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM3; break;
                    case 3:  comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM4; break;
                    case 4:  comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM5; break;
                    default: comPort = Microsoft.SPOT.Hardware.STM32F4.SerialPorts.COM6; break;
                }
                Microsoft.SPOT.Hardware.STM32F4.STM32F4HardwareProvider.HwProvider.GetSerialPins
                (
                    comPort,
                    out com_rx,
                    out com_tx,
                    out com_cts,
                    out com_rts
                );
                Debug.Print
                (
                    (i+1).ToString() + ": RX: " + com_rx.ToString() + ", TX: " + com_tx.ToString()
                );
            }

            m_led2 = new OutputPort(Microsoft.SPOT.Hardware.STM32F4.Pins.GPIO_PIN_D_13, false);
            m_led3 = new OutputPort(Microsoft.SPOT.Hardware.STM32F4.Pins.GPIO_PIN_D_14, false);
            m_led4 = new OutputPort(Microsoft.SPOT.Hardware.STM32F4.Pins.GPIO_PIN_D_15, false);

            // Start new modbus serial slave (server) thread
            m_mbSerSlaveThread = new MBSerialSlave();
            m_mbSerSlaveThread.Start();

            // Start new modbus serial master (client) thread
            m_mbSerMasterThread = new MBSerialMaster();
            m_mbSerMasterThread.Start();

            // Start new MEMS thread
            m_memsThread = new MemsThread();
            m_memsThread.Start();

            // get fileSystem(s)
            //string[] availFs = VolumeInfo.GetFileSystems();
            //if (availFs.Length == 0)
            //{
            //    Debug.Print("No FS found");
            //    return;
            //}

            //foreach (string fs in availFs)
            //    Debug.Print("Available FS: " + fs);

            //VolumeInfo[] volumes = VolumeInfo.GetVolumes();
            //if (volumes.Length == 0)
            //{
            //    Debug.Print("No volumes found");
            //    return;
            //}

            //foreach (VolumeInfo volume in volumes)
            //    Debug.Print("Volume: " + volume.Name);
        }

        //
        // Run
        //
        public void Run()
        {
            m_led2.Write(true);
            Thread.Sleep(m_delay);
            m_led2.Write(false);

            m_led3.Write(true);
            Thread.Sleep(m_delay);
            m_led3.Write(false);

            m_led4.Write(true);
            Thread.Sleep(m_delay);
            m_led4.Write(false);

            //uint freeMem = Debug.GC(false);
            //Debug.Print("freeMem: " + freeMem.ToString());
        }
    }
}
